/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.util.quantization;

import guideme.internal.shaded.lucene.index.VectorSimilarityFunction;
import guideme.internal.shaded.lucene.util.VectorUtil;

public interface ScalarQuantizedVectorSimilarity {
    public static ScalarQuantizedVectorSimilarity fromVectorSimilarity(VectorSimilarityFunction sim, float constMultiplier, byte bits) {
        switch (sim) {
            case EUCLIDEAN: {
                return new Euclidean(constMultiplier);
            }
            case COSINE: 
            case DOT_PRODUCT: {
                if (bits <= 4) {
                    return new DotProduct(constMultiplier, VectorUtil::int4DotProduct);
                }
                return new DotProduct(constMultiplier, VectorUtil::dotProduct);
            }
            case MAXIMUM_INNER_PRODUCT: {
                if (bits <= 4) {
                    return new MaximumInnerProduct(constMultiplier, VectorUtil::int4DotProduct);
                }
                return new MaximumInnerProduct(constMultiplier, VectorUtil::dotProduct);
            }
        }
        throw new IllegalArgumentException("Unsupported similarity function: " + sim);
    }

    public float score(byte[] var1, float var2, byte[] var3, float var4);

    public static interface ByteVectorComparator {
        public int compare(byte[] var1, byte[] var2);
    }

    public static class MaximumInnerProduct
    implements ScalarQuantizedVectorSimilarity {
        private final float constMultiplier;
        private final ByteVectorComparator comparator;

        public MaximumInnerProduct(float constMultiplier, ByteVectorComparator comparator) {
            this.constMultiplier = constMultiplier;
            this.comparator = comparator;
        }

        @Override
        public float score(byte[] queryVector, float queryOffset, byte[] storedVector, float vectorOffset) {
            int dotProduct = this.comparator.compare(storedVector, queryVector);
            assert (dotProduct >= 0);
            float adjustedDistance = (float)dotProduct * this.constMultiplier + queryOffset + vectorOffset;
            return VectorUtil.scaleMaxInnerProductScore(adjustedDistance);
        }
    }

    public static class DotProduct
    implements ScalarQuantizedVectorSimilarity {
        private final float constMultiplier;
        private final ByteVectorComparator comparator;

        public DotProduct(float constMultiplier, ByteVectorComparator comparator) {
            this.constMultiplier = constMultiplier;
            this.comparator = comparator;
        }

        @Override
        public float score(byte[] queryVector, float queryOffset, byte[] storedVector, float vectorOffset) {
            int dotProduct = this.comparator.compare(storedVector, queryVector);
            assert (dotProduct >= 0);
            float adjustedDistance = (float)dotProduct * this.constMultiplier + queryOffset + vectorOffset;
            return Math.max((1.0f + adjustedDistance) / 2.0f, 0.0f);
        }
    }

    public static class Euclidean
    implements ScalarQuantizedVectorSimilarity {
        private final float constMultiplier;

        public Euclidean(float constMultiplier) {
            this.constMultiplier = constMultiplier;
        }

        @Override
        public float score(byte[] queryVector, float queryVectorOffset, byte[] storedVector, float vectorOffset) {
            int squareDistance = VectorUtil.squareDistance(storedVector, queryVector);
            float adjustedDistance = (float)squareDistance * this.constMultiplier;
            return 1.0f / (1.0f + adjustedDistance);
        }
    }
}

