/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.util.bkd;

import guideme.internal.shaded.lucene.codecs.CodecUtil;
import guideme.internal.shaded.lucene.store.ChecksumIndexInput;
import guideme.internal.shaded.lucene.store.Directory;
import guideme.internal.shaded.lucene.store.IOContext;
import guideme.internal.shaded.lucene.store.IndexInput;
import guideme.internal.shaded.lucene.util.BitUtil;
import guideme.internal.shaded.lucene.util.BytesRef;
import guideme.internal.shaded.lucene.util.bkd.BKDConfig;
import guideme.internal.shaded.lucene.util.bkd.PointReader;
import guideme.internal.shaded.lucene.util.bkd.PointValue;
import java.io.EOFException;
import java.io.IOException;

public final class OfflinePointReader
implements PointReader {
    long countLeft;
    final IndexInput in;
    byte[] onHeapBuffer;
    int offset;
    private boolean checked;
    private final BKDConfig config;
    private int pointsInBuffer;
    private final int maxPointOnHeap;
    final String name;
    private final OfflinePointValue pointValue;

    public OfflinePointReader(BKDConfig config, Directory tempDir, String tempFileName, long start, long length, byte[] reusableBuffer) throws IOException {
        this.config = config;
        if ((start + length) * (long)config.bytesPerDoc + (long)CodecUtil.footerLength() > tempDir.fileLength(tempFileName)) {
            throw new IllegalArgumentException("requested slice is beyond the length of this file: start=" + start + " length=" + length + " bytesPerDoc=" + config.bytesPerDoc + " fileLength=" + tempDir.fileLength(tempFileName) + " tempFileName=" + tempFileName);
        }
        if (reusableBuffer == null) {
            throw new IllegalArgumentException("[reusableBuffer] cannot be null");
        }
        if (reusableBuffer.length < config.bytesPerDoc) {
            throw new IllegalArgumentException("Length of [reusableBuffer] must be bigger than " + config.bytesPerDoc);
        }
        this.maxPointOnHeap = reusableBuffer.length / config.bytesPerDoc;
        this.in = start == 0L && length * (long)config.bytesPerDoc == tempDir.fileLength(tempFileName) - (long)CodecUtil.footerLength() ? tempDir.openChecksumInput(tempFileName, IOContext.READONCE) : tempDir.openInput(tempFileName, IOContext.READONCE);
        this.name = tempFileName;
        long seekFP = start * (long)config.bytesPerDoc;
        this.in.seek(seekFP);
        this.countLeft = length;
        this.onHeapBuffer = reusableBuffer;
        this.pointValue = new OfflinePointValue(config, this.onHeapBuffer);
    }

    @Override
    public boolean next() throws IOException {
        if (this.pointsInBuffer == 0) {
            if (this.countLeft >= 0L && this.countLeft == 0L) {
                return false;
            }
            try {
                if (this.countLeft > (long)this.maxPointOnHeap) {
                    this.in.readBytes(this.onHeapBuffer, 0, this.maxPointOnHeap * this.config.bytesPerDoc);
                    this.pointsInBuffer = this.maxPointOnHeap - 1;
                    this.countLeft -= (long)this.maxPointOnHeap;
                } else {
                    this.in.readBytes(this.onHeapBuffer, 0, (int)this.countLeft * this.config.bytesPerDoc);
                    this.pointsInBuffer = Math.toIntExact(this.countLeft - 1L);
                    this.countLeft = 0L;
                }
                this.offset = 0;
            }
            catch (EOFException eofe) {
                assert (this.countLeft == -1L);
                return false;
            }
        } else {
            --this.pointsInBuffer;
            this.offset += this.config.bytesPerDoc;
        }
        return true;
    }

    @Override
    public PointValue pointValue() {
        this.pointValue.setOffset(this.offset);
        return this.pointValue;
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.countLeft == 0L && this.in instanceof ChecksumIndexInput && !this.checked) {
                this.checked = true;
                CodecUtil.checkFooter((ChecksumIndexInput)this.in);
            }
        }
        finally {
            this.in.close();
        }
    }

    static class OfflinePointValue
    implements PointValue {
        final BytesRef packedValue;
        final BytesRef packedValueDocID;
        final int packedValueLength;

        OfflinePointValue(BKDConfig config, byte[] value) {
            this.packedValueLength = config.packedBytesLength;
            this.packedValue = new BytesRef(value, 0, this.packedValueLength);
            this.packedValueDocID = new BytesRef(value, 0, config.bytesPerDoc);
        }

        public void setOffset(int offset) {
            this.packedValue.offset = offset;
            this.packedValueDocID.offset = offset;
        }

        @Override
        public BytesRef packedValue() {
            return this.packedValue;
        }

        @Override
        public int docID() {
            int position = this.packedValueDocID.offset + this.packedValueLength;
            return BitUtil.VH_BE_INT.get(this.packedValueDocID.bytes, position);
        }

        @Override
        public BytesRef packedValueDocIDBytes() {
            return this.packedValueDocID;
        }
    }
}

