/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.util.automaton;

import guideme.internal.shaded.lucene.internal.hppc.IntArrayList;
import guideme.internal.shaded.lucene.internal.hppc.IntCursor;
import guideme.internal.shaded.lucene.internal.hppc.IntHashSet;
import guideme.internal.shaded.lucene.util.automaton.Automaton;
import guideme.internal.shaded.lucene.util.automaton.Operations;
import guideme.internal.shaded.lucene.util.automaton.Transition;
import java.util.BitSet;
import java.util.LinkedList;

public final class MinimizationOperations {
    private MinimizationOperations() {
    }

    public static Automaton minimize(Automaton a, int determinizeWorkLimit) {
        int n;
        int j;
        int x;
        if (a.getNumStates() == 0 || !a.isAccept(0) && a.getNumTransitions(0) == 0) {
            return new Automaton();
        }
        if ((a = Operations.determinize(a, determinizeWorkLimit)).getNumTransitions(0) == 1) {
            Transition t = new Transition();
            a.getTransition(0, 0, t);
            if (t.dest == 0 && t.min == 0 && t.max == 0x10FFFF) {
                return a;
            }
        }
        a = Operations.totalize(a);
        int[] sigma = a.getStartPoints();
        int sigmaLen = sigma.length;
        int statesLen = a.getNumStates();
        IntArrayList[][] reverse = new IntArrayList[statesLen][sigmaLen];
        IntHashSet[] partition = new IntHashSet[statesLen];
        IntArrayList[] splitblock = new IntArrayList[statesLen];
        int[] block = new int[statesLen];
        StateList[][] active = new StateList[statesLen][sigmaLen];
        StateListNode[][] active2 = new StateListNode[statesLen][sigmaLen];
        LinkedList<IntPair> pending = new LinkedList<IntPair>();
        BitSet pending2 = new BitSet(sigmaLen * statesLen);
        BitSet split = new BitSet(statesLen);
        BitSet refine = new BitSet(statesLen);
        BitSet refine2 = new BitSet(statesLen);
        for (int q = 0; q < statesLen; ++q) {
            splitblock[q] = new IntArrayList();
            partition[q] = new IntHashSet();
            for (x = 0; x < sigmaLen; ++x) {
                active[q][x] = StateList.EMPTY;
            }
        }
        Transition transition = new Transition();
        for (int q = 0; q < statesLen; ++q) {
            j = a.isAccept(q) ? 0 : 1;
            partition[j].add(q);
            block[q] = j;
            transition.source = q;
            transition.transitionUpto = -1;
            for (int x2 = 0; x2 < sigmaLen; ++x2) {
                IntArrayList[] r = reverse[a.next(transition, sigma[x2])];
                if (r[x2] == null) {
                    r[x2] = new IntArrayList();
                }
                r[x2].add(q);
            }
        }
        for (int j2 = 0; j2 <= 1; ++j2) {
            for (int x3 = 0; x3 < sigmaLen; ++x3) {
                for (IntCursor qCursor : partition[j2]) {
                    int q = qCursor.value;
                    if (reverse[q][x3] == null) continue;
                    StateList stateList = active[j2][x3];
                    if (stateList == StateList.EMPTY) {
                        active[j2][x3] = stateList = new StateList();
                    }
                    active2[q][x3] = stateList.add(q);
                }
            }
        }
        for (x = 0; x < sigmaLen; ++x) {
            j = active[0][x].size <= active[1][x].size ? 0 : 1;
            pending.add(new IntPair(j, x));
            pending2.set(x * statesLen + j);
        }
        int k = 2;
        while (!pending.isEmpty()) {
            IntPair ip = (IntPair)pending.removeFirst();
            int p = ip.n1;
            int x4 = ip.n2;
            pending2.clear(x4 * statesLen + p);
            StateListNode m = active[p][x4].first;
            while (m != null) {
                IntArrayList r = reverse[m.q][x4];
                if (r != null) {
                    for (IntCursor iCursor : r) {
                        int i = iCursor.value;
                        if (split.get(i)) continue;
                        split.set(i);
                        int j3 = block[i];
                        splitblock[j3].add(i);
                        if (refine2.get(j3)) continue;
                        refine2.set(j3);
                        refine.set(j3);
                    }
                }
                m = m.next;
            }
            int j4 = refine.nextSetBit(0);
            while (j4 >= 0) {
                IntArrayList sb = splitblock[j4];
                if (sb.size() < partition[j4].size()) {
                    IntHashSet b1 = partition[j4];
                    IntHashSet b2 = partition[k];
                    for (IntCursor iCursor : sb) {
                        int s = iCursor.value;
                        b1.remove(s);
                        b2.add(s);
                        block[s] = k;
                        for (int c = 0; c < sigmaLen; ++c) {
                            StateListNode sn = active2[s][c];
                            if (sn == null || sn.sl != active[j4][c]) continue;
                            sn.remove();
                            StateList stateList = active[k][c];
                            if (stateList == StateList.EMPTY) {
                                active[k][c] = stateList = new StateList();
                            }
                            active2[s][c] = stateList.add(s);
                        }
                    }
                    for (int c = 0; c < sigmaLen; ++c) {
                        int aj = active[j4][c].size;
                        int ak = active[k][c].size;
                        int ofs = c * statesLen;
                        if (!pending2.get(ofs + j4) && 0 < aj && aj <= ak) {
                            pending2.set(ofs + j4);
                            pending.add(new IntPair(j4, c));
                            continue;
                        }
                        pending2.set(ofs + k);
                        pending.add(new IntPair(k, c));
                    }
                    ++k;
                }
                refine2.clear(j4);
                for (IntCursor iCursor : sb) {
                    int s = iCursor.value;
                    split.clear(s);
                }
                sb.clear();
                j4 = refine.nextSetBit(j4 + 1);
            }
            refine.clear();
        }
        Automaton result = new Automaton();
        Transition t = new Transition();
        int[] stateMap = new int[statesLen];
        int[] stateRep = new int[k];
        result.createState();
        for (n = 0; n < k; ++n) {
            boolean isInitial = partition[n].contains(0);
            int newState = isInitial ? 0 : result.createState();
            for (IntCursor qCursor : partition[n]) {
                int q = qCursor.value;
                stateMap[q] = newState;
                result.setAccept(newState, a.isAccept(q));
                stateRep[newState] = q;
            }
        }
        for (n = 0; n < k; ++n) {
            int numTransitions = a.initTransition(stateRep[n], t);
            for (int i = 0; i < numTransitions; ++i) {
                a.getNextTransition(t);
                result.addTransition(n, stateMap[t.dest], t.min, t.max);
            }
        }
        result.finishState();
        return Operations.removeDeadStates(result);
    }

    static final class StateListNode {
        final int q;
        StateListNode next;
        StateListNode prev;
        final StateList sl;

        StateListNode(int q, StateList sl) {
            this.q = q;
            this.sl = sl;
            if (sl.size++ == 0) {
                sl.first = sl.last = this;
            } else {
                sl.last.next = this;
                this.prev = sl.last;
                sl.last = this;
            }
        }

        void remove() {
            --this.sl.size;
            if (this.sl.first == this) {
                this.sl.first = this.next;
            } else {
                this.prev.next = this.next;
            }
            if (this.sl.last == this) {
                this.sl.last = this.prev;
            } else {
                this.next.prev = this.prev;
            }
        }
    }

    static final class StateList {
        static final StateList EMPTY = new StateList();
        int size;
        StateListNode first;
        StateListNode last;

        StateList() {
        }

        StateListNode add(int q) {
            assert (this != EMPTY);
            return new StateListNode(q, this);
        }
    }

    static final class IntPair {
        final int n1;
        final int n2;

        IntPair(int n1, int n2) {
            this.n1 = n1;
            this.n2 = n2;
        }
    }
}

