/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.search.uhighlight;

import guideme.internal.shaded.lucene.index.LeafReader;
import guideme.internal.shaded.lucene.search.uhighlight.FieldOffsetStrategy;
import guideme.internal.shaded.lucene.search.uhighlight.OffsetsEnum;
import guideme.internal.shaded.lucene.search.uhighlight.UnifiedHighlighter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class MultiFieldsOffsetStrategy
extends FieldOffsetStrategy {
    private final List<FieldOffsetStrategy> fieldsOffsetStrategies;

    public MultiFieldsOffsetStrategy(List<FieldOffsetStrategy> fieldsOffsetStrategies) {
        super(null);
        this.fieldsOffsetStrategies = fieldsOffsetStrategies;
    }

    @Override
    public String getField() {
        throw new IllegalStateException("MultiFieldsOffsetStrategy does not have a single field.");
    }

    @Override
    public UnifiedHighlighter.OffsetSource getOffsetSource() {
        return this.fieldsOffsetStrategies.get(0).getOffsetSource();
    }

    @Override
    public OffsetsEnum getOffsetsEnum(LeafReader reader, int docId, String content) throws IOException {
        ArrayList<OffsetsEnum> fieldsOffsetsEnums = new ArrayList<OffsetsEnum>(this.fieldsOffsetStrategies.size());
        for (FieldOffsetStrategy fieldOffsetStrategy : this.fieldsOffsetStrategies) {
            OffsetsEnum offsetsEnum = fieldOffsetStrategy.getOffsetsEnum(reader, docId, content);
            if (offsetsEnum == OffsetsEnum.EMPTY) continue;
            fieldsOffsetsEnums.add(offsetsEnum);
        }
        return new OffsetsEnum.MultiOffsetsEnum(fieldsOffsetsEnums);
    }
}

