/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.queryparser.flexible.standard.builders;

import guideme.internal.shaded.lucene.queryparser.flexible.core.QueryNodeException;
import guideme.internal.shaded.lucene.queryparser.flexible.core.builders.QueryTreeBuilder;
import guideme.internal.shaded.lucene.queryparser.flexible.core.nodes.FieldQueryNode;
import guideme.internal.shaded.lucene.queryparser.flexible.core.nodes.QueryNode;
import guideme.internal.shaded.lucene.queryparser.flexible.core.nodes.TokenizedPhraseQueryNode;
import guideme.internal.shaded.lucene.queryparser.flexible.standard.builders.StandardQueryBuilder;
import guideme.internal.shaded.lucene.search.PhraseQuery;
import guideme.internal.shaded.lucene.search.Query;
import guideme.internal.shaded.lucene.search.TermQuery;
import java.util.List;

public class PhraseQueryNodeBuilder
implements StandardQueryBuilder {
    @Override
    public Query build(QueryNode queryNode) throws QueryNodeException {
        TokenizedPhraseQueryNode phraseNode = (TokenizedPhraseQueryNode)queryNode;
        PhraseQuery.Builder builder = new PhraseQuery.Builder();
        List<QueryNode> children = phraseNode.getChildren();
        if (children != null) {
            for (QueryNode child : children) {
                TermQuery termQuery = (TermQuery)child.getTag(QueryTreeBuilder.QUERY_TREE_BUILDER_TAGID);
                FieldQueryNode termNode = (FieldQueryNode)child;
                builder.add(termQuery.getTerm(), termNode.getPositionIncrement());
            }
        }
        return builder.build();
    }
}

