/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.index;

import guideme.internal.shaded.lucene.index.AutomatonTermsEnum;
import guideme.internal.shaded.lucene.index.LeafReader;
import guideme.internal.shaded.lucene.index.TermsEnum;
import guideme.internal.shaded.lucene.util.BytesRef;
import guideme.internal.shaded.lucene.util.BytesRefBuilder;
import guideme.internal.shaded.lucene.util.automaton.CompiledAutomaton;
import java.io.IOException;

public abstract class Terms {
    public static final Terms[] EMPTY_ARRAY = new Terms[0];
    private static final Terms EMPTY = new Terms(){

        @Override
        public TermsEnum iterator() throws IOException {
            return TermsEnum.EMPTY;
        }

        @Override
        public long size() throws IOException {
            return 0L;
        }

        @Override
        public long getSumTotalTermFreq() throws IOException {
            return 0L;
        }

        @Override
        public long getSumDocFreq() throws IOException {
            return 0L;
        }

        @Override
        public int getDocCount() throws IOException {
            return 0;
        }

        @Override
        public boolean hasFreqs() {
            return false;
        }

        @Override
        public boolean hasOffsets() {
            return false;
        }

        @Override
        public boolean hasPositions() {
            return false;
        }

        @Override
        public boolean hasPayloads() {
            return false;
        }
    };

    protected Terms() {
    }

    public static Terms getTerms(LeafReader reader, String field) throws IOException {
        Terms terms = reader.terms(field);
        if (terms == null) {
            return EMPTY;
        }
        return terms;
    }

    public abstract TermsEnum iterator() throws IOException;

    public TermsEnum intersect(CompiledAutomaton compiled, final BytesRef startTerm) throws IOException {
        TermsEnum termsEnum = this.iterator();
        if (compiled.type != CompiledAutomaton.AUTOMATON_TYPE.NORMAL) {
            throw new IllegalArgumentException("please use CompiledAutomaton.getTermsEnum instead");
        }
        if (startTerm == null) {
            return new AutomatonTermsEnum(termsEnum, compiled);
        }
        return new AutomatonTermsEnum(termsEnum, compiled){

            @Override
            protected BytesRef nextSeekTerm(BytesRef term) throws IOException {
                if (term == null) {
                    term = startTerm;
                }
                return super.nextSeekTerm(term);
            }
        };
    }

    public abstract long size() throws IOException;

    public abstract long getSumTotalTermFreq() throws IOException;

    public abstract long getSumDocFreq() throws IOException;

    public abstract int getDocCount() throws IOException;

    public abstract boolean hasFreqs();

    public abstract boolean hasOffsets();

    public abstract boolean hasPositions();

    public abstract boolean hasPayloads();

    public BytesRef getMin() throws IOException {
        return this.iterator().next();
    }

    public BytesRef getMax() throws IOException {
        TermsEnum iterator;
        BytesRef v;
        long size = this.size();
        if (size == 0L) {
            return null;
        }
        if (size >= 0L) {
            try {
                TermsEnum iterator2 = this.iterator();
                iterator2.seekExact(size - 1L);
                return iterator2.term();
            }
            catch (UnsupportedOperationException iterator2) {
                // empty catch block
            }
        }
        if ((v = (iterator = this.iterator()).next()) == null) {
            return v;
        }
        BytesRefBuilder scratch = new BytesRefBuilder();
        scratch.append((byte)0);
        while (true) {
            int low = 0;
            int high = 256;
            while (low != high) {
                int mid = low + high >>> 1;
                scratch.setByteAt(scratch.length() - 1, (byte)mid);
                if (iterator.seekCeil(scratch.get()) == TermsEnum.SeekStatus.END) {
                    if (mid == 0) {
                        scratch.setLength(scratch.length() - 1);
                        return scratch.get();
                    }
                    high = mid;
                    continue;
                }
                if (low == mid) break;
                low = mid;
            }
            scratch.setLength(scratch.length() + 1);
            scratch.grow(scratch.length());
        }
    }

    public Object getStats() throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append("impl=").append(this.getClass().getSimpleName());
        sb.append(",size=").append(this.size());
        sb.append(",docCount=").append(this.getDocCount());
        sb.append(",sumTotalTermFreq=").append(this.getSumTotalTermFreq());
        sb.append(",sumDocFreq=").append(this.getSumDocFreq());
        return sb.toString();
    }
}

