/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.codecs.lucene90.blocktree;

import guideme.internal.shaded.lucene.codecs.CodecUtil;
import guideme.internal.shaded.lucene.codecs.FieldsProducer;
import guideme.internal.shaded.lucene.codecs.PostingsReaderBase;
import guideme.internal.shaded.lucene.codecs.lucene90.blocktree.FieldReader;
import guideme.internal.shaded.lucene.index.CorruptIndexException;
import guideme.internal.shaded.lucene.index.FieldInfo;
import guideme.internal.shaded.lucene.index.FieldInfos;
import guideme.internal.shaded.lucene.index.IndexFileNames;
import guideme.internal.shaded.lucene.index.IndexOptions;
import guideme.internal.shaded.lucene.index.SegmentReadState;
import guideme.internal.shaded.lucene.index.Terms;
import guideme.internal.shaded.lucene.internal.hppc.IntCursor;
import guideme.internal.shaded.lucene.internal.hppc.IntObjectHashMap;
import guideme.internal.shaded.lucene.store.ChecksumIndexInput;
import guideme.internal.shaded.lucene.store.IOContext;
import guideme.internal.shaded.lucene.store.IndexInput;
import guideme.internal.shaded.lucene.util.BytesRef;
import guideme.internal.shaded.lucene.util.IOUtils;
import guideme.internal.shaded.lucene.util.fst.ByteSequenceOutputs;
import guideme.internal.shaded.lucene.util.fst.Outputs;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public final class Lucene90BlockTreeTermsReader
extends FieldsProducer {
    static final Outputs<BytesRef> FST_OUTPUTS = ByteSequenceOutputs.getSingleton();
    static final BytesRef NO_OUTPUT = FST_OUTPUTS.getNoOutput();
    static final int OUTPUT_FLAGS_NUM_BITS = 2;
    static final int OUTPUT_FLAGS_MASK = 3;
    static final int OUTPUT_FLAG_IS_FLOOR = 1;
    static final int OUTPUT_FLAG_HAS_TERMS = 2;
    static final String TERMS_EXTENSION = "tim";
    static final String TERMS_CODEC_NAME = "BlockTreeTermsDict";
    public static final int VERSION_START = 0;
    public static final int VERSION_MSB_VLONG_OUTPUT = 1;
    public static final int VERSION_FST_CONTINUOUS_ARCS = 2;
    public static final int VERSION_CURRENT = 2;
    static final String TERMS_INDEX_EXTENSION = "tip";
    static final String TERMS_INDEX_CODEC_NAME = "BlockTreeTermsIndex";
    static final String TERMS_META_EXTENSION = "tmd";
    static final String TERMS_META_CODEC_NAME = "BlockTreeTermsMeta";
    final IndexInput termsIn;
    final IndexInput indexIn;
    final PostingsReaderBase postingsReader;
    private final FieldInfos fieldInfos;
    private final IntObjectHashMap<FieldReader> fieldMap;
    private final List<String> fieldList;
    final String segment;
    final int version;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Lucene90BlockTreeTermsReader(PostingsReaderBase postingsReader, SegmentReadState state) throws IOException {
        boolean success = false;
        this.postingsReader = postingsReader;
        this.segment = state.segmentInfo.name;
        try {
            long termsLength;
            long indexLength;
            IntObjectHashMap<FieldReader> fieldMap;
            block27: {
                String termsName = IndexFileNames.segmentFileName(this.segment, state.segmentSuffix, TERMS_EXTENSION);
                this.termsIn = state.directory.openInput(termsName, state.context);
                this.version = CodecUtil.checkIndexHeader(this.termsIn, TERMS_CODEC_NAME, 0, 2, state.segmentInfo.getId(), state.segmentSuffix);
                String indexName = IndexFileNames.segmentFileName(this.segment, state.segmentSuffix, TERMS_INDEX_EXTENSION);
                this.indexIn = state.directory.openInput(indexName, IOContext.LOAD);
                CodecUtil.checkIndexHeader(this.indexIn, TERMS_INDEX_CODEC_NAME, this.version, this.version, state.segmentInfo.getId(), state.segmentSuffix);
                String metaName = IndexFileNames.segmentFileName(this.segment, state.segmentSuffix, TERMS_META_EXTENSION);
                fieldMap = null;
                Throwable priorE = null;
                indexLength = -1L;
                termsLength = -1L;
                try (ChecksumIndexInput metaIn = state.directory.openChecksumInput(metaName, IOContext.READONCE);){
                    block26: {
                        try {
                            CodecUtil.checkIndexHeader(metaIn, TERMS_META_CODEC_NAME, this.version, this.version, state.segmentInfo.getId(), state.segmentSuffix);
                            postingsReader.init(metaIn, state);
                            int numFields = metaIn.readVInt();
                            if (numFields < 0) {
                                throw new CorruptIndexException("invalid numFields: " + numFields, metaIn);
                            }
                            fieldMap = new IntObjectHashMap<FieldReader>(numFields);
                            for (int i = 0; i < numFields; ++i) {
                                int field = metaIn.readVInt();
                                long numTerms = metaIn.readVLong();
                                if (numTerms <= 0L) {
                                    throw new CorruptIndexException("Illegal numTerms for field number: " + field, metaIn);
                                }
                                BytesRef rootCode = Lucene90BlockTreeTermsReader.readBytesRef(metaIn);
                                FieldInfo fieldInfo = state.fieldInfos.fieldInfo(field);
                                if (fieldInfo == null) {
                                    throw new CorruptIndexException("invalid field number: " + field, metaIn);
                                }
                                long sumTotalTermFreq = metaIn.readVLong();
                                long sumDocFreq = fieldInfo.getIndexOptions() == IndexOptions.DOCS ? sumTotalTermFreq : metaIn.readVLong();
                                int docCount = metaIn.readVInt();
                                BytesRef minTerm = Lucene90BlockTreeTermsReader.readBytesRef(metaIn);
                                BytesRef maxTerm = Lucene90BlockTreeTermsReader.readBytesRef(metaIn);
                                if (numTerms == 1L) {
                                    assert (maxTerm.equals(minTerm));
                                    maxTerm = minTerm;
                                }
                                if (docCount < 0 || docCount > state.segmentInfo.maxDoc()) {
                                    throw new CorruptIndexException("invalid docCount: " + docCount + " maxDoc: " + state.segmentInfo.maxDoc(), metaIn);
                                }
                                if (sumDocFreq < (long)docCount) {
                                    throw new CorruptIndexException("invalid sumDocFreq: " + sumDocFreq + " docCount: " + docCount, metaIn);
                                }
                                if (sumTotalTermFreq < sumDocFreq) {
                                    throw new CorruptIndexException("invalid sumTotalTermFreq: " + sumTotalTermFreq + " sumDocFreq: " + sumDocFreq, metaIn);
                                }
                                long indexStartFP = metaIn.readVLong();
                                FieldReader previous = fieldMap.put(fieldInfo.number, new FieldReader(this, fieldInfo, numTerms, rootCode, sumTotalTermFreq, sumDocFreq, docCount, indexStartFP, metaIn, this.indexIn, minTerm, maxTerm));
                                if (previous == null) continue;
                                throw new CorruptIndexException("duplicate field: " + fieldInfo.name, metaIn);
                            }
                            indexLength = metaIn.readLong();
                            termsLength = metaIn.readLong();
                            if (metaIn == null) break block26;
                        }
                        catch (Throwable exception) {
                            try {
                                priorE = exception;
                                break block27;
                            }
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                            finally {
                                if (metaIn != null) {
                                    CodecUtil.checkFooter(metaIn, priorE);
                                } else if (priorE != null) {
                                    IOUtils.rethrowAlways(priorE);
                                }
                            }
                        }
                        CodecUtil.checkFooter(metaIn, priorE);
                        break block27;
                    }
                    if (priorE != null) {
                        IOUtils.rethrowAlways(priorE);
                    }
                }
            }
            CodecUtil.retrieveChecksum(this.indexIn, indexLength);
            CodecUtil.retrieveChecksum(this.termsIn, termsLength);
            this.fieldInfos = state.fieldInfos;
            this.fieldMap = fieldMap;
            this.fieldList = Lucene90BlockTreeTermsReader.sortFieldNames(fieldMap, state.fieldInfos);
            return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException(new Closeable[]{this});
            throw throwable;
        }
    }

    private static BytesRef readBytesRef(IndexInput in) throws IOException {
        int numBytes = in.readVInt();
        if (numBytes < 0) {
            throw new CorruptIndexException("invalid bytes length: " + numBytes, in);
        }
        BytesRef bytes = new BytesRef(numBytes);
        bytes.length = numBytes;
        in.readBytes(bytes.bytes, 0, numBytes);
        return bytes;
    }

    private static List<String> sortFieldNames(IntObjectHashMap<FieldReader> fieldMap, FieldInfos fieldInfos) {
        ArrayList<String> fieldNames = new ArrayList<String>(fieldMap.size());
        for (IntCursor fieldNumber : fieldMap.keys()) {
            fieldNames.add(fieldInfos.fieldInfo((int)fieldNumber.value).name);
        }
        fieldNames.sort(null);
        return Collections.unmodifiableList(fieldNames);
    }

    @Override
    public void close() throws IOException {
        try {
            IOUtils.close(this.indexIn, this.termsIn, this.postingsReader);
        }
        finally {
            this.fieldMap.clear();
        }
    }

    @Override
    public Iterator<String> iterator() {
        return this.fieldList.iterator();
    }

    @Override
    public Terms terms(String field) throws IOException {
        assert (field != null);
        FieldInfo fieldInfo = this.fieldInfos.fieldInfo(field);
        return fieldInfo == null ? null : (Terms)this.fieldMap.get(fieldInfo.number);
    }

    @Override
    public int size() {
        return this.fieldMap.size();
    }

    @Override
    public void checkIntegrity() throws IOException {
        CodecUtil.checksumEntireFile(this.indexIn);
        CodecUtil.checksumEntireFile(this.termsIn);
        this.postingsReader.checkIntegrity();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(fields=" + this.fieldMap.size() + ",delegate=" + this.postingsReader + ")";
    }
}

