/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.corpsecurioscompat;

import com.leclowndu93150.baguettelib.event.entity.death.PlayerDeathEvent;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;

@Mod.EventBusSubscriber(modid="gravestonecurioscompat")
public class DeathEventHandler {
    private static final String CURIO_SLOT_TAG = "CorpseCuriosSlot";
    private static final String CURIO_SLOT_TYPE = "SlotType";
    private static final String CURIO_SLOT_INDEX = "SlotIndex";
    private static final String WAS_EQUIPPED = "WasEquipped";

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onPlayerDeathPre(PlayerDeathEvent.Pre event) {
        Player player = event.getPlayer();
        LazyOptional curioHandlerOptional = CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)player);
        if (!curioHandlerOptional.isPresent()) {
            return;
        }
        ICuriosItemHandler handler = (ICuriosItemHandler)curioHandlerOptional.resolve().get();
        Map curios = handler.getCurios();
        for (Map.Entry entry : curios.entrySet()) {
            ItemStack stack;
            int i;
            String slotType = (String)entry.getKey();
            ICurioStacksHandler stackHandler = (ICurioStacksHandler)entry.getValue();
            for (i = 0; i < stackHandler.getSlots(); ++i) {
                stack = stackHandler.getStacks().getStackInSlot(i);
                if (stack.m_41619_()) continue;
                DeathEventHandler.tagItemWithSlotData(stack, slotType, i, true);
            }
            for (i = 0; i < stackHandler.getCosmeticStacks().getSlots(); ++i) {
                stack = stackHandler.getCosmeticStacks().getStackInSlot(i);
                if (stack.m_41619_()) continue;
                DeathEventHandler.tagItemWithSlotData(stack, slotType, i, true);
            }
        }
    }

    private static void tagItemWithSlotData(ItemStack stack, String slotType, int slotIndex, boolean wasEquipped) {
        CompoundTag tag = stack.m_41784_();
        CompoundTag slotData = new CompoundTag();
        slotData.m_128359_(CURIO_SLOT_TYPE, slotType);
        slotData.m_128405_(CURIO_SLOT_INDEX, slotIndex);
        slotData.m_128379_(WAS_EQUIPPED, wasEquipped);
        tag.m_128365_(CURIO_SLOT_TAG, (Tag)slotData);
    }
}

