/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.config;

import dev.ftb.mods.ftblibrary.config.NumberConfig;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;

public class IntConfig
extends NumberConfig<Integer> {
    public IntConfig(int mn, int mx) {
        super(mn, mx);
        this.scrollIncrement = 1;
    }

    @Override
    public void addInfo(TooltipList list) {
        super.addInfo(list);
        if ((Integer)this.min != Integer.MIN_VALUE) {
            list.add(IntConfig.info("Min", this.formatValue((Integer)this.min)));
        }
        if ((Integer)this.max != Integer.MAX_VALUE) {
            list.add(IntConfig.info("Max", this.formatValue((Integer)this.max)));
        }
    }

    @Override
    public boolean parse(@Nullable Consumer<Integer> callback, String string) {
        if (string.equals("-") || string.equals("+") || string.isEmpty()) {
            return this.okValue(callback, 0);
        }
        try {
            Integer v = Integer.decode(string);
            if (v >= (Integer)this.min && v <= (Integer)this.max) {
                return this.okValue(callback, v);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    @Override
    protected String formatValue(Integer v) {
        return String.format("%,d", v);
    }

    @Override
    public Optional<Integer> scrollValue(Integer currentValue, boolean forward) {
        int newVal = Mth.m_14045_((int)(currentValue + (forward ? (Integer)this.scrollIncrement : -((Integer)this.scrollIncrement).intValue())), (int)((Integer)this.min), (int)((Integer)this.max));
        return newVal != currentValue ? Optional.of(newVal) : Optional.empty();
    }
}

