/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.world.feature.structures;

import com.github.teamfossilsarcheology.fossil.FossilMod;
import com.github.teamfossilsarcheology.fossil.world.biome.ModBiomes;
import com.github.teamfossilsarcheology.fossil.world.feature.structures.AnuCastleStructure;
import com.github.teamfossilsarcheology.fossil.world.feature.structures.HellBoatStructure;
import com.github.teamfossilsarcheology.fossil.world.feature.structures.ModTemplatePools;
import com.github.teamfossilsarcheology.fossil.world.feature.structures.TreasureRoomStructure;
import java.util.Arrays;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.heightproviders.ConstantHeight;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.heightproviders.UniformHeight;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSpawnOverride;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.structures.JigsawStructure;

public class ModStructures {
    public static final ResourceKey<Structure> ANU_CASTLE_KEY = ModStructures.createKey("anu_castle");
    public static final ResourceKey<Structure> HELL_BOAT_KEY = ModStructures.createKey("hell_boat");
    public static final ResourceKey<Structure> TREASURE_ROOM_KEY = ModStructures.createKey("treasure_room");
    public static final ResourceKey<Structure> AZTEC_TEMPLE_KEY = ModStructures.createKey("aztec_temple");
    public static final ResourceKey<Structure> AZTEC_WEAPON_SHOP_KEY = ModStructures.createKey("aztec_weapon_shop");
    public static final ResourceKey<Structure> EGYPTIAN_ACADEMY_KEY = ModStructures.createKey("egyptian_academy");
    public static final ResourceKey<Structure> FOSSIL_SITE_BADLANDS_KEY = ModStructures.createKey("fossil_site_badlands");
    public static final ResourceKey<Structure> FOSSIL_SITE_DESERT_KEY = ModStructures.createKey("fossil_site_desert");
    public static final ResourceKey<Structure> FOSSIL_SITE_NORMAL_KEY = ModStructures.createKey("fossil_site_normal");
    public static final ResourceKey<Structure> FOSSIL_SITE_SNOWY_KEY = ModStructures.createKey("fossil_site_snowy");
    public static final ResourceKey<Structure> TAR_SITE_LARGE_KEY = ModStructures.createKey("tar_site_large");
    public static final ResourceKey<Structure> TAR_SITE_LARGE_SNOWY_KEY = ModStructures.createKey("tar_site_large_snowy");
    public static final ResourceKey<Structure> TAR_SITE_SMALL_KEY = ModStructures.createKey("tar_site_small");
    public static final ResourceKey<Structure> TAR_SITE_SMALL_SNOWY_KEY = ModStructures.createKey("tar_site_small_snowy");
    public static final ResourceKey<Structure> TAR_SITE_TENT_KEY = ModStructures.createKey("tar_site_tent");
    public static final ResourceKey<Structure> TAR_SITE_TENT_SNOWY_KEY = ModStructures.createKey("tar_site_tent_snowy");

    private static ResourceKey<Structure> createKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256944_, (ResourceLocation)FossilMod.location(name));
    }

    public static void bootstrap(BootstapContext<Structure> context) {
        HolderGetter biomes = context.m_255420_(Registries.f_256952_);
        HolderGetter templates = context.m_255420_(Registries.f_256948_);
        context.m_255272_(ANU_CASTLE_KEY, (Object)new AnuCastleStructure(new Structure.StructureSettings((HolderSet)HolderSet.m_205809_((Holder[])new Holder[]{biomes.m_255043_(ModBiomes.ANU_LAIR_KEY)}), Map.of(), GenerationStep.Decoration.SURFACE_STRUCTURES, TerrainAdjustment.NONE)));
        context.m_255272_(HELL_BOAT_KEY, (Object)new HellBoatStructure(new Structure.StructureSettings((HolderSet)biomes.m_254956_(BiomeTags.f_207612_), Map.of(), GenerationStep.Decoration.SURFACE_STRUCTURES, TerrainAdjustment.NONE), (HeightProvider)UniformHeight.m_162034_((VerticalAnchor)VerticalAnchor.m_158922_((int)30), (VerticalAnchor)VerticalAnchor.m_158922_((int)30))));
        context.m_255272_(TREASURE_ROOM_KEY, (Object)new TreasureRoomStructure(new Structure.StructureSettings((HolderSet)HolderSet.m_205809_((Holder[])new Holder[]{biomes.m_255043_(ModBiomes.TREASURE_ROOM_KEY)}), Map.of(), GenerationStep.Decoration.SURFACE_STRUCTURES, TerrainAdjustment.NONE)));
        ModStructures.simple(AZTEC_TEMPLE_KEY, ModTemplatePools.AZTEC_TEMPLE_KEY, context, (TagKey<Biome>)BiomeTags.f_207610_);
        ModStructures.simple(AZTEC_WEAPON_SHOP_KEY, ModTemplatePools.AZTEC_WEAPON_SHOP_KEY, context, (TagKey<Biome>)BiomeTags.f_207610_);
        ModStructures.simple(EGYPTIAN_ACADEMY_KEY, ModTemplatePools.EGYPTIAN_ACADEMY_KEY, context, (TagKey<Biome>)BiomeTags.f_207614_);
        ModStructures.sites(FOSSIL_SITE_BADLANDS_KEY, 2, ModTemplatePools.FOSSIL_SITE_BADLANDS_START_KEY, context, Biomes.f_48159_);
        ModStructures.sites(FOSSIL_SITE_DESERT_KEY, 3, ModTemplatePools.FOSSIL_SITE_DESERT_START_KEY, context, Biomes.f_48203_);
        ModStructures.sites(FOSSIL_SITE_NORMAL_KEY, 3, ModTemplatePools.FOSSIL_SITE_NORMAL_START_KEY, context, Biomes.f_48202_, Biomes.f_48157_, Biomes.f_48206_, Biomes.f_186763_, Biomes.f_186764_);
        ModStructures.sites(FOSSIL_SITE_SNOWY_KEY, 3, ModTemplatePools.FOSSIL_SITE_SNOWY_START_KEY, context, Biomes.f_186761_, Biomes.f_48152_);
        ModStructures.sites(TAR_SITE_LARGE_KEY, 3, ModTemplatePools.TAR_SITE_LARGE_START_KEY, context, Biomes.f_48202_, Biomes.f_48157_, Biomes.f_48207_);
        ModStructures.sites(TAR_SITE_LARGE_SNOWY_KEY, 3, ModTemplatePools.TAR_SITE_LARGE_SNOWY_START_KEY, context, Biomes.f_186761_, Biomes.f_48152_);
        ModStructures.sites(TAR_SITE_SMALL_KEY, 3, ModTemplatePools.TAR_SITE_SMALL_START_KEY, context, Biomes.f_48202_, Biomes.f_48157_);
        ModStructures.sites(TAR_SITE_SMALL_SNOWY_KEY, 3, ModTemplatePools.TAR_SITE_SMALL_SNOWY_START_KEY, context, Biomes.f_186761_, Biomes.f_48152_);
        ModStructures.sites(TAR_SITE_TENT_KEY, 3, ModTemplatePools.TAR_SITE_TENT_START_KEY, context, Biomes.f_48202_, Biomes.f_48157_, Biomes.f_186754_);
        ModStructures.sites(TAR_SITE_TENT_SNOWY_KEY, 3, ModTemplatePools.TAR_SITE_TENT_SNOWY_START_KEY, context, Biomes.f_186761_, Biomes.f_48152_);
    }

    private static void sites(ResourceKey<Structure> key, int size, ResourceKey<StructureTemplatePool> pool, BootstapContext<Structure> context, ResourceKey<Biome> ... biome) {
        Holder[] biomes = (Holder[])Arrays.stream(biome).map(biomeResourceKey -> context.m_255420_(Registries.f_256952_).m_255043_(biomeResourceKey)).toArray(Holder[]::new);
        context.m_255272_(key, (Object)new JigsawStructure(ModStructures.structure((HolderSet<Biome>)HolderSet.m_205809_((Holder[])biomes), TerrainAdjustment.NONE), (Holder)context.m_255420_(Registries.f_256948_).m_255043_(pool), size, (HeightProvider)ConstantHeight.m_161956_((VerticalAnchor)VerticalAnchor.m_158922_((int)0)), true, Heightmap.Types.WORLD_SURFACE_WG));
    }

    private static void simple(ResourceKey<Structure> key, ResourceKey<StructureTemplatePool> pool, BootstapContext<Structure> context, TagKey<Biome> biome) {
        context.m_255272_(key, (Object)new JigsawStructure(ModStructures.structure((HolderSet<Biome>)context.m_255420_(Registries.f_256952_).m_254956_(biome), TerrainAdjustment.NONE), (Holder)context.m_255420_(Registries.f_256948_).m_255043_(pool), 1, (HeightProvider)ConstantHeight.m_161956_((VerticalAnchor)VerticalAnchor.m_158922_((int)0)), false, Heightmap.Types.WORLD_SURFACE_WG));
    }

    private static Structure.StructureSettings structure(HolderSet<Biome> biomes, Map<MobCategory, StructureSpawnOverride> spawnOverrides, GenerationStep.Decoration step, TerrainAdjustment terrainAdaptation) {
        return new Structure.StructureSettings(biomes, spawnOverrides, step, terrainAdaptation);
    }

    private static Structure.StructureSettings structure(HolderSet<Biome> biomes, GenerationStep.Decoration step, TerrainAdjustment terrainAdaptation) {
        return ModStructures.structure(biomes, Map.of(), step, terrainAdaptation);
    }

    private static Structure.StructureSettings structure(HolderSet<Biome> biomes, TerrainAdjustment terrainAdaptation) {
        return ModStructures.structure(biomes, Map.of(), GenerationStep.Decoration.SURFACE_STRUCTURES, terrainAdaptation);
    }
}

