/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.world.feature.placement;

import com.github.teamfossilsarcheology.fossil.FossilMod;
import com.github.teamfossilsarcheology.fossil.config.FossilConfig;
import com.github.teamfossilsarcheology.fossil.world.feature.configuration.ModConfiguredFeatures;
import com.github.teamfossilsarcheology.fossil.world.feature.placement.ModOrePlacements;
import dev.architectury.registry.level.biome.BiomeModifications;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.data.worldgen.features.CaveFeatures;
import net.minecraft.data.worldgen.features.MiscOverworldFeatures;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.valueproviders.ClampedNormalInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RandomOffsetPlacement;
import net.minecraft.world.level.levelgen.placement.RarityFilter;

public class ModPlacedFeatures {
    public static final ResourceKey<PlacedFeature> VOLCANO_ASH_DISK_KEY = ModPlacedFeatures.createKey("volcano_ash_disk");
    public static final ResourceKey<PlacedFeature> VOLCANO_MAGMA_DISK_KEY = ModPlacedFeatures.createKey("volcano_magma_disk");
    public static final ResourceKey<PlacedFeature> VOLCANO_CONE_KEY = ModPlacedFeatures.createKey("volcano_cone");
    public static final ResourceKey<PlacedFeature> VOLCANO_VENT_KEY = ModPlacedFeatures.createKey("volcano_vent");
    public static final ResourceKey<PlacedFeature> VOLCANO_LAVA_LAKE_KEY = ModPlacedFeatures.createKey("volcano_lake_lava");
    public static final ResourceKey<PlacedFeature> VOLCANO_FOSSIL_KEY = ModPlacedFeatures.createKey("volcano_fossil");
    public static final ResourceKey<PlacedFeature> MOAI_STATUE_KEY = ModPlacedFeatures.createKey("moai_statue");

    private static ResourceKey<PlacedFeature> createKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256988_, (ResourceLocation)FossilMod.location(name));
    }

    public static void bootstrap(BootstapContext<PlacedFeature> context) {
        ModOrePlacements.bootstrap(context);
        HolderGetter holderGetter = context.m_255420_(Registries.f_256911_);
        Holder.Reference volcanoAshDisk = holderGetter.m_255043_(ModConfiguredFeatures.ASH_DISK_KEY);
        Holder.Reference volcanoMagmaDisk = holderGetter.m_255043_(ModConfiguredFeatures.MAGMA_DISK_KEY);
        Holder.Reference volcanoCone = holderGetter.m_255043_(ModConfiguredFeatures.VOLCANO_CONE_KEY);
        Holder.Reference volcanoVent = holderGetter.m_255043_(ModConfiguredFeatures.VOLCANO_VENT_KEY);
        Holder.Reference volcanoLavaLake = holderGetter.m_255043_(MiscOverworldFeatures.f_195016_);
        Holder.Reference volcanoFossil = holderGetter.m_255043_(CaveFeatures.f_194939_);
        PlacementUtils.m_255206_(context, VOLCANO_ASH_DISK_KEY, (Holder)volcanoAshDisk, (PlacementModifier[])new PlacementModifier[]{CountPlacement.m_191628_((int)1), InSquarePlacement.m_191715_(), PlacementUtils.f_195354_, BiomeFilter.m_191561_()});
        PlacementUtils.m_255206_(context, VOLCANO_MAGMA_DISK_KEY, (Holder)volcanoMagmaDisk, (PlacementModifier[])new PlacementModifier[]{RarityFilter.m_191900_((int)3), InSquarePlacement.m_191715_(), PlacementUtils.f_195354_, BiomeFilter.m_191561_()});
        PlacementUtils.m_255206_(context, VOLCANO_CONE_KEY, (Holder)volcanoCone, (PlacementModifier[])new PlacementModifier[]{RarityFilter.m_191900_((int)30), PlacementUtils.f_195353_, BiomeFilter.m_191561_()});
        PlacementUtils.m_255206_(context, VOLCANO_VENT_KEY, (Holder)volcanoVent, (PlacementModifier[])new PlacementModifier[]{CountPlacement.m_191628_((int)1), InSquarePlacement.m_191715_(), PlacementUtils.f_195354_, BiomeFilter.m_191561_()});
        PlacementUtils.m_255206_(context, VOLCANO_LAVA_LAKE_KEY, (Holder)volcanoLavaLake, (PlacementModifier[])new PlacementModifier[]{RarityFilter.m_191900_((int)6), CountPlacement.m_191628_((int)6), InSquarePlacement.m_191715_(), PlacementUtils.f_195354_, BiomeFilter.m_191561_()});
        PlacementUtils.m_255206_(context, VOLCANO_FOSSIL_KEY, (Holder)volcanoFossil, (PlacementModifier[])new PlacementModifier[]{RarityFilter.m_191900_((int)10), InSquarePlacement.m_191715_(), PlacementUtils.f_195354_, RandomOffsetPlacement.m_191877_((IntProvider)ClampedNormalInt.m_185879_((float)-9.0f, (float)4.0f, (int)-16, (int)-5)), BiomeFilter.m_191561_()});
        Holder.Reference moaiStatue = holderGetter.m_255043_(ModConfiguredFeatures.MOAI_STATUE_KEY);
        PlacementUtils.m_255206_(context, MOAI_STATUE_KEY, (Holder)moaiStatue, (PlacementModifier[])new PlacementModifier[]{RarityFilter.m_191900_((int)400), InSquarePlacement.m_191715_(), PlacementUtils.f_195354_, BiomeFilter.m_191561_()});
    }

    public static void register() {
        BiomeModifications.addProperties((context, mutable) -> {
            if (FossilConfig.isEnabled("generateFossils")) {
                mutable.getGenerationProperties().addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, ModOrePlacements.ORE_FOSSIL_BLOCK_UPPER);
                mutable.getGenerationProperties().addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, ModOrePlacements.ORE_FOSSIL_BLOCK_MIDDLE);
                mutable.getGenerationProperties().addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, ModOrePlacements.ORE_FOSSIL_BLOCK_DEEP);
            }
            if (FossilConfig.isEnabled("generateVolcanicRock")) {
                mutable.getGenerationProperties().addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, ModOrePlacements.ORE_VOLCANIC_ROCK);
            }
            if (FossilConfig.isEnabled("generatePermafrost") && (double)mutable.getClimateProperties().getTemperature() < 0.15) {
                mutable.getGenerationProperties().addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, ModOrePlacements.ORE_PERMAFROST_BLOCK);
            }
            mutable.getGenerationProperties().addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, ModOrePlacements.ORE_AMBER);
            mutable.getGenerationProperties().addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, ModOrePlacements.ORE_AMBER_BURIED);
        });
    }
}

