/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.network.debug;

import com.github.teamfossilsarcheology.fossil.capabilities.ModCapabilities;
import com.github.teamfossilsarcheology.fossil.client.gui.debug.DebugScreen;
import com.github.teamfossilsarcheology.fossil.entity.PrehistoricSkeleton;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.DinosaurEgg;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.Prehistoric;
import com.github.teamfossilsarcheology.fossil.util.Gender;
import com.github.teamfossilsarcheology.fossil.util.Version;
import dev.architectury.networking.NetworkManager;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;

public class SyncDebugInfoMessage {
    private final int entityId;
    private final String enumString;
    private final int age;
    private final int matingCooldown;
    private final int playingCooldown;
    private final int climbingCooldown;
    private final int hunger;
    private final int mood;

    public SyncDebugInfoMessage(FriendlyByteBuf buf) {
        this(buf.readInt(), buf.m_130277_(), buf.readInt(), buf.readInt(), buf.readInt(), buf.readInt(), buf.readInt(), buf.readInt());
    }

    public SyncDebugInfoMessage(int entityId, String enumString, int age, int matingCooldown, int playingCooldown, int climbingCooldown, int hunger, int mood) {
        this.entityId = entityId;
        this.enumString = enumString;
        this.age = age;
        this.matingCooldown = matingCooldown;
        this.playingCooldown = playingCooldown;
        this.climbingCooldown = climbingCooldown;
        this.hunger = hunger;
        this.mood = mood;
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeInt(this.entityId);
        buf.m_130070_(this.enumString);
        buf.writeInt(this.age);
        buf.writeInt(this.matingCooldown);
        buf.writeInt(this.playingCooldown);
        buf.writeInt(this.climbingCooldown);
        buf.writeInt(this.hunger);
        buf.writeInt(this.mood);
    }

    public void apply(Supplier<NetworkManager.PacketContext> contextSupplier) {
        contextSupplier.get().queue(() -> {
            Player player = ((NetworkManager.PacketContext)contextSupplier.get()).getPlayer();
            if (Version.debugEnabled() && player != null) {
                Entity patt2905$temp;
                if (player.m_9236_().f_46443_) {
                    if (Minecraft.m_91087_().f_91080_ instanceof DebugScreen) {
                        if (DebugScreen.entity == null || DebugScreen.entity.m_19879_() != this.entityId) {
                            return;
                        }
                    } else {
                        return;
                    }
                }
                if ((patt2905$temp = player.m_9236_().m_6815_(this.entityId)) instanceof Prehistoric) {
                    Prehistoric prehistoric = (Prehistoric)patt2905$temp;
                    if (!player.m_9236_().f_46443_) {
                        prehistoric.setAgeInTicks(this.age);
                        prehistoric.setHunger(this.hunger);
                        prehistoric.moodSystem.setMood(this.mood);
                    }
                    prehistoric.setGender(Gender.valueOf(this.enumString));
                    prehistoric.setMatingCooldown(this.matingCooldown);
                    prehistoric.moodSystem.setPlayingCooldown(this.playingCooldown);
                    prehistoric.setClimbingCooldown(this.climbingCooldown);
                    prehistoric.refreshTexturePath();
                    prehistoric.m_6210_();
                    prehistoric.updateAbilities();
                } else {
                    Entity patt3716$temp = player.m_9236_().m_6815_(this.entityId);
                    if (patt3716$temp instanceof PrehistoricSkeleton) {
                        PrehistoricSkeleton fossil = (PrehistoricSkeleton)patt3716$temp;
                        fossil.setInfoType(this.enumString);
                        fossil.setAge(this.age);
                    } else {
                        Entity patt3914$temp = player.m_9236_().m_6815_(this.entityId);
                        if (patt3914$temp instanceof DinosaurEgg) {
                            DinosaurEgg egg = (DinosaurEgg)patt3914$temp;
                            egg.setHatchingTime(this.age);
                        } else {
                            Animal animal;
                            Entity patt4054$temp = player.m_9236_().m_6815_(this.entityId);
                            if (patt4054$temp instanceof Animal && ModCapabilities.hasEmbryo(animal = (Animal)patt4054$temp)) {
                                ModCapabilities.setEmbryoProgress(animal, this.age);
                                ModCapabilities.syncMammalWithClient(animal, this.age, ModCapabilities.getEmbryo(animal));
                            }
                        }
                    }
                }
            }
        });
    }
}

