/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.network.debug;

import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricDebug;
import com.github.teamfossilsarcheology.fossil.util.Version;
import dev.architectury.networking.NetworkManager;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;

public class C2SDisableAIMessage {
    private final int id;
    private final boolean disableAI;
    private final byte type;

    public C2SDisableAIMessage(FriendlyByteBuf buf) {
        this(buf.readInt(), buf.readBoolean(), buf.readByte());
    }

    public C2SDisableAIMessage(int id, boolean disableAI, byte type) {
        this.id = id;
        this.disableAI = disableAI;
        this.type = type;
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeInt(this.id);
        buf.writeBoolean(this.disableAI);
        buf.writeByte((int)this.type);
    }

    public void apply(Supplier<NetworkManager.PacketContext> contextSupplier) {
        contextSupplier.get().queue(() -> {
            Entity entity = ((NetworkManager.PacketContext)contextSupplier.get()).getPlayer().m_9236_().m_6815_(this.id);
            if (entity instanceof PrehistoricDebug) {
                PrehistoricDebug prehistoric = (PrehistoricDebug)entity;
                if (Version.debugEnabled()) {
                    prehistoric.disableCustomAI(this.type, this.disableAI);
                }
            }
        });
    }
}

