/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.network;

import com.github.teamfossilsarcheology.fossil.entity.ToyTetheredLog;
import dev.architectury.networking.NetworkManager;
import dev.architectury.utils.Env;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;

public class S2CSyncToyAnimationMessage {
    private final int entityId;
    private final float animationX;
    private final float animationZ;

    public S2CSyncToyAnimationMessage(FriendlyByteBuf buf) {
        this.entityId = buf.readInt();
        this.animationX = buf.readFloat();
        this.animationZ = buf.readFloat();
    }

    public S2CSyncToyAnimationMessage(int entityId, float animationX, float animationZ) {
        this.entityId = entityId;
        this.animationX = animationX;
        this.animationZ = animationZ;
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeInt(this.entityId);
        buf.writeFloat(this.animationX);
        buf.writeFloat(this.animationZ);
    }

    public void apply(Supplier<NetworkManager.PacketContext> contextSupplier) {
        if (contextSupplier.get().getEnvironment() == Env.SERVER) {
            return;
        }
        contextSupplier.get().queue(() -> {
            Entity entity = ((NetworkManager.PacketContext)contextSupplier.get()).getPlayer().m_9236_().m_6815_(this.entityId);
            if (entity instanceof ToyTetheredLog) {
                ToyTetheredLog toy = (ToyTetheredLog)entity;
                toy.startAnimation(this.animationX, this.animationZ);
            }
        });
    }
}

