/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.network;

import com.github.teamfossilsarcheology.fossil.capabilities.ModCapabilities;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.EntityInfo;
import dev.architectury.networking.NetworkManager;
import dev.architectury.utils.Env;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Animal;
import org.jetbrains.annotations.Nullable;

public class S2CMammalCapMessage {
    private final int entityId;
    private final int embryoProgress;
    private final EntityInfo embryo;

    public S2CMammalCapMessage(FriendlyByteBuf buf) {
        EntityInfo temp;
        this.entityId = buf.readInt();
        this.embryoProgress = buf.readInt();
        try {
            temp = EntityInfo.fromNbt(buf.m_130277_());
        }
        catch (IllegalArgumentException e) {
            temp = null;
        }
        this.embryo = temp;
    }

    public S2CMammalCapMessage(Animal animal, int embryoProgress, @Nullable EntityInfo embryo) {
        this.entityId = animal.m_19879_();
        this.embryoProgress = embryoProgress;
        this.embryo = embryo;
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeInt(this.entityId);
        buf.writeInt(this.embryoProgress);
        if (this.embryo != null) {
            buf.m_130070_(this.embryo.name());
        } else {
            buf.m_130070_("null");
        }
    }

    public void apply(Supplier<NetworkManager.PacketContext> contextSupplier) {
        if (contextSupplier.get().getEnvironment() == Env.SERVER) {
            return;
        }
        contextSupplier.get().queue(() -> {
            Entity entity = ((NetworkManager.PacketContext)contextSupplier.get()).getPlayer().m_9236_().m_6815_(this.entityId);
            if (entity instanceof Animal) {
                Animal animal = (Animal)entity;
                ModCapabilities.setEmbryoProgress(animal, this.embryoProgress);
                ModCapabilities.setEmbryo(animal, this.embryo);
            }
        });
    }
}

