/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.item;

import com.github.teamfossilsarcheology.fossil.entity.ModEntities;
import com.github.teamfossilsarcheology.fossil.entity.PrehistoricSkeleton;
import com.github.teamfossilsarcheology.fossil.entity.data.EntityDataLoader;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricEntityInfo;
import com.github.teamfossilsarcheology.fossil.item.ModTabs;
import com.github.teamfossilsarcheology.fossil.util.TimePeriod;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FossilItem
extends Item {
    @Nullable
    private final TimePeriod timePeriod;

    public FossilItem(@Nullable TimePeriod timePeriod) {
        super(new Item.Properties().arch$tab(ModTabs.FA_OTHER_ITEM_TAB));
        this.timePeriod = timePeriod;
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext context) {
        if (this.timePeriod == null) {
            return InteractionResult.FAIL;
        }
        Level level = context.m_43725_();
        List<PrehistoricEntityInfo> entityInfos = PrehistoricEntityInfo.entitiesWithSkeleton(this.timePeriod);
        PrehistoricEntityInfo info = entityInfos.get(level.m_213780_().m_188503_(entityInfos.size()));
        if (info == null) {
            return InteractionResult.FAIL;
        }
        BlockPos blockPos = new BlockPlaceContext(context).m_8083_();
        Vec3 vec3 = Vec3.m_82539_((Vec3i)blockPos);
        AABB aABB = info.entityType().m_20680_().m_20388_(EntityDataLoader.INSTANCE.getData(info.resourceName).minScale()).m_20384_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
        if (!level.m_45756_(null, aABB) || !level.m_45933_(null, aABB).isEmpty()) {
            return InteractionResult.FAIL;
        }
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            PrehistoricSkeleton fossil = (PrehistoricSkeleton)((EntityType)ModEntities.SKELETON.get()).m_262451_(serverLevel, null, null, blockPos, MobSpawnType.SPAWN_EGG, false, false);
            if (fossil == null) {
                return InteractionResult.FAIL;
            }
            fossil.m_7678_(fossil.m_20185_(), fossil.m_20186_(), fossil.m_20189_(), -context.m_43723_().f_20885_, 0.0f);
            fossil.setInfoType(info);
            serverLevel.m_47205_((Entity)fossil);
            level.m_6263_(null, fossil.m_20185_(), fossil.m_20186_(), fossil.m_20189_(), SoundEvents.f_12423_, SoundSource.BLOCKS, 0.75f, 0.8f);
            fossil.m_146852_(GameEvent.f_157810_, (Entity)context.m_43723_());
        }
        context.m_43722_().m_41774_(1);
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }
}

