/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.forge.tests;

import com.github.teamfossilsarcheology.fossil.block.ModBlocks;
import com.github.teamfossilsarcheology.fossil.block.custom_blocks.AnalyzerBlock;
import com.github.teamfossilsarcheology.fossil.block.custom_blocks.CultureVatBlock;
import com.github.teamfossilsarcheology.fossil.block.custom_blocks.SifterBlock;
import com.github.teamfossilsarcheology.fossil.block.custom_blocks.VaseBlock;
import com.github.teamfossilsarcheology.fossil.block.custom_blocks.WorktableBlock;
import com.github.teamfossilsarcheology.fossil.block.entity.AnalyzerBlockEntity;
import com.github.teamfossilsarcheology.fossil.block.entity.CultureVatBlockEntity;
import com.github.teamfossilsarcheology.fossil.block.entity.SifterBlockEntity;
import com.github.teamfossilsarcheology.fossil.block.entity.WorktableBlockEntity;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricEntityInfo;
import com.github.teamfossilsarcheology.fossil.inventory.CultureVatMenu;
import com.github.teamfossilsarcheology.fossil.item.ModItems;
import com.github.teamfossilsarcheology.fossil.recipe.AnalyzerRecipe;
import com.github.teamfossilsarcheology.fossil.recipe.CultureVatRecipe;
import com.github.teamfossilsarcheology.fossil.recipe.ModRecipes;
import com.github.teamfossilsarcheology.fossil.recipe.SifterRecipe;
import com.github.teamfossilsarcheology.fossil.recipe.WithFuelRecipe;
import com.github.teamfossilsarcheology.fossil.recipe.WorktableRecipe;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.gametest.framework.GameTest;
import net.minecraft.gametest.framework.GameTestAssertException;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.gametest.GameTestHolder;
import net.minecraftforge.gametest.PrefixGameTestTemplate;

@PrefixGameTestTemplate(value=false)
@GameTestHolder(value="fossil")
public class RecipeTests {
    private static final BlockPos MACHINE_POS = new BlockPos(0, 1, 0);

    protected static BlockEntity getBlockEntity(BlockPos machinePos, GameTestHelper helper, Class<?> machineBlockClass) {
        helper.m_177271_(machinePos, machineBlockClass::isInstance, "Machine block not found");
        return helper.m_177347_(machinePos);
    }

    @GameTest(m_177043_="culture_vat", m_177046_="culture_vat", m_177042_=20)
    public static void cultureVatFuel(GameTestHelper helper) {
        BlockEntity blockEntity = RecipeTests.getBlockEntity(MACHINE_POS, helper, CultureVatBlock.class);
        if (blockEntity instanceof CultureVatBlockEntity) {
            CultureVatBlockEntity cultureVatEntity = (CultureVatBlockEntity)blockEntity;
            Item fuelItem = (Item)ModItems.BIO_GOO.get();
            Item inputItem = PrehistoricEntityInfo.ALLOSAURUS.dnaItem;
            cultureVatEntity.m_6836_(1, new ItemStack((ItemLike)fuelItem));
            helper.m_177242_(MACHINE_POS, fuelItem);
            cultureVatEntity.m_6836_(0, new ItemStack((ItemLike)inputItem));
            helper.m_177117_(1, () -> RecipeTests.assertContainerDoesNotContain(helper, MACHINE_POS, fuelItem));
        }
    }

    @GameTest(m_177043_="culture_vat", m_177046_="culture_vat", m_177042_=20)
    public static void cultureVatInput(GameTestHelper helper) {
        BlockEntity blockEntity = RecipeTests.getBlockEntity(MACHINE_POS, helper, CultureVatBlock.class);
        if (blockEntity instanceof CultureVatBlockEntity) {
            CultureVatBlockEntity cultureVatEntity = (CultureVatBlockEntity)blockEntity;
            Item fuelItem = (Item)ModItems.BIO_GOO.get();
            Item inputItem = PrehistoricEntityInfo.ALLOSAURUS.dnaItem;
            cultureVatEntity.m_6836_(0, new ItemStack((ItemLike)inputItem));
            helper.m_177242_(MACHINE_POS, inputItem);
            cultureVatEntity.m_6836_(1, new ItemStack((ItemLike)fuelItem));
            helper.m_177127_(5L, () -> helper.m_177279_(() -> helper.m_177242_(MACHINE_POS, inputItem)));
        }
    }

    @GameTest(m_177043_="culture_vat", m_177046_="culture_vat", m_177042_=5)
    public static void cultureVatData(GameTestHelper helper) {
        BlockEntity blockEntity = RecipeTests.getBlockEntity(MACHINE_POS, helper, CultureVatBlock.class);
        if (blockEntity instanceof CultureVatBlockEntity) {
            CultureVatBlockEntity cultureVatEntity = (CultureVatBlockEntity)blockEntity;
            Item fuelItem = (Item)ModItems.BIO_GOO.get();
            Item inputItem = PrehistoricEntityInfo.ALLOSAURUS.dnaItem;
            cultureVatEntity.m_6836_(1, new ItemStack((ItemLike)fuelItem));
            ContainerData dataAccess = cultureVatEntity.getDataAccess();
            helper.m_177127_(0L, () -> {
                if (dataAccess.m_6413_(0) != 0) {
                    throw new GameTestAssertException("LitTime should be 0 but is " + dataAccess.m_6413_(0));
                }
                if (dataAccess.m_6413_(1) != 0) {
                    throw new GameTestAssertException("LitDuration should be 0 but is " + dataAccess.m_6413_(1));
                }
                if (dataAccess.m_6413_(2) != 0) {
                    throw new GameTestAssertException("CookingProgress should be 0 but is " + dataAccess.m_6413_(2));
                }
                cultureVatEntity.m_6836_(0, new ItemStack((ItemLike)inputItem));
            });
            int fuelTime = ModRecipes.getCultureVatFuelValue((ItemLike)fuelItem);
            helper.m_177127_(1L, () -> {
                if (dataAccess.m_6413_(0) != fuelTime) {
                    throw new GameTestAssertException("LitTime should be " + fuelTime + " but is " + dataAccess.m_6413_(0));
                }
                if (dataAccess.m_6413_(1) != fuelTime) {
                    throw new GameTestAssertException("LitDuration should be " + fuelTime + " but is " + dataAccess.m_6413_(1));
                }
                if (dataAccess.m_6413_(2) != 1) {
                    throw new GameTestAssertException("CookingProgress should be 1 but is " + dataAccess.m_6413_(2));
                }
            });
            helper.m_177127_(2L, () -> ((GameTestHelper)helper).m_177412_());
        }
    }

    @GameTest(m_177043_="culture_vat", m_177046_="culture_vat", m_177042_=2000)
    public static void cultureVatRecipes(GameTestHelper helper) {
        BlockEntity blockEntity = RecipeTests.getBlockEntity(MACHINE_POS, helper, CultureVatBlock.class);
        if (blockEntity instanceof CultureVatBlockEntity) {
            CultureVatBlockEntity cultureVatEntity = (CultureVatBlockEntity)blockEntity;
            List list = helper.m_177100_().m_7465_().m_44013_((RecipeType)ModRecipes.CULTURE_VAT_TYPE.get());
            ContainerData dataAccess = cultureVatEntity.getDataAccess();
            for (int i = 0; i < list.size(); ++i) {
                CultureVatRecipe recipe = (CultureVatRecipe)list.get(i);
                Item fuelItem = recipe.getFuel().m_43908_()[0].m_41720_();
                Item inputItem = recipe.getInput().m_43908_()[0].m_41720_();
                int fuelNeeded = recipe.getDuration() / ModRecipes.getCultureVatFuelValue((ItemLike)fuelItem);
                long startTick = (long)i * 3L;
                helper.m_177127_(startTick, () -> {
                    cultureVatEntity.m_6836_(1, new ItemStack((ItemLike)fuelItem, fuelNeeded));
                    cultureVatEntity.m_6836_(0, new ItemStack((ItemLike)inputItem));
                });
                helper.m_177127_(startTick + 1L, () -> dataAccess.m_8050_(2, CultureVatMenu.CULTIVATION_DURATION - 1));
                helper.m_177127_(startTick + 2L, () -> {
                    if (!ItemStack.m_41656_((ItemStack)cultureVatEntity.m_8020_(2), (ItemStack)recipe.m_8043_(null))) {
                        throw new GameTestAssertException("Output does not contain " + recipe.m_8043_(null).m_41720_() + " but instead " + cultureVatEntity.m_8020_(2));
                    }
                    cultureVatEntity.m_6836_(2, ItemStack.f_41583_);
                });
            }
            helper.m_177127_((long)list.size() * 3L, () -> ((GameTestHelper)helper).m_177412_());
        }
    }

    @GameTest(m_177043_="culture_vat", m_177046_="culture_vat", m_177042_=20)
    public static void cultureVatResult(GameTestHelper helper) {
        BlockEntity blockEntity = RecipeTests.getBlockEntity(MACHINE_POS, helper, CultureVatBlock.class);
        if (blockEntity instanceof CultureVatBlockEntity) {
            CultureVatBlockEntity cultureVatEntity = (CultureVatBlockEntity)blockEntity;
            Item fuelItem = (Item)ModItems.BIO_GOO.get();
            Item inputItem = PrehistoricEntityInfo.ALLOSAURUS.dnaItem;
            CultureVatRecipe recipe = ModRecipes.getCultureVatRecipeForItem(new WithFuelRecipe.ContainerWithAnyFuel(new ItemStack((ItemLike)inputItem), new ItemStack((ItemLike)fuelItem)), (Level)helper.m_177100_());
            int fuelNeeded = recipe.getDuration() / ModRecipes.getCultureVatFuelValue((ItemLike)fuelItem);
            cultureVatEntity.m_6836_(1, new ItemStack((ItemLike)fuelItem, fuelNeeded));
            cultureVatEntity.m_6836_(0, new ItemStack((ItemLike)inputItem));
            ContainerData dataAccess = cultureVatEntity.getDataAccess();
            helper.m_177127_(1L, () -> dataAccess.m_8050_(2, CultureVatMenu.CULTIVATION_DURATION - 10));
            helper.m_177127_(11L, () -> {
                if (!ItemStack.m_41656_((ItemStack)cultureVatEntity.m_8020_(2), (ItemStack)recipe.m_8043_(null))) {
                    throw new GameTestAssertException("Output does not contain " + recipe.m_8043_(null).m_41720_() + " but instead " + cultureVatEntity.m_8020_(2));
                }
            });
            helper.m_177127_(12L, () -> ((GameTestHelper)helper).m_177412_());
        }
    }

    @GameTest(m_177043_="worktable", m_177046_="worktable", m_177042_=20)
    public static void worktableFuel(GameTestHelper helper) {
        BlockEntity blockEntity = RecipeTests.getBlockEntity(MACHINE_POS, helper, WorktableBlock.class);
        if (blockEntity instanceof WorktableBlockEntity) {
            WorktableBlockEntity worktableEntity = (WorktableBlockEntity)blockEntity;
            Item fuelItem = (Item)ModItems.POTTERY_SHARD.get();
            Item inputItem = ((VaseBlock)((Object)ModBlocks.KYLIX_VASE_DAMAGED.get())).m_5456_();
            worktableEntity.m_6836_(1, new ItemStack((ItemLike)fuelItem));
            helper.m_177242_(MACHINE_POS, fuelItem);
            worktableEntity.m_6836_(0, new ItemStack((ItemLike)inputItem));
            helper.m_177117_(1, () -> RecipeTests.assertContainerDoesNotContain(helper, MACHINE_POS, fuelItem));
        }
    }

    @GameTest(m_177043_="worktable", m_177046_="worktable", m_177042_=20)
    public static void worktableInput(GameTestHelper helper) {
        BlockEntity blockEntity = RecipeTests.getBlockEntity(MACHINE_POS, helper, WorktableBlock.class);
        if (blockEntity instanceof WorktableBlockEntity) {
            WorktableBlockEntity worktableEntity = (WorktableBlockEntity)blockEntity;
            Item fuelItem = (Item)ModItems.POTTERY_SHARD.get();
            Item inputItem = ((VaseBlock)((Object)ModBlocks.KYLIX_VASE_DAMAGED.get())).m_5456_();
            worktableEntity.m_6836_(0, new ItemStack((ItemLike)inputItem));
            helper.m_177242_(MACHINE_POS, inputItem);
            worktableEntity.m_6836_(1, new ItemStack((ItemLike)fuelItem));
            helper.m_177127_(5L, () -> helper.m_177279_(() -> helper.m_177242_(MACHINE_POS, inputItem)));
        }
    }

    @GameTest(m_177043_="worktable", m_177046_="worktable", m_177042_=5)
    public static void worktableData(GameTestHelper helper) {
        BlockEntity blockEntity = RecipeTests.getBlockEntity(MACHINE_POS, helper, WorktableBlock.class);
        if (blockEntity instanceof WorktableBlockEntity) {
            WorktableBlockEntity worktableEntity = (WorktableBlockEntity)blockEntity;
            Item fuelItem = (Item)ModItems.POTTERY_SHARD.get();
            Item inputItem = ((VaseBlock)((Object)ModBlocks.KYLIX_VASE_DAMAGED.get())).m_5456_();
            worktableEntity.m_6836_(1, new ItemStack((ItemLike)fuelItem));
            ContainerData dataAccess = worktableEntity.getDataAccess();
            helper.m_177127_(0L, () -> {
                if (dataAccess.m_6413_(0) != 0) {
                    throw new GameTestAssertException("LitTime should be 0 but is " + dataAccess.m_6413_(0));
                }
                if (dataAccess.m_6413_(1) != 0) {
                    throw new GameTestAssertException("LitDuration should be 0 but is " + dataAccess.m_6413_(1));
                }
                if (dataAccess.m_6413_(2) != 0) {
                    throw new GameTestAssertException("CookingProgress should be 0 but is " + dataAccess.m_6413_(2));
                }
                if (dataAccess.m_6413_(3) != 0) {
                    throw new GameTestAssertException("CookingTotalTime should be 0 but is " + dataAccess.m_6413_(3));
                }
                worktableEntity.m_6836_(0, new ItemStack((ItemLike)inputItem));
            });
            int fuelTime = ModRecipes.getWorktableFuelValue((ItemLike)fuelItem);
            int smeltTime = worktableEntity.timeToSmelt(new ItemStack((ItemLike)inputItem), new ItemStack((ItemLike)fuelItem));
            helper.m_177127_(1L, () -> {
                if (dataAccess.m_6413_(0) != fuelTime) {
                    throw new GameTestAssertException("LitTime should be " + fuelTime + " but is " + dataAccess.m_6413_(0));
                }
                if (dataAccess.m_6413_(1) != fuelTime) {
                    throw new GameTestAssertException("LitDuration should be " + fuelTime + " but is " + dataAccess.m_6413_(1));
                }
                if (dataAccess.m_6413_(2) != 1) {
                    throw new GameTestAssertException("CookingProgress should be 1 but is " + dataAccess.m_6413_(2));
                }
                if (dataAccess.m_6413_(3) != smeltTime) {
                    throw new GameTestAssertException("CookingTotalTime should be " + smeltTime + " but is " + dataAccess.m_6413_(3));
                }
            });
            helper.m_177127_(2L, () -> ((GameTestHelper)helper).m_177412_());
        }
    }

    @GameTest(m_177043_="worktable", m_177046_="worktable", m_177042_=2000)
    public static void worktableRecipes(GameTestHelper helper) {
        BlockEntity blockEntity = RecipeTests.getBlockEntity(MACHINE_POS, helper, WorktableBlock.class);
        if (blockEntity instanceof WorktableBlockEntity) {
            WorktableBlockEntity worktableEntity = (WorktableBlockEntity)blockEntity;
            List list = helper.m_177100_().m_7465_().m_44013_((RecipeType)ModRecipes.WORKTABLE_TYPE.get());
            ContainerData dataAccess = worktableEntity.getDataAccess();
            for (int i = 0; i < list.size(); ++i) {
                WorktableRecipe recipe = (WorktableRecipe)list.get(i);
                Item fuelItem = recipe.getFuel().m_43908_()[0].m_41720_();
                Item inputItem = recipe.getInput().m_43908_()[0].m_41720_();
                int fuelNeeded = recipe.getDuration() / ModRecipes.getWorktableFuelValue((ItemLike)fuelItem);
                long startTick = (long)i * 3L;
                helper.m_177127_(startTick, () -> {
                    worktableEntity.m_6836_(1, new ItemStack((ItemLike)fuelItem, fuelNeeded));
                    worktableEntity.m_6836_(0, new ItemStack((ItemLike)inputItem));
                });
                int smeltTime = worktableEntity.timeToSmelt(new ItemStack((ItemLike)inputItem), new ItemStack((ItemLike)fuelItem));
                helper.m_177127_(startTick + 1L, () -> dataAccess.m_8050_(2, smeltTime - 1));
                helper.m_177127_(startTick + 2L, () -> {
                    if (!ItemStack.m_41656_((ItemStack)worktableEntity.m_8020_(2), (ItemStack)recipe.m_8043_(null))) {
                        throw new GameTestAssertException("Output does not contain " + recipe.m_8043_(null).m_41720_() + " but instead " + worktableEntity.m_8020_(2));
                    }
                    worktableEntity.m_6836_(2, ItemStack.f_41583_);
                });
            }
            helper.m_177127_((long)list.size() * 3L, () -> ((GameTestHelper)helper).m_177412_());
        }
    }

    @GameTest(m_177043_="worktable", m_177046_="worktable", m_177042_=20)
    public static void worktableResult(GameTestHelper helper) {
        BlockEntity blockEntity = RecipeTests.getBlockEntity(MACHINE_POS, helper, WorktableBlock.class);
        if (blockEntity instanceof WorktableBlockEntity) {
            WorktableBlockEntity worktableEntity = (WorktableBlockEntity)blockEntity;
            Item fuelItem = (Item)ModItems.POTTERY_SHARD.get();
            Item inputItem = ((VaseBlock)((Object)ModBlocks.KYLIX_VASE_DAMAGED.get())).m_5456_();
            WorktableRecipe recipe = ModRecipes.getWorktableRecipeForItem(new WithFuelRecipe.ContainerWithAnyFuel(new ItemStack((ItemLike)inputItem), new ItemStack((ItemLike)fuelItem)), (Level)helper.m_177100_());
            int fuelNeeded = recipe.getDuration() / ModRecipes.getWorktableFuelValue((ItemLike)fuelItem);
            worktableEntity.m_6836_(1, new ItemStack((ItemLike)fuelItem, fuelNeeded));
            worktableEntity.m_6836_(0, new ItemStack((ItemLike)inputItem));
            ContainerData dataAccess = worktableEntity.getDataAccess();
            int smeltTime = worktableEntity.timeToSmelt(new ItemStack((ItemLike)inputItem), new ItemStack((ItemLike)fuelItem));
            helper.m_177127_(1L, () -> dataAccess.m_8050_(2, smeltTime - 10));
            helper.m_177127_(11L, () -> {
                if (!ItemStack.m_41656_((ItemStack)worktableEntity.m_8020_(2), (ItemStack)recipe.m_8043_(null))) {
                    throw new GameTestAssertException("Output does not contain " + recipe.m_8043_(null).m_41720_() + " but instead " + worktableEntity.m_8020_(2));
                }
            });
            helper.m_177127_(12L, () -> ((GameTestHelper)helper).m_177412_());
        }
    }

    @GameTest(m_177043_="analyzer", m_177046_="analyzer", m_177042_=20)
    public static void analyzerInput(GameTestHelper helper) {
        BlockEntity blockEntity = RecipeTests.getBlockEntity(MACHINE_POS, helper, AnalyzerBlock.class);
        if (blockEntity instanceof AnalyzerBlockEntity) {
            AnalyzerBlockEntity analyzerEntity = (AnalyzerBlockEntity)blockEntity;
            Item inputItem = Blocks.f_50041_.m_5456_();
            analyzerEntity.m_6836_(0, new ItemStack((ItemLike)inputItem));
            helper.m_177242_(MACHINE_POS, inputItem);
            helper.m_177127_(1L, () -> {
                analyzerEntity.getDataAccess().m_8050_(0, 199);
                helper.m_177242_(MACHINE_POS, inputItem);
            });
            helper.m_177127_(2L, () -> helper.m_177279_(() -> RecipeTests.assertContainerDoesNotContain(helper, MACHINE_POS, inputItem)));
        }
    }

    @GameTest(m_177043_="analyzer", m_177046_="analyzer", m_177042_=5)
    public static void analyzerData(GameTestHelper helper) {
        BlockEntity blockEntity = RecipeTests.getBlockEntity(MACHINE_POS, helper, AnalyzerBlock.class);
        if (blockEntity instanceof AnalyzerBlockEntity) {
            AnalyzerBlockEntity analyzerEntity = (AnalyzerBlockEntity)blockEntity;
            Item inputItem = Blocks.f_50041_.m_5456_();
            ContainerData dataAccess = analyzerEntity.getDataAccess();
            helper.m_177127_(0L, () -> {
                if (dataAccess.m_6413_(0) != 0) {
                    throw new GameTestAssertException("CookingProgress should be 0 but is " + dataAccess.m_6413_(0));
                }
                analyzerEntity.m_6836_(0, new ItemStack((ItemLike)inputItem));
            });
            helper.m_177127_(1L, () -> {
                if (dataAccess.m_6413_(0) != 1) {
                    throw new GameTestAssertException("CookingProgress should be 1 but is " + dataAccess.m_6413_(2));
                }
            });
            helper.m_177127_(2L, () -> ((GameTestHelper)helper).m_177412_());
        }
    }

    @GameTest(m_177043_="analyzer", m_177046_="analyzer", m_177042_=2000)
    public static void analyzerRecipes(GameTestHelper helper) {
        BlockEntity blockEntity = RecipeTests.getBlockEntity(MACHINE_POS, helper, AnalyzerBlock.class);
        if (blockEntity instanceof AnalyzerBlockEntity) {
            AnalyzerBlockEntity analyzerEntity = (AnalyzerBlockEntity)blockEntity;
            List list = helper.m_177100_().m_7465_().m_44013_((RecipeType)ModRecipes.ANALYZER_TYPE.get());
            ContainerData dataAccess = analyzerEntity.getDataAccess();
            for (int i = 0; i < list.size(); ++i) {
                AnalyzerRecipe recipe = (AnalyzerRecipe)list.get(i);
                Item inputItem = recipe.getInput().m_43908_()[0].m_41720_();
                long startTick = (long)i * 3L;
                helper.m_177127_(startTick, () -> analyzerEntity.m_6836_(0, new ItemStack((ItemLike)inputItem)));
                int smeltTime = 200;
                helper.m_177127_(startTick + 1L, () -> dataAccess.m_8050_(0, smeltTime - 1));
                helper.m_177127_(startTick + 2L, () -> {
                    if (recipe.getWeightedOutputs().values().stream().noneMatch(itemStack -> ItemStack.m_41656_((ItemStack)itemStack, (ItemStack)analyzerEntity.m_8020_(9)))) {
                        throw new GameTestAssertException("Output does not contain any results from " + recipe.m_6423_() + " but instead " + analyzerEntity.m_8020_(9));
                    }
                    analyzerEntity.m_6836_(9, ItemStack.f_41583_);
                });
            }
            helper.m_177127_((long)list.size() * 3L, () -> ((GameTestHelper)helper).m_177412_());
        }
    }

    @GameTest(m_177043_="sifter", m_177046_="sifter", m_177042_=20)
    public static void sifterInput(GameTestHelper helper) {
        BlockEntity blockEntity = RecipeTests.getBlockEntity(MACHINE_POS, helper, SifterBlock.class);
        if (blockEntity instanceof SifterBlockEntity) {
            SifterBlockEntity sifterEntity = (SifterBlockEntity)blockEntity;
            Item inputItem = Blocks.f_49992_.m_5456_();
            sifterEntity.m_6836_(0, new ItemStack((ItemLike)inputItem));
            helper.m_177242_(MACHINE_POS, inputItem);
            helper.m_177127_(1L, () -> {
                sifterEntity.getDataAccess().m_8050_(0, 199);
                helper.m_177242_(MACHINE_POS, inputItem);
            });
            helper.m_177127_(2L, () -> helper.m_177279_(() -> RecipeTests.assertContainerDoesNotContain(helper, MACHINE_POS, inputItem)));
        }
    }

    @GameTest(m_177043_="sifter", m_177046_="sifter", m_177042_=5)
    public static void sifterData(GameTestHelper helper) {
        BlockEntity blockEntity = RecipeTests.getBlockEntity(MACHINE_POS, helper, SifterBlock.class);
        if (blockEntity instanceof SifterBlockEntity) {
            SifterBlockEntity sifterEntity = (SifterBlockEntity)blockEntity;
            Item inputItem = Blocks.f_49992_.m_5456_();
            ContainerData dataAccess = sifterEntity.getDataAccess();
            helper.m_177127_(0L, () -> {
                if (dataAccess.m_6413_(0) != 0) {
                    throw new GameTestAssertException("CookingProgress should be 0 but is " + dataAccess.m_6413_(0));
                }
                sifterEntity.m_6836_(0, new ItemStack((ItemLike)inputItem));
            });
            helper.m_177127_(1L, () -> {
                if (dataAccess.m_6413_(0) != 1) {
                    throw new GameTestAssertException("CookingProgress should be 1 but is " + dataAccess.m_6413_(0));
                }
            });
            helper.m_177127_(2L, () -> ((GameTestHelper)helper).m_177412_());
        }
    }

    @GameTest(m_177043_="sifter", m_177046_="sifter", m_177042_=2000)
    public static void sifterRecipes(GameTestHelper helper) {
        BlockEntity blockEntity = RecipeTests.getBlockEntity(MACHINE_POS, helper, SifterBlock.class);
        if (blockEntity instanceof SifterBlockEntity) {
            SifterBlockEntity sifterEntity = (SifterBlockEntity)blockEntity;
            List list = helper.m_177100_().m_7465_().m_44013_((RecipeType)ModRecipes.SIFTER_TYPE.get());
            ContainerData dataAccess = sifterEntity.getDataAccess();
            for (int i = 0; i < list.size(); ++i) {
                SifterRecipe recipe = (SifterRecipe)list.get(i);
                Item inputItem = recipe.getInput().m_43908_()[0].m_41720_();
                long startTick = (long)i * 3L;
                helper.m_177127_(startTick, () -> sifterEntity.m_6836_(0, new ItemStack((ItemLike)inputItem)));
                helper.m_177127_(startTick + 1L, () -> dataAccess.m_8050_(0, 199));
                helper.m_177127_(startTick + 2L, () -> {
                    if (recipe.getWeightedOutputs().values().stream().noneMatch(itemStack -> ItemStack.m_41656_((ItemStack)itemStack, (ItemStack)sifterEntity.m_8020_(1)))) {
                        throw new GameTestAssertException("Output does not contain any results from " + recipe.m_6423_() + " but instead " + sifterEntity.m_8020_(1));
                    }
                    sifterEntity.m_6836_(1, ItemStack.f_41583_);
                });
            }
            helper.m_177127_((long)list.size() * 3L, () -> ((GameTestHelper)helper).m_177412_());
        }
    }

    private static void assertContainerDoesNotContain(GameTestHelper helper, BlockPos pos, Item item) {
        BlockPos blockPos = helper.m_177449_(pos);
        BlockEntity blockEntity = helper.m_177100_().m_7702_(blockPos);
        if (blockEntity instanceof BaseContainerBlockEntity && ((BaseContainerBlockEntity)blockEntity).m_18947_(item) > 0) {
            throw new GameTestAssertException("Container should not contain: " + item);
        }
    }
}

