/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.forge.data.providers;

import com.github.teamfossilsarcheology.fossil.block.ModBlocks;
import com.github.teamfossilsarcheology.fossil.item.ModItems;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.api.data.recipe.BaseRecipeProvider;
import com.simibubi.create.content.processing.recipe.ProcessingRecipe;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeBuilder;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeSerializer;
import com.simibubi.create.foundation.recipe.IRecipeTypeInfo;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.ModLoadedCondition;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class FossilCreateRecipeProvider {
    public static void buildCraftingRecipes(@NotNull Consumer<FinishedRecipe> consumer) {
        FossilCreateRecipeProvider.baseFossil(() -> ModBlocks.CALCITE_FOSSIL.get(), Blocks.f_152497_, consumer);
        FossilCreateRecipeProvider.baseFossil(() -> ModBlocks.DRIPSTONE_FOSSIL.get(), Blocks.f_152537_, consumer);
        FossilCreateRecipeProvider.baseFossil(() -> ModBlocks.RED_SANDSTONE_FOSSIL.get(), Blocks.f_50394_, consumer);
        FossilCreateRecipeProvider.baseFossil(() -> ModBlocks.SANDSTONE_FOSSIL.get(), Blocks.f_50062_, consumer);
        FossilCreateRecipeProvider.baseFossil(() -> ModBlocks.STONE_FOSSIL.get(), Blocks.f_50652_, consumer);
        FossilCreateRecipeProvider.deepslateFossil(() -> ModBlocks.DEEPSLATE_FOSSIL.get(), Blocks.f_152551_, consumer);
        FossilCreateRecipeProvider.deepslateFossil(() -> ModBlocks.TUFF_FOSSIL.get(), Blocks.f_152496_, consumer);
    }

    private static void baseFossil(Supplier<ItemLike> singleIngredient, Block block, Consumer<FinishedRecipe> consumer) {
        FossilCreateRecipeProvider.create((IRecipeTypeInfo)AllRecipeTypes.CRUSHING, singleIngredient, builder -> builder.duration(250).output(0.2f, (ItemLike)ModItems.BIO_FOSSIL.get()).output(0.1f, (ItemLike)ModItems.PlANT_FOSSIL.get()).output(0.1f, (ItemLike)ModItems.RELIC_SCRAP.get()).output(0.35f, (ItemLike)Items.f_42500_).output(0.125f, (ItemLike)ModBlocks.SKULL_BLOCK.get()).output(0.125f, (ItemLike)block).whenModLoaded("create")).register(consumer);
    }

    private static void deepslateFossil(Supplier<ItemLike> singleIngredient, Block block, Consumer<FinishedRecipe> consumer) {
        FossilCreateRecipeProvider.create((IRecipeTypeInfo)AllRecipeTypes.CRUSHING, singleIngredient, builder -> builder.duration(250).output(0.25f, (ItemLike)ModItems.SHALE_FOSSIL.get()).output(0.05f, (ItemLike)ModItems.PlANT_FOSSIL.get()).output(0.05f, (ItemLike)ModItems.RELIC_SCRAP.get()).output(0.35f, (ItemLike)Items.f_42500_).output(0.125f, (ItemLike)ModBlocks.SKULL_BLOCK.get()).output(0.175f, (ItemLike)block).whenModLoaded("create")).register(consumer);
    }

    private static <T extends ProcessingRecipe<?>> BaseRecipeProvider.GeneratedRecipe create(IRecipeTypeInfo recipeType, Supplier<ItemLike> singleIngredient, UnaryOperator<ProcessingRecipeBuilder<T>> transform) {
        ProcessingRecipeSerializer serializer = (ProcessingRecipeSerializer)recipeType.getSerializer();
        return c -> {
            ItemLike itemLike = (ItemLike)singleIngredient.get();
            ((ProcessingRecipeBuilder)transform.apply(new CustomProcessingRecipeBuilder(serializer.getFactory(), new ResourceLocation("fossil", ForgeRegistries.ITEMS.getKey((Object)itemLike.m_5456_()).m_135815_())).withItemIngredients(new Ingredient[]{Ingredient.m_43929_((ItemLike[])new ItemLike[]{itemLike})}))).build(c);
        };
    }

    private static class CustomProcessingRecipeBuilder<T extends ProcessingRecipe<?>>
    extends ProcessingRecipeBuilder<T> {
        private CustomProcessingRecipeBuilder(ProcessingRecipeBuilder.ProcessingRecipeFactory<T> factory, ResourceLocation recipeId) {
            super(factory, recipeId);
        }

        public void build(Consumer<FinishedRecipe> consumer) {
            consumer.accept(new CustomDataGenResult<ProcessingRecipe>(this.build(), this.recipeConditions));
        }

        private static JsonObject toFabric(JsonObject json) {
            String type;
            JsonObject toReturn = new JsonObject();
            if (json.has("type") && (type = json.get("type").getAsString()).equals(ModLoadedCondition.Serializer.INSTANCE.getID().toString())) {
                toReturn.addProperty("condition", "fabric:any_mod_loaded");
                JsonArray mods = new JsonArray();
                mods.add(json.get("modid").getAsString());
                toReturn.add("values", (JsonElement)mods);
            }
            return toReturn;
        }

        private static class CustomDataGenResult<S extends ProcessingRecipe<?>>
        implements FinishedRecipe {
            private final List<ICondition> recipeConditions;
            private final ProcessingRecipeSerializer<S> serializer;
            private final ResourceLocation id;
            private final S recipe;

            public CustomDataGenResult(S recipe, List<ICondition> recipeConditions) {
                this.recipe = recipe;
                this.recipeConditions = recipeConditions;
                IRecipeTypeInfo recipeType = this.recipe.getTypeInfo();
                ResourceLocation typeId = recipeType.getId();
                if (!(recipeType.getSerializer() instanceof ProcessingRecipeSerializer)) {
                    throw new IllegalStateException("Cannot datagen ProcessingRecipe of type: " + typeId);
                }
                this.id = new ResourceLocation(recipe.m_6423_().m_135827_(), typeId.m_135815_() + "/" + recipe.m_6423_().m_135815_());
                this.serializer = (ProcessingRecipeSerializer)recipe.m_7707_();
            }

            public void m_7917_(JsonObject json) {
                this.serializer.write(json, this.recipe);
                if (this.recipeConditions.isEmpty()) {
                    return;
                }
                JsonArray conds = new JsonArray();
                this.recipeConditions.forEach(c -> conds.add((JsonElement)CraftingHelper.serialize((ICondition)c)));
                json.add("conditions", (JsonElement)conds);
                JsonArray fabricConditions = new JsonArray();
                this.recipeConditions.forEach(c -> fabricConditions.add((JsonElement)CustomProcessingRecipeBuilder.toFabric(CraftingHelper.serialize((ICondition)c))));
                json.add("fabric:load_conditions", (JsonElement)fabricConditions);
            }

            @NotNull
            public ResourceLocation m_6445_() {
                return this.id;
            }

            @NotNull
            public RecipeSerializer<?> m_6637_() {
                return this.serializer;
            }

            public JsonObject m_5860_() {
                return null;
            }

            public ResourceLocation m_6448_() {
                return null;
            }
        }
    }
}

