/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.forge.data.loot;

import com.github.teamfossilsarcheology.fossil.FossilMod;
import com.github.teamfossilsarcheology.fossil.block.ModBlocks;
import com.github.teamfossilsarcheology.fossil.block.PrehistoricPlantInfo;
import com.github.teamfossilsarcheology.fossil.block.custom_blocks.AmphoraVaseBlock;
import com.github.teamfossilsarcheology.fossil.block.custom_blocks.FourTallFlowerBlock;
import com.github.teamfossilsarcheology.fossil.block.custom_blocks.TallBerryBushBlock;
import com.github.teamfossilsarcheology.fossil.block.custom_blocks.TallFlowerBlock;
import com.github.teamfossilsarcheology.fossil.block.custom_blocks.TempskyaTopBlock;
import com.github.teamfossilsarcheology.fossil.enchantment.ModEnchantments;
import com.github.teamfossilsarcheology.fossil.item.ModItems;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.AbstractGlassBlock;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.AlternativesEntry;
import net.minecraft.world.level.storage.loot.entries.EntryGroup;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.entries.LootTableReference;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.predicates.ExplosionCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import org.jetbrains.annotations.NotNull;

public class ModBlockLootTables
extends BlockLootSubProvider {
    private static final List<Block> NO_TABLE = List.of((Block)ModBlocks.ASH_VENT.get(), (Block)ModBlocks.HOME_PORTAL.get(), (Block)ModBlocks.ANU_PORTAL.get(), (Block)ModBlocks.SARCOPHAGUS.get(), (Block)ModBlocks.TAR.get(), (Block)ModBlocks.ANU_STATUE.get(), (Block)ModBlocks.ANUBITE_STATUE.get(), (Block)ModBlocks.ANCIENT_CHEST.get(), (Block)ModBlocks.ANU_BARRIER_ORIGIN.get(), (Block)ModBlocks.ANU_BARRIER_FACE.get(), (Block)ModBlocks.MUTANT_TREE_TUMOR.get());
    private static final Set<Item> EXPLOSION_RESISTANT = Set.of();
    private final List<Block> tableDone = new ArrayList<Block>();

    public ModBlockLootTables() {
        super(EXPLOSION_RESISTANT, FeatureFlags.f_244280_.m_247355_());
    }

    public void m_245660_() {
        ModBlocks.FAKE_OBSIDIAN.ifPresent(block -> this.addCustom((Block)block, this.m_247033_((ItemLike)Blocks.f_50080_)));
        ModBlocks.AMBER_ORE.ifPresent(block -> this.addCustom((Block)block, ModBlockLootTables.m_247502_((Block)block, (LootPoolEntryContainer.Builder)((LootPoolEntryContainer.Builder)this.m_247733_((ItemLike)block, (ConditionUserBuilder)((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModBlocks.AMBER_CHUNK_MOSQUITO.get())).m_79080_(LootItemRandomChanceCondition.m_81927_((float)0.05f))).m_79078_((LootItemFunction.Builder)ApplyBonusCount.m_79915_((Enchantment)Enchantments.f_44987_)).m_7170_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModBlocks.AMBER_CHUNK.get())).m_79078_((LootItemFunction.Builder)ApplyBonusCount.m_79915_((Enchantment)Enchantments.f_44987_))))))));
        ModBlocks.ICED_DIRT.ifPresent(block -> this.addCustom((Block)block, ModBlockLootTables.m_245335_((ItemLike)block)));
        ModBlocks.PERMAFROST_BLOCK.ifPresent(block -> this.addCustom((Block)block, this.multiple((Block)block, 20, new ItemLike[]{(ItemLike)ModItems.FERN_SEED_FOSSIL.get(), (ItemLike)ModBlocks.SKULL_BLOCK.get(), (ItemLike)ModItems.FROZEN_MEAT.get(), Items.f_42500_, Items.f_42517_})));
        ModBlocks.SLIME_TRAIL.ifPresent(block -> this.addCustom((Block)block, this.randomItem(Items.f_42518_, 0.33f)));
        ModBlocks.CALAMITES_LEAVES.ifPresent(block -> this.addCustom((Block)block, this.m_246047_((Block)block, (Block)ModBlocks.CALAMITES_SAPLING.get(), new float[]{0.05f, 0.0625f, 0.083333336f, 0.1f})));
        ModBlocks.CORDAITES_LEAVES.ifPresent(block -> this.addCustom((Block)block, this.m_246047_((Block)block, (Block)ModBlocks.CORDAITES_SAPLING.get(), new float[]{0.05f, 0.0625f, 0.083333336f, 0.1f})));
        ModBlocks.MUTANT_TREE_LEAVES.ifPresent(block -> this.addCustom((Block)block, ModBlockLootTables.m_246160_((Block)block, (LootPoolEntryContainer.Builder)((LootPoolEntryContainer.Builder)this.m_247733_((ItemLike)block, (ConditionUserBuilder)LootItem.m_79579_((ItemLike)Items.f_42398_))))));
        ModBlocks.PALM_LEAVES.ifPresent(block -> this.addCustom((Block)block, this.m_246047_((Block)block, (Block)ModBlocks.PALM_SAPLING.get(), new float[]{0.05f, 0.0625f, 0.083333336f, 0.1f})));
        ModBlocks.SIGILLARIA_LEAVES.ifPresent(block -> this.addCustom((Block)block, this.m_246047_((Block)block, (Block)ModBlocks.SIGILLARIA_SAPLING.get(), new float[]{0.05f, 0.0625f, 0.083333336f, 0.1f})));
        ModBlocks.TEMPSKYA_LEAF.ifPresent(block -> this.addCustom((Block)block, this.m_246047_((Block)block, (Block)ModBlocks.TEMPSKYA_SAPLING.get(), new float[]{0.3f, 0.375f, 0.5f, 0.6f})));
        ModBlocks.TEMPSKYA_TOP.ifPresent(block -> {
            LootPoolSingletonContainer.Builder condition = (LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)block).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67697_((Property)TempskyaTopBlock.f_52858_, (Comparable)DoubleBlockHalf.LOWER)));
            this.addCustom((Block)block, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)condition).m_79080_(ExplosionCondition.m_81661_())).m_79165_(LootContextParamSets.f_81421_));
        });
        for (PrehistoricPlantInfo info : PrehistoricPlantInfo.values()) {
            BushBlock flower = info.getPlantBlock();
            LootPoolSingletonContainer.Builder condition = LootItem.m_79579_((ItemLike)flower);
            if (flower instanceof TallFlowerBlock) {
                condition.m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)flower).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67697_((Property)TallFlowerBlock.f_52858_, (Comparable)DoubleBlockHalf.LOWER)));
            } else if (flower instanceof FourTallFlowerBlock) {
                condition.m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)flower).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)FourTallFlowerBlock.LAYER, 0)));
            } else if (flower instanceof TallBerryBushBlock) {
                condition.m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)flower).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67697_((Property)TallBerryBushBlock.f_52858_, (Comparable)DoubleBlockHalf.LOWER)));
            }
            this.addCustom((Block)flower, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)condition).m_79080_(ExplosionCondition.m_81661_())).m_79165_(LootContextParamSets.f_81421_));
        }
        AlternativesEntry.Builder fossils = AlternativesEntry.m_79395_((LootPoolEntryContainer.Builder[])new LootPoolEntryContainer.Builder[]{this.fossilReference("regular_fossil_arch_1", this.enchant((Enchantment)ModEnchantments.ARCHEOLOGY.get(), 1)), this.fossilReference("regular_fossil_arch_2", this.enchant((Enchantment)ModEnchantments.ARCHEOLOGY.get(), 2)), this.fossilReference("regular_fossil_arch_3", this.enchant((Enchantment)ModEnchantments.ARCHEOLOGY.get(), 3)), this.fossilReference("regular_fossil_paleo_1", this.enchant((Enchantment)ModEnchantments.PALEONTOLOGY.get(), 1)), this.fossilReference("regular_fossil_paleo_2", this.enchant((Enchantment)ModEnchantments.PALEONTOLOGY.get(), 2)), this.fossilReference("regular_fossil_paleo_3", this.enchant((Enchantment)ModEnchantments.PALEONTOLOGY.get(), 3)), this.fossilReference("regular_fossil", null)});
        ModBlocks.CALCITE_FOSSIL.ifPresent(block -> this.addCustom((Block)block, ModBlockLootTables.m_247502_((Block)block, (LootPoolEntryContainer.Builder)((LootPoolEntryContainer.Builder)this.m_247733_((ItemLike)block, (ConditionUserBuilder)fossils)))));
        ModBlocks.DRIPSTONE_FOSSIL.ifPresent(block -> this.addCustom((Block)block, ModBlockLootTables.m_247502_((Block)block, (LootPoolEntryContainer.Builder)((LootPoolEntryContainer.Builder)this.m_247733_((ItemLike)block, (ConditionUserBuilder)fossils)))));
        ModBlocks.RED_SANDSTONE_FOSSIL.ifPresent(block -> this.addCustom((Block)block, ModBlockLootTables.m_247502_((Block)block, (LootPoolEntryContainer.Builder)((LootPoolEntryContainer.Builder)this.m_247733_((ItemLike)block, (ConditionUserBuilder)fossils)))));
        ModBlocks.SANDSTONE_FOSSIL.ifPresent(block -> this.addCustom((Block)block, ModBlockLootTables.m_247502_((Block)block, (LootPoolEntryContainer.Builder)((LootPoolEntryContainer.Builder)this.m_247733_((ItemLike)block, (ConditionUserBuilder)fossils)))));
        ModBlocks.STONE_FOSSIL.ifPresent(block -> this.addCustom((Block)block, ModBlockLootTables.m_247502_((Block)block, (LootPoolEntryContainer.Builder)((LootPoolEntryContainer.Builder)this.m_247733_((ItemLike)block, (ConditionUserBuilder)fossils)))));
        AlternativesEntry.Builder deepSlateFossils = AlternativesEntry.m_79395_((LootPoolEntryContainer.Builder[])new LootPoolEntryContainer.Builder[]{this.fossilReference("deep_fossil_arch_1", this.enchant((Enchantment)ModEnchantments.ARCHEOLOGY.get(), 1)), this.fossilReference("deep_fossil_arch_2", this.enchant((Enchantment)ModEnchantments.ARCHEOLOGY.get(), 2)), this.fossilReference("deep_fossil_arch_3", this.enchant((Enchantment)ModEnchantments.ARCHEOLOGY.get(), 3)), this.fossilReference("deep_fossil_paleo_1", this.enchant((Enchantment)ModEnchantments.PALEONTOLOGY.get(), 1)), this.fossilReference("deep_fossil_paleo_2", this.enchant((Enchantment)ModEnchantments.PALEONTOLOGY.get(), 2)), this.fossilReference("deep_fossil_paleo_3", this.enchant((Enchantment)ModEnchantments.PALEONTOLOGY.get(), 3)), this.fossilReference("deep_fossil", null)});
        ModBlocks.DEEPSLATE_FOSSIL.ifPresent(block -> this.addCustom((Block)block, ModBlockLootTables.m_247502_((Block)block, (LootPoolEntryContainer.Builder)((LootPoolEntryContainer.Builder)this.m_247733_((ItemLike)block, (ConditionUserBuilder)deepSlateFossils)))));
        ModBlocks.TUFF_FOSSIL.ifPresent(block -> this.addCustom((Block)block, ModBlockLootTables.m_247502_((Block)block, (LootPoolEntryContainer.Builder)((LootPoolEntryContainer.Builder)this.m_247733_((ItemLike)block, (ConditionUserBuilder)deepSlateFossils)))));
        ModBlocks.BLOCKS.forEach(supplier -> supplier.ifPresent(block -> {
            if (block instanceof AbstractGlassBlock) {
                this.m_245644_((Block)block);
            } else if (block instanceof SlabBlock) {
                this.addCustom((Block)block, this.m_247233_((Block)block));
            } else if (block instanceof DoorBlock || block instanceof AmphoraVaseBlock) {
                this.addCustom((Block)block, this.m_247398_((Block)block));
            } else if (block instanceof BedBlock) {
                this.addCustom((Block)block, this.m_245178_((Block)block, (Property)BedBlock.f_49440_, (Comparable)BedPart.HEAD));
            } else if (!NO_TABLE.contains(block) && !this.tableDone.contains(block)) {
                this.m_245724_((Block)block);
            }
            this.tableDone.add((Block)block);
        }));
        NO_TABLE.forEach(block -> this.m_247577_((Block)block, ModBlockLootTables.m_246386_()));
    }

    private void addCustom(Block block, LootTable.Builder table) {
        this.m_247577_(block, table);
        this.tableDone.add(block);
    }

    private LootTable.Builder randomItem(Item item, float chance) {
        return LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)item).m_79080_(LootItemRandomChanceCondition.m_81927_((float)chance))).m_79080_(ExplosionCondition.m_81661_())).m_79165_(LootContextParamSets.f_81421_);
    }

    private LootTable.Builder multiple(Block block, int weight, ItemLike ... items) {
        EntryGroup.Builder group = EntryGroup.m_165137_((LootPoolEntryContainer.Builder[])new LootPoolEntryContainer.Builder[0]);
        for (ItemLike item : items) {
            group.m_142719_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)item).m_79707_(weight));
        }
        return ModBlockLootTables.m_247502_((Block)block, (LootPoolEntryContainer.Builder)((LootPoolEntryContainer.Builder)this.m_247733_((ItemLike)block, (ConditionUserBuilder)group)));
    }

    private LootPoolSingletonContainer.Builder<?> fossilReference(String location, LootItemCondition.Builder condition) {
        if (condition == null) {
            return LootTableReference.m_79776_((ResourceLocation)FossilMod.location(location));
        }
        return (LootPoolSingletonContainer.Builder)LootTableReference.m_79776_((ResourceLocation)FossilMod.location(location)).m_79080_(condition);
    }

    private LootItemCondition.Builder enchant(Enchantment enchantment, int value) {
        return MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_45071_(new EnchantmentPredicate(enchantment, MinMaxBounds.Ints.m_55371_((int)value))));
    }

    @NotNull
    protected Iterable<Block> getKnownBlocks() {
        ArrayList<Block> list = new ArrayList<Block>();
        ModBlocks.BLOCKS.iterator().forEachRemaining(blockRegistrySupplier -> list.add((Block)blockRegistrySupplier.get()));
        return list;
    }
}

