/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.food;

import com.github.teamfossilsarcheology.fossil.food.FoodType;
import com.github.teamfossilsarcheology.fossil.util.DinopediaInfo;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Set;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.util.GsonHelper;

public enum Diet implements DinopediaInfo
{
    CARNIVORE(FoodType.MEAT),
    HERBIVORE(FoodType.PLANT),
    OMNIVORE(FoodType.MEAT, FoodType.PLANT, FoodType.FISH),
    PISCIVORE(FoodType.FISH),
    CARNIVORE_EGG(FoodType.MEAT, FoodType.EGG),
    INSECTIVORE(FoodType.MEAT),
    PISCI_CARNIVORE(FoodType.MEAT, FoodType.FISH),
    PASSIVE(new FoodType[0]);

    private final Component name = Component.m_237115_((String)("pedia.fossil.diet." + this.name().toLowerCase(Locale.ROOT)));
    private final Component description = Component.m_237115_((String)("pedia.fossil.diet." + this.name().toLowerCase(Locale.ROOT) + ".desc"));
    private final Set<FoodType> flag;

    private Diet(FoodType ... types) {
        this.flag = types.length > 0 ? EnumSet.of(types[0], types) : EnumSet.noneOf(FoodType.class);
    }

    public boolean canEat(FoodType type) {
        return this.flag.contains((Object)type);
    }

    public Set<FoodType> flags() {
        return this.flag;
    }

    @Override
    public Component getName() {
        return this.name;
    }

    @Override
    public Component getDescription() {
        return this.description;
    }

    public static Diet readBuf(FriendlyByteBuf buf) {
        return Diet.valueOf(buf.m_130277_());
    }

    public static void writeBuf(FriendlyByteBuf buf, Diet diet) {
        buf.m_130070_(diet.name());
    }

    public static class Deserializer
    implements JsonDeserializer<Diet> {
        public Diet deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return Diet.valueOf(GsonHelper.m_13851_((JsonObject)json.getAsJsonObject(), (String)"diet", (String)PASSIVE.name()));
        }
    }
}

