/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.entity.variant;

import com.github.teamfossilsarcheology.fossil.entity.variant.ConfigCondition;
import com.github.teamfossilsarcheology.fossil.entity.variant.DateCondition;
import com.github.teamfossilsarcheology.fossil.entity.variant.NameTagCondition;
import com.github.teamfossilsarcheology.fossil.entity.variant.NbtCondition;
import com.github.teamfossilsarcheology.fossil.entity.variant.Variant;
import com.github.teamfossilsarcheology.fossil.entity.variant.VariantCondition;
import com.google.common.base.Preconditions;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;

public class VariantRegistry {
    private static final Map<String, RegistryObject<? extends VariantCondition>> BY_KEY = new Object2ObjectOpenHashMap();
    private static final Map<Class<? extends VariantCondition>, RegistryObject<? extends VariantCondition>> BY_CLASS = new Object2ObjectOpenHashMap();
    private static final List<RegistryObject<? extends VariantCondition>> PRIORITY = new ObjectArrayList();
    public static final RegistryObject<NameTagCondition> NAME_TAG = VariantRegistry.register("nametag", new NameTagCondition.Serializer(), NameTagCondition.class);
    public static final RegistryObject<NbtCondition> NBT = VariantRegistry.register("nbt", new NbtCondition.Serializer(), NbtCondition.class);
    public static final RegistryObject<DateCondition> DATE = VariantRegistry.register("date", new DateCondition.Serializer(), DateCondition.class);
    public static final RegistryObject<ConfigCondition> CONFIG = VariantRegistry.register("config", new ConfigCondition.Serializer(), ConfigCondition.class);

    private VariantRegistry() {
    }

    public static <T extends VariantCondition> RegistryObject<T> register(String key, VariantCondition.Serializer<T> serializer, Class<T> type) {
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(serializer, "serializer");
        Preconditions.checkState((boolean)key.equals(key.toLowerCase(Locale.ROOT)), (String)"key must be lowercase: %s", (Object)key);
        Preconditions.checkState((!BY_KEY.containsKey(key) ? 1 : 0) != 0, (String)"key '%s' already registered as VariantCondition", (Object)key);
        RegistryObject<T> registryObject = new RegistryObject<T>(key, serializer, type, new GsonBuilder().registerTypeAdapter(type, serializer).create());
        BY_KEY.put(key, registryObject);
        BY_CLASS.put(type, registryObject);
        PRIORITY.add(registryObject);
        return registryObject;
    }

    public static RegistryObject<? extends VariantCondition> get(String key) {
        return BY_KEY.get(key);
    }

    public static RegistryObject<? extends VariantCondition> get(VariantCondition condition) {
        return BY_CLASS.get(condition.getClass());
    }

    public static Optional<Variant> getHighestPriority(Map<RegistryObject<?>, VariantCondition.WithVariant<?>> map) {
        for (RegistryObject<? extends VariantCondition> registryObject : PRIORITY) {
            if (!map.containsKey(registryObject)) continue;
            return Optional.ofNullable(map.get(registryObject).variant());
        }
        return Optional.empty();
    }

    public static void register() {
    }

    public static void toNetwork(FriendlyByteBuf buf, VariantCondition condition) {
        BY_CLASS.get(condition.getClass()).toNetwork(buf, condition);
    }

    public static VariantCondition fromNetwork(FriendlyByteBuf buf) {
        String type = buf.m_130277_();
        return VariantRegistry.get((String)type).serializer.fromNetwork(buf);
    }

    public record RegistryObject<T extends VariantCondition>(String id, VariantCondition.Serializer<T> serializer, Type type, Gson gson) {
        public CompoundTag save(CompoundTag tag, VariantCondition.WithVariant<? extends VariantCondition> pair) {
            tag.m_128359_("VariantConditionId", this.id);
            tag.m_128359_("VariantId", pair.variant().getVariantId());
            this.serializer.save(tag, pair.condition());
            return tag;
        }

        public static RegistryObject<? extends VariantCondition> parse(CompoundTag tag) {
            return VariantRegistry.get(tag.m_128461_("VariantConditionId"));
        }

        VariantCondition fromJson(JsonObject object) {
            return (VariantCondition)this.gson.fromJson((JsonElement)object, this.type);
        }

        void toNetwork(FriendlyByteBuf buf, VariantCondition condition) {
            buf.m_130070_(this.id);
            this.serializer.toNetwork(buf, condition);
        }
    }
}

