/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.entity.ai.navigation;

import com.github.teamfossilsarcheology.fossil.entity.ai.navigation.CenteredPath;
import java.util.EnumSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.FlyNodeEvaluator;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.PathFinder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlightPathNavigation
extends FlyingPathNavigation {
    public FlightPathNavigation(Mob mob, Level level) {
        super(mob, level);
    }

    @NotNull
    protected PathFinder m_5532_(int maxVisitedNodes) {
        this.f_26508_ = new FlightNodeEvaluator();
        return new PathFinder(this.f_26508_, maxVisitedNodes);
    }

    @Nullable
    protected Path m_148222_(Set<BlockPos> targets, int regionOffset, boolean offsetUpward, int accuracy, float followRange) {
        return CenteredPath.createFromPath(super.m_148222_(targets, regionOffset, offsetUpward, accuracy, followRange));
    }

    private static class FlightNodeEvaluator
    extends FlyNodeEvaluator {
        private FlightNodeEvaluator() {
        }

        public BlockPathTypes m_264561_(BlockGetter level, int x, int y, int z, EnumSet<BlockPathTypes> nodeTypeEnum, BlockPathTypes nodeType, BlockPos pos) {
            float width = Math.max(0, this.f_77315_ - 2);
            int widthEachSide = Mth.m_14167_((float)(width / 2.0f)) + 1;
            for (int i = 0; i < widthEachSide; ++i) {
                for (int j = 0; j < this.f_77316_; ++j) {
                    for (int k = 0; k < widthEachSide; ++k) {
                        BlockPathTypes blockPathType = this.m_8086_(level, x + i, y + j, z + k);
                        blockPathType = this.m_264405_(level, pos, blockPathType);
                        nodeTypeEnum.add(blockPathType);
                        if (i == 0 && j == 0 && k == 0) {
                            nodeType = blockPathType;
                            continue;
                        }
                        if (i == 0 && k == 0) continue;
                        blockPathType = this.m_8086_(level, x - i, y + j, z - k);
                        blockPathType = this.m_264405_(level, pos, blockPathType);
                        nodeTypeEnum.add(blockPathType);
                    }
                }
            }
            return nodeType;
        }
    }
}

