/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.entity.ai;

import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.Prehistoric;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongList;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public abstract class CacheMoveToBlockGoal
extends Goal {
    public static final int STUCK_DISTANCE = 2;
    protected static final int CLEAR_TICKS = 400;
    private static final int GIVE_UP_TICKS = 1200;
    private static final int STAY_TICKS = 1200;
    private static final int INTERVAL_TICKS = 160;
    public final double speedModifier;
    protected final Prehistoric entity;
    protected final int searchRange;
    protected final LongList avoidCache = new LongArrayList();
    private final int verticalSearchRange;
    protected int nextStartTick;
    protected int tryTicks;
    protected int clearTicks;
    protected int stuckTicks;
    protected BlockPos targetPos = BlockPos.f_121853_;
    protected Block targetBlock = Blocks.f_50016_;
    protected boolean reachedTarget;
    protected Path path;
    private BlockPos lastStuckPos;

    protected CacheMoveToBlockGoal(Prehistoric entity, double speedModifier, int searchRange) {
        this(entity, speedModifier, searchRange, 1);
    }

    protected CacheMoveToBlockGoal(Prehistoric entity, double speedModifier, int searchRange, int verticalSearchRange) {
        this.entity = entity;
        this.speedModifier = speedModifier;
        this.searchRange = searchRange;
        this.verticalSearchRange = verticalSearchRange;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP));
    }

    public boolean m_8036_() {
        if (this.clearTicks > 0) {
            --this.clearTicks;
            if (this.clearTicks == 0) {
                this.avoidCache.clear();
            }
        }
        if (this.nextStartTick > 0) {
            --this.nextStartTick;
            return false;
        }
        if (!this.findNearestBlock()) {
            this.nextStartTick = 40;
            return false;
        }
        return this.createPath();
    }

    protected int nextStartTick() {
        return CacheMoveToBlockGoal.m_186073_((int)(160 + this.entity.m_217043_().m_188503_(160)));
    }

    public boolean m_8045_() {
        return this.tryTicks >= -1200 && this.tryTicks < 1200 && this.isValidTarget((LevelReader)this.entity.m_9236_(), this.targetPos);
    }

    public void m_8056_() {
        this.moveMobToBlock();
        this.tryTicks = 0;
        this.stuckTicks = 0;
        this.lastStuckPos = null;
    }

    public void m_8041_() {
        this.nextStartTick = this.nextStartTick();
    }

    protected boolean createPath() {
        this.path = this.entity.m_21573_().m_148218_(this.getMoveToTarget(), 1, 32);
        if (this.path == null || this.path.m_77395_() == null) {
            return false;
        }
        if (this.path.m_77398_() < 16 && (double)this.path.m_77395_().m_164697_(this.getMoveToTarget()) > this.acceptedDistance()) {
            this.avoidCache.add(this.getMoveToTarget().m_121878_());
            return false;
        }
        return true;
    }

    protected double calculateSpeedModifier() {
        return this.speedModifier;
    }

    protected void moveMobToBlock() {
        this.entity.m_21573_().m_26536_(this.path, this.calculateSpeedModifier());
    }

    public double acceptedDistance() {
        if (this.entity.getEntityHitboxData().hasCustomParts() && this.entity.getEntityHitboxData().getHeadRadius() != 0.0f) {
            return (double)(this.entity.getEntityHitboxData().getHeadRadius() * this.entity.m_6134_()) + 0.7;
        }
        return (double)(this.entity.m_20205_() / 2.0f) + 1.5;
    }

    protected BlockPos getMoveToTarget() {
        return this.targetPos;
    }

    public boolean m_183429_() {
        return true;
    }

    protected int getStuckPatience() {
        return 150;
    }

    public void m_8037_() {
        BlockPos blockPos = this.getMoveToTarget();
        if (this.checkReachedTarget()) {
            this.reachedTarget = true;
            this.entity.m_21573_().m_26573_();
            --this.tryTicks;
        } else if (this.stuckTicks > this.getStuckPatience()) {
            this.avoidCache.add(blockPos.m_121878_());
            this.tryTicks = 1200;
        } else {
            this.reachedTarget = false;
            ++this.tryTicks;
            if (this.shouldRecalculatePath()) {
                if (!this.createPath()) {
                    return;
                }
                this.moveMobToBlock();
            }
        }
        if (!this.isReachedTarget() && this.entity.m_21573_().m_26571_() || this.entity.m_21573_().m_26577_()) {
            if (this.lastStuckPos != null && !this.lastStuckPos.m_203195_((Position)this.entity.m_20182_(), 2.0)) {
                this.stuckTicks = 0;
            }
            ++this.stuckTicks;
            this.lastStuckPos = this.entity.m_20183_();
        }
    }

    public boolean shouldRecalculatePath() {
        return this.tryTicks % 40 == 0;
    }

    protected boolean checkReachedTarget() {
        double horizontal = Vec3.m_82539_((Vec3i)this.targetPos).m_82546_(this.entity.m_20182_()).m_165925_();
        double vertical = Mth.m_144952_((double)((double)this.targetPos.m_123342_() - this.entity.m_20186_()));
        return horizontal < Mth.m_144952_((double)this.acceptedDistance()) && vertical < Mth.m_144952_((double)((double)this.entity.m_20206_() + 0.1));
    }

    protected boolean isReachedTarget() {
        return this.reachedTarget;
    }

    protected boolean findNearestBlock() {
        BlockPos pos = this.entity.m_20183_();
        AABB searchArea = new AABB((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()).m_82377_((double)this.searchRange, (double)this.verticalSearchRange, (double)this.searchRange);
        Optional<BlockPos> target = BlockPos.m_121921_((AABB)searchArea).map(BlockPos::m_7949_).filter(pos1 -> this.isValidTarget((LevelReader)this.entity.m_9236_(), (BlockPos)pos1)).min(Comparator.comparingInt(value -> value.m_123333_((Vec3i)pos)));
        if (target.isPresent()) {
            this.setTargetPos(target.get());
            return true;
        }
        this.clearTicks = !this.avoidCache.isEmpty() ? 400 : 0;
        return false;
    }

    protected boolean isValidTarget(LevelReader level, BlockPos pos) {
        return !this.avoidCache.contains(pos.m_121878_());
    }

    protected void setTargetPos(BlockPos targetPos) {
        this.targetPos = targetPos;
        this.targetBlock = this.entity.m_9236_().m_8055_(targetPos).m_60734_();
    }
}

