/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.entity;

import com.github.teamfossilsarcheology.fossil.entity.ModEntities;
import com.github.teamfossilsarcheology.fossil.item.JavelinItem;
import com.github.teamfossilsarcheology.fossil.item.ModItems;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class Javelin
extends AbstractArrow {
    private static final EntityDataAccessor<Integer> TIER_ID = SynchedEntityData.m_135353_(Javelin.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> ANCIENT = SynchedEntityData.m_135353_(Javelin.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int itemDamage;

    public Javelin(EntityType<Javelin> type, Level level) {
        super(type, level);
    }

    public Javelin(Level level, LivingEntity shooter, Tier tier, boolean ancient, int itemDamage) {
        super((EntityType)ModEntities.JAVELIN.get(), shooter, level);
        this.itemDamage = itemDamage;
        if (tier instanceof Tiers) {
            Tiers tiers = (Tiers)tier;
            this.setTier(tiers);
        }
        this.f_19804_.m_135381_(ANCIENT, (Object)ancient);
        this.m_36767_((byte)16);
        this.m_36781_(Javelin.getDamage(tier, ancient));
    }

    private static double getDamage(Tier tier, boolean ancient) {
        if (ancient) {
            return 5.0;
        }
        if (tier instanceof Tiers) {
            Tiers tiers = (Tiers)tier;
            switch (tiers) {
                case WOOD: {
                    return 2.0;
                }
                case STONE: {
                    return 2.5;
                }
                case GOLD: {
                    return 3.5;
                }
                case IRON: {
                    return 3.0;
                }
                case DIAMOND: {
                    return 4.0;
                }
            }
        }
        return 2.0;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ANCIENT, (Object)false);
        this.f_19804_.m_135372_(TIER_ID, (Object)0);
    }

    protected void m_8060_(BlockHitResult result) {
        super.m_8060_(result);
        this.m_36767_((byte)16);
        if (this.m_9236_() instanceof ServerLevel && this.isAncient() && this.f_19796_.m_188503_(100) < 30) {
            LightningBolt lightningBolt = (LightningBolt)EntityType.f_20465_.m_20615_(this.m_9236_());
            lightningBolt.m_20219_(Vec3.m_82539_((Vec3i)this.m_20183_()));
            lightningBolt.m_20879_(this.m_19749_() instanceof ServerPlayer ? (ServerPlayer)this.m_19749_() : null);
            this.m_9236_().m_7967_((Entity)lightningBolt);
        }
    }

    protected void m_6901_() {
    }

    public Tier getTier() {
        if (!this.isAncient()) {
            return Tiers.values()[(Integer)this.f_19804_.m_135370_(TIER_ID)];
        }
        return Tiers.WOOD;
    }

    public void setTier(Tiers tier) {
        this.f_19804_.m_135381_(TIER_ID, (Object)tier.ordinal());
    }

    public boolean isAncient() {
        return (Boolean)this.f_19804_.m_135370_(ANCIENT);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("ancient", this.isAncient());
        Tier tier = this.getTier();
        if (tier instanceof Tiers) {
            Tiers tiers = (Tiers)tier;
            compound.m_128405_("Tier", tiers.ordinal());
        }
        compound.m_128405_("Damage", this.itemDamage);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.f_19804_.m_135381_(ANCIENT, (Object)compound.m_128471_("ancient"));
        if (!this.isAncient()) {
            this.setTier(Tiers.values()[compound.m_128451_("Tier")]);
        }
        this.itemDamage = compound.m_128451_("Damage");
    }

    @NotNull
    protected ItemStack m_7941_() {
        if (this.isAncient()) {
            ItemStack stack = new ItemStack((ItemLike)ModItems.ANCIENT_JAVELIN.get());
            stack.m_41721_(((JavelinItem)((Object)ModItems.ANCIENT_JAVELIN.get())).m_41462_() - this.itemDamage);
            return stack;
        }
        Tier stack = this.getTier();
        if (stack instanceof Tiers) {
            Tiers tiers = (Tiers)stack;
            switch (tiers) {
                case WOOD: {
                    stack = new ItemStack((ItemLike)ModItems.WOODEN_JAVELIN.get());
                    stack.m_41721_(((JavelinItem)((Object)ModItems.WOODEN_JAVELIN.get())).m_41462_() - this.itemDamage);
                    return stack;
                }
                case STONE: {
                    stack = new ItemStack((ItemLike)ModItems.STONE_JAVELIN.get());
                    stack.m_41721_(((JavelinItem)((Object)ModItems.STONE_JAVELIN.get())).m_41462_() - this.itemDamage);
                    return stack;
                }
                case GOLD: {
                    stack = new ItemStack((ItemLike)ModItems.GOLD_JAVELIN.get());
                    stack.m_41721_(((JavelinItem)((Object)ModItems.GOLD_JAVELIN.get())).m_41462_() - this.itemDamage);
                    return stack;
                }
                case IRON: {
                    stack = new ItemStack((ItemLike)ModItems.IRON_JAVELIN.get());
                    stack.m_41721_(((JavelinItem)((Object)ModItems.IRON_JAVELIN.get())).m_41462_() - this.itemDamage);
                    return stack;
                }
                case DIAMOND: {
                    stack = new ItemStack((ItemLike)ModItems.DIAMOND_JAVELIN.get());
                    stack.m_41721_(((JavelinItem)((Object)ModItems.DIAMOND_JAVELIN.get())).m_41462_() - this.itemDamage);
                    return stack;
                }
            }
        }
        return ItemStack.f_41583_;
    }
}

