/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.config.forge;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.github.teamfossilsarcheology.fossil.FossilMod;
import com.github.teamfossilsarcheology.fossil.config.forge.ForgeConfig;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;

public class ForgeConfigFix {
    private static final Map<Integer, Set<Update<?>>> FIXES = new HashMap();

    private static <T> void add(int version, ForgeConfigSpec.ConfigValue<T> spec, T newValue, Predicate<T> predicate) {
        FIXES.computeIfAbsent(version, k -> new HashSet()).add(new Update<T>(spec.getPath(), newValue, predicate));
    }

    private static <T> void add(int version, ForgeConfigSpec.ConfigValue<T> spec, T newValue) {
        ForgeConfigFix.add(version, spec, newValue, t -> true);
    }

    public static void fixConfig(ModConfigEvent.Loading event) {
        Integer v;
        CommentedConfig config;
        Object version;
        if (event.getConfig().getModId().equals("fossil") && event.getConfig().getType() == ModConfig.Type.COMMON && (version = (config = event.getConfig().getConfigData()).get(ForgeConfig.VERSION.getPath())) instanceof Integer && (v = (Integer)version) < 1) {
            FossilMod.LOGGER.info("Config version is outdated: {} -> {}", (Object)v, (Object)1);
            for (Update update : (Set)FIXES.getOrDefault(1, new HashSet())) {
                Object object = config.get(update.path);
                if (object == null || !update.canReplace(object)) continue;
                FossilMod.LOGGER.info("Updating {}: {} -> {}", update.path, object, update.newValue);
                config.set(update.path, update.newValue);
            }
            config.set(ForgeConfig.VERSION.getPath(), (Object)1);
        }
    }

    private record Update<T>(List<String> path, T newValue, Predicate<T> predicate) {
        public boolean canReplace(Object oldValue) {
            return oldValue.getClass().isAssignableFrom(this.newValue.getClass()) && this.predicate.test(oldValue);
        }
    }
}

