/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.compat.jei;

import com.github.teamfossilsarcheology.fossil.FossilMod;
import com.github.teamfossilsarcheology.fossil.recipe.MultiOutputAndSlotsRecipe;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.Tesselator;
import it.unimi.dsi.fastutil.doubles.DoubleComparators;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public abstract class MultiOutputCategory<T extends MultiOutputAndSlotsRecipe>
implements IRecipeCategory<T> {
    private static final ResourceLocation TEXTURE = FossilMod.location("textures/gui/multi_output.png");
    private static final DecimalFormat FORMAT = new DecimalFormat("#.#'%'");
    private final IDrawable background;
    private final IDrawable icon;
    private final LoadingCache<T, List<SlotItem>> probabilities = CacheBuilder.newBuilder().build(new CacheLoader<T, List<SlotItem>>(){
        private static final int COLUMNS = 5;
        private static final int ROWS = 3;

        @NotNull
        public List<SlotItem> load(@NotNull T recipe) {
            Iterator iterator = ((MultiOutputAndSlotsRecipe)recipe).getWeightedOutputs().entrySet().iterator();
            ArrayList<WeightedItem> sortedOutputs = new ArrayList<WeightedItem>();
            if (iterator.hasNext()) {
                double total = (Double)((MultiOutputAndSlotsRecipe)recipe).getWeightedOutputs().lastKey();
                Map.Entry entry = iterator.next();
                double previous = (Double)entry.getKey();
                sortedOutputs.add(new WeightedItem(previous / total * 100.0, (ItemStack)entry.getValue()));
                while (iterator.hasNext()) {
                    entry = iterator.next();
                    sortedOutputs.add(new WeightedItem(((Double)entry.getKey() - previous) / total * 100.0, (ItemStack)entry.getValue()));
                    previous = (Double)entry.getKey();
                }
            }
            sortedOutputs.sort((o1, o2) -> DoubleComparators.OPPOSITE_COMPARATOR.compare(o1.probability, o2.probability));
            int numPerPage = 15;
            Map<Integer, List<WeightedItem>> groupedOutputs = sortedOutputs.stream().collect(Collectors.groupingBy(weightedItem -> sortedOutputs.indexOf(weightedItem) % numPerPage));
            ArrayList<SlotItem> newOutputs = new ArrayList<SlotItem>();
            for (int i = 0; i < groupedOutputs.size(); ++i) {
                int x = i % 5;
                int y = i / 5;
                newOutputs.add(new SlotItem(groupedOutputs.get(i), 8 + x * 30, 21 + y * 25));
            }
            return newOutputs;
        }
    });

    protected MultiOutputCategory(IGuiHelper guiHelper, ItemLike iconItem) {
        this.background = guiHelper.createDrawable(TEXTURE, 0, 0, 152, 106);
        this.icon = guiHelper.createDrawableItemStack(new ItemStack(iconItem));
    }

    public void draw(@NotNull T recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        Optional currentStack;
        List slotItems = (List)this.probabilities.getUnchecked(recipe);
        List slots = recipeSlotsView.getSlotViews(RecipeIngredientRole.OUTPUT);
        block0: for (int i = 0; i < slots.size() && !(currentStack = ((IRecipeSlotView)slots.get(i)).getDisplayedItemStack()).isEmpty(); ++i) {
            for (WeightedItem item : ((SlotItem)slotItems.get((int)i)).items) {
                if (!ItemStack.m_41656_((ItemStack)((ItemStack)currentStack.get()), (ItemStack)item.stack)) continue;
                this.renderProbability(guiGraphics, Minecraft.m_91087_().f_91062_, item.probability, ((SlotItem)slotItems.get((int)i)).x, ((SlotItem)slotItems.get((int)i)).y);
                continue block0;
            }
        }
    }

    private void renderProbability(GuiGraphics guiGraphics, Font fr, double percentage, int xPosition, int yPosition) {
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_85837_(0.0, 0.0, 300.0);
        String string = FORMAT.format(percentage);
        MultiBufferSource.BufferSource bufferSource = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        float xOffset = Math.min(11.0f, (float)fr.m_92895_(string) / 2.0f);
        fr.m_271703_(string, (float)(xPosition + 8) - xOffset, (float)(yPosition + 16 + 1), 0xFFFFFF, true, guiGraphics.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        bufferSource.m_109911_();
        guiGraphics.m_280168_().m_85849_();
    }

    public void setRecipe(IRecipeLayoutBuilder builder, T recipe, IFocusGroup focuses) {
        int centerX = 75;
        builder.addSlot(RecipeIngredientRole.INPUT, centerX - 7, 2).addIngredients(((MultiOutputAndSlotsRecipe)recipe).getInput());
        List outputs = (List)this.probabilities.getUnchecked(recipe);
        for (SlotItem output : outputs) {
            builder.addSlot(RecipeIngredientRole.OUTPUT, output.x, output.y + 1).addIngredients(Ingredient.m_43921_(output.items.stream().map(weightedItem -> weightedItem.stack)));
        }
    }

    @NotNull
    public IDrawable getBackground() {
        return this.background;
    }

    @NotNull
    public IDrawable getIcon() {
        return this.icon;
    }

    public record SlotItem(List<WeightedItem> items, int x, int y) {
    }

    public record WeightedItem(double probability, ItemStack stack) {
    }
}

