/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.client.gui.debug.navigation;

import com.github.teamfossilsarcheology.fossil.client.gui.debug.navigation.PathingRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public class DebugMoveControl {
    public Operation operation = Operation.WAIT;
    protected double wantedX;
    protected double wantedY;
    protected double wantedZ;
    public double speedModifier = 1.0;
    private final Player player;
    public Vec3 move = Vec3.f_82478_;
    public float zza;
    public float yRot;
    public float speed;
    public boolean jump;

    public DebugMoveControl(Player player) {
        this.player = player;
    }

    public void setWantedPosition(double x, double y, double z, double speed) {
        this.wantedX = x;
        this.wantedY = y;
        this.wantedZ = z;
        this.speedModifier = speed;
        if (this.operation != Operation.JUMPING) {
            this.operation = Operation.MOVE_TO;
        }
    }

    public void tick() {
        if (this.operation == Operation.MOVE_TO) {
            double z;
            double y;
            this.operation = Operation.WAIT;
            double x = this.wantedX - this.player.m_20185_();
            double dist = x * x + (y = this.wantedY - this.player.m_20186_()) * y + (z = this.wantedZ - this.player.m_20189_()) * z;
            if (dist < 2.500000277905201E-7) {
                this.zza = 0.0f;
                return;
            }
            float newYRot = (float)(Mth.m_14136_((double)z, (double)x) * 57.2957763671875) - 90.0f;
            float turn = Mth.m_14036_((float)(90.0f - PathingRenderer.getBbWidth() * 20.0f), (float)10.0f, (float)90.0f);
            this.yRot = this.rotlerp(this.player.m_146908_(), newYRot, turn);
            this.zza = this.speed = (float)(this.speedModifier * this.player.m_21133_(Attributes.f_22279_));
            BlockPos blockPos = this.player.m_20183_();
            BlockState blockState = this.player.m_9236_().m_8055_(blockPos);
            VoxelShape voxelShape = blockState.m_60812_((BlockGetter)this.player.m_9236_(), blockPos);
            if (y > (double)this.player.m_274421_() && x * x + z * z < (double)Math.max(1.0f, Mth.m_14207_((float)PathingRenderer.getBbWidth())) || !voxelShape.m_83281_() && this.player.m_20186_() < voxelShape.m_83297_(Direction.Axis.Y) + (double)blockPos.m_123342_() && !blockState.m_204336_(BlockTags.f_13103_) && !blockState.m_204336_(BlockTags.f_13039_)) {
                this.operation = Operation.JUMPING;
            }
        } else if (this.operation == Operation.JUMPING) {
            this.zza = this.speed = (float)(this.speedModifier * this.player.m_21133_(Attributes.f_22279_));
            if (this.player.m_20096_()) {
                this.operation = Operation.WAIT;
            }
        } else {
            this.zza = 0.0f;
        }
        this.move = DebugMoveControl.getInputVector(new Vec3(0.0, 0.0, (double)this.zza), this.speed, this.yRot);
    }

    private static Vec3 getInputVector(Vec3 relative, float motionScaler, float facing) {
        double d = relative.m_82556_();
        if (d < 1.0E-7) {
            return Vec3.f_82478_;
        }
        Vec3 vec3 = (d > 1.0 ? relative.m_82541_() : relative).m_82490_((double)motionScaler);
        float f = Mth.m_14031_((float)(facing * ((float)Math.PI / 180)));
        float g = Mth.m_14089_((float)(facing * ((float)Math.PI / 180)));
        return new Vec3(vec3.f_82479_ * (double)g - vec3.f_82481_ * (double)f, vec3.f_82480_, vec3.f_82481_ * (double)g + vec3.f_82479_ * (double)f);
    }

    protected float rotlerp(float sourceAngle, float targetAngle, float maximumChange) {
        float f;
        float f2 = Mth.m_14177_((float)(targetAngle - sourceAngle));
        if (f2 > maximumChange) {
            f2 = maximumChange;
        }
        if (f2 < -maximumChange) {
            f2 = -maximumChange;
        }
        float g = sourceAngle + f2;
        if (f < 0.0f) {
            g += 360.0f;
        } else if (g > 360.0f) {
            g -= 360.0f;
        }
        return g;
    }

    public static enum Operation {
        WAIT,
        MOVE_TO,
        STRAFE,
        JUMPING;

    }
}

