/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.client.gui.debug.navigation;

import com.github.teamfossilsarcheology.fossil.client.gui.debug.navigation.PathingDebug;
import com.github.teamfossilsarcheology.fossil.client.gui.debug.navigation.PathingRenderer;
import com.github.teamfossilsarcheology.fossil.client.gui.debug.navigation.PlayerNodeEvaluator;
import com.google.common.collect.Maps;
import java.util.EnumMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.PathNavigationRegion;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Target;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AmphNodeEvaluator
extends PlayerNodeEvaluator {
    @Override
    public void prepare(PathNavigationRegion level, Player p) {
        super.prepare(level, p);
        PathingDebug.setPathfindingMalus(BlockPathTypes.WATER, 0.0f);
    }

    @Override
    public Node getStart() {
        AABB aABB = PathingRenderer.getBigHitbox().m_82383_(Vec3.m_82539_((Vec3i)PathingDebug.pos1));
        return super.getNode(Mth.m_14107_((double)aABB.f_82288_), Mth.m_14107_((double)(aABB.f_82289_ + 0.5)), Mth.m_14107_((double)aABB.f_82290_));
    }

    @Override
    @NotNull
    public Target getGoal(double x, double y, double z) {
        return new Target(super.getNode(Mth.m_14107_((double)x), Mth.m_14107_((double)(y + 0.5)), Mth.m_14107_((double)z)));
    }

    @Override
    @Nullable
    protected Node getNode(int x, int y, int z) {
        if (this.isAmphibious()) {
            return super.getNode(x, y, z);
        }
        Node node = null;
        BlockPathTypes blockPathTypes = this.getCachedBlockType(this.player, x, y, z);
        if (blockPathTypes == BlockPathTypes.WATER) {
            float f;
            float f2 = PathingDebug.getPathfindingMalus(blockPathTypes);
            if (f >= 0.0f) {
                node = super.getNode(x, y, z);
                node.f_77282_ = blockPathTypes;
                node.f_77281_ = Math.max(node.f_77281_, f2);
                if (this.level.m_6425_(new BlockPos(x, y, z)).m_76178_()) {
                    node.f_77281_ += 8.0f;
                }
            }
        }
        return node;
    }

    @Override
    public int getNeighbors(Node[] nodes, Node node) {
        int i;
        int x = node.f_77271_;
        int y = node.f_77272_;
        int z = node.f_77273_;
        BlockPathTypes type = this.getCachedBlockType(this.player, x, y, z);
        if (type == BlockPathTypes.WATER || type == BlockPathTypes.WATER_BORDER) {
            i = 0;
            EnumMap map = Maps.newEnumMap(Direction.class);
            for (Direction direction : Direction.values()) {
                Node faceNode = this.getNode(x + direction.m_122429_(), y + direction.m_122430_(), z + direction.m_122431_());
                map.put(direction, faceNode);
                if (!this.isNodeValid(faceNode)) continue;
                nodes[i++] = faceNode;
            }
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                Direction direction2 = direction.m_122427_();
                Node diagonalNode = this.getNode(x + direction.m_122429_() + direction2.m_122429_(), y, z + direction.m_122431_() + direction2.m_122431_());
                if (!this.isDiagonalNodeValid(diagonalNode, (Node)map.get(direction), (Node)map.get(direction2))) continue;
                nodes[i++] = diagonalNode;
            }
        } else {
            i = super.getNeighbors(nodes, node);
            BlockPathTypes typeAbove = this.getCachedBlockType(this.player, x, y + 1, z);
            int j = PathingDebug.getPathfindingMalus(type) > 0.0f && typeAbove != BlockPathTypes.STICKY_HONEY ? Mth.m_14143_((float)Math.max(1, 1)) : 0;
            double floorLevel = this.getFloorLevel(new BlockPos(x, y, z));
            Node nodeAbove = this.findAcceptedNode(x, y + 1, z, Math.max(0, j - 1), floorLevel, Direction.UP, type);
            Node nodeBelow = this.findAcceptedNode(x, y - 1, z, j, floorLevel, Direction.DOWN, type);
            if (this.isNeighborValid(nodeAbove, node)) {
                nodes[i++] = nodeAbove;
            }
            if (this.isNeighborValid(nodeBelow, node) && type != BlockPathTypes.TRAPDOOR) {
                nodes[i++] = nodeBelow;
            }
        }
        return i;
    }

    protected boolean isNodeValid(@Nullable Node node) {
        return node != null && !node.f_77279_ && this.getBlockPathType((BlockGetter)this.level, node.f_77271_, node.f_77272_, node.f_77273_) != BlockPathTypes.BLOCKED;
    }

    protected boolean isDiagonalNodeValid(@Nullable Node diagonal, @Nullable Node node1, @Nullable Node node2) {
        return this.isNodeValid(diagonal) && node1 != null && node1.f_77281_ >= 0.0f && node2 != null && node2.f_77281_ >= 0.0f;
    }

    protected boolean isVerticalDiagonalNodeValid(@Nullable Node diagonal, @Nullable Node node1, @Nullable Node node2) {
        return this.isNodeValid(diagonal) && node1 != null && node1.f_77281_ >= 0.0f && node2 != null && node2.f_77281_ >= 0.0f;
    }

    @Override
    protected boolean isAmphibious() {
        return true;
    }

    @Override
    @NotNull
    public BlockPathTypes getBlockPathType(BlockGetter level, int x, int y, int z) {
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        BlockPathTypes type = AmphNodeEvaluator.getBlockPathTypeRaw(level, (BlockPos)mutableBlockPos.m_122178_(x, y, z));
        if (type == BlockPathTypes.WATER) {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                BlockPathTypes neighbourType = AmphNodeEvaluator.getBlockPathTypeRaw(level, (BlockPos)mutableBlockPos.m_122178_(x, y, z).m_122173_(direction));
                if (neighbourType != BlockPathTypes.BLOCKED) continue;
                return BlockPathTypes.WATER_BORDER;
            }
            return BlockPathTypes.WATER;
        }
        if (!this.isAmphibious()) {
            return BlockPathTypes.BLOCKED;
        }
        return AmphNodeEvaluator.getBlockPathTypeStatic(level, mutableBlockPos);
    }
}

