/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.client.gui.debug;

import com.github.teamfossilsarcheology.fossil.client.gui.debug.AbstractAnimationList;
import com.github.teamfossilsarcheology.fossil.client.gui.debug.DebugScreen;
import com.github.teamfossilsarcheology.fossil.client.gui.debug.DebugSlider;
import com.github.teamfossilsarcheology.fossil.client.gui.debug.DebugTab;
import com.github.teamfossilsarcheology.fossil.client.gui.debug.instruction.EntityList;
import com.github.teamfossilsarcheology.fossil.client.gui.debug.instruction.Instruction;
import com.github.teamfossilsarcheology.fossil.client.gui.debug.instruction.InstructionsList;
import com.github.teamfossilsarcheology.fossil.entity.animation.AnimationInfo;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.Prehistoric;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricFlying;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricLeaping;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.swimming.Meganeura;
import com.github.teamfossilsarcheology.fossil.network.MessageHandler;
import com.github.teamfossilsarcheology.fossil.network.debug.InstructionMessage;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.phys.BlockHitResult;

public class InstructionTab
extends DebugTab<Prehistoric> {
    public static final Map<UUID, Pair> INSTRUCTIONS = new Object2ObjectOpenHashMap();
    private InstructionsList instructions;
    private AbstractAnimationList animations;
    private EntityList attackEntities;
    private EntityList leapEntities;
    public static Entity entityListHighlight;
    public static Entity highlightInstructionEntity;
    public static Instruction highlightInstruction;
    public static Instruction.Type positionMode;
    public static int teleportRotation;
    public static Prehistoric activeEntity;

    protected InstructionTab(DebugScreen debugScreen, Prehistoric entity) {
        super(debugScreen, entity);
    }

    @Override
    protected void init(int width, int height) {
        super.init(width, height);
        this.instructions = this.addWidget(new InstructionsList(INSTRUCTIONS.computeIfAbsent(((Prehistoric)this.entity).m_20148_(), id -> new Pair(((Prehistoric)this.entity).m_19879_(), new ArrayList<Instruction>())), this.minecraft));
        this.addWidget(Button.m_253074_((Component)Component.m_237113_((String)"Start"), button -> {
            MessageHandler.DEBUG_CHANNEL.sendToServer((Object)new InstructionMessage(((Prehistoric)this.entity).m_19879_(), true, InstructionTab.INSTRUCTIONS.get((Object)((Prehistoric)this.entity).m_20148_()).instructions));
            this.debugScreen.m_7379_();
            this.onClose();
        }).m_252987_(5, 340, 50, 20).m_253136_());
        this.addWidget(Button.m_253074_((Component)Component.m_237113_((String)"Stop"), button -> MessageHandler.DEBUG_CHANNEL.sendToServer((Object)new InstructionMessage(((Prehistoric)this.entity).m_19879_(), true, List.of()))).m_252987_(5, 365, 50, 20).m_253136_());
        this.addWidget(Button.m_253074_((Component)Component.m_237113_((String)"Stop All"), button -> {
            for (Map.Entry<UUID, Pair> entry : INSTRUCTIONS.entrySet()) {
                MessageHandler.DEBUG_CHANNEL.sendToServer((Object)new InstructionMessage(entry.getValue().id, true, List.of()));
            }
            this.debugScreen.m_7379_();
            this.onClose();
        }).m_252987_(60, 365, 70, 20).m_257505_(Tooltip.m_257550_((Component)Component.m_237113_((String)"Stops Instruction for all mobs"))).m_253136_());
        this.addWidget(Button.m_253074_((Component)Component.m_237113_((String)"Start All"), button -> {
            for (Map.Entry<UUID, Pair> entry : INSTRUCTIONS.entrySet()) {
                MessageHandler.DEBUG_CHANNEL.sendToServer((Object)new InstructionMessage(entry.getValue().id, true, entry.getValue().instructions));
            }
            this.debugScreen.m_7379_();
            this.onClose();
        }).m_252987_(60, 340, 70, 20).m_257505_(Tooltip.m_257550_((Component)Component.m_237113_((String)"Starts Instruction for all mobs"))).m_253136_());
        this.addWidget(Button.m_253074_((Component)Component.m_237113_((String)"Debug"), button -> MessageHandler.DEBUG_CHANNEL.sendToServer((Object)new InstructionMessage(((Prehistoric)this.entity).m_19879_(), true, InstructionTab.INSTRUCTIONS.get((Object)((Prehistoric)this.entity).m_20148_()).instructions))).m_252987_(135, 340, 50, 20).m_257505_(Tooltip.m_257550_((Component)Component.m_237113_((String)"Starts Instruction without closing the debug menu"))).m_253136_());
        this.addWidget(Button.m_253074_((Component)Component.m_237113_((String)"Walk Builder"), button -> {
            positionMode = Instruction.Type.MOVE_TO;
            this.debugScreen.m_7379_();
        }).m_252987_(220, 5, 100, 20).m_257505_(Tooltip.m_257550_((Component)Component.m_237113_((String)"Left click to place, Right click to cancel"))).m_253136_());
        this.addWidget(Button.m_253074_((Component)Component.m_237113_((String)"Teleport Builder"), button -> {
            positionMode = Instruction.Type.TELEPORT_TO;
            teleportRotation = 0;
            this.debugScreen.m_7379_();
        }).m_252987_(220, 30, 100, 20).m_257505_(Tooltip.m_257550_((Component)Component.m_237113_((String)"Left click to place, Right click to cancel, Mousewheel to rotate"))).m_253136_());
        if (this.entity instanceof Meganeura) {
            this.addWidget(Button.m_253074_((Component)Component.m_237113_((String)"Attach Builder"), button -> {
                positionMode = Instruction.Type.ATTACH_TO;
                this.debugScreen.m_7379_();
            }).m_252987_(220, 55, 100, 20).m_253136_());
        }
        List list = ((Prehistoric)this.entity).m_9236_().m_45971_(LivingEntity.class, TargetingConditions.m_148353_().m_26883_(30.0).m_148355_(), (LivingEntity)this.entity, ((Prehistoric)this.entity).m_20191_().m_82400_(30.0));
        this.leapEntities = new EntityList(width - 315, 200, 300, list, this.minecraft, entity1 -> {
            Instruction.LeapAttack instruction = new Instruction.LeapAttack(entity1.m_19879_());
            this.instructions.addInstruction(instruction);
            InstructionTab.INSTRUCTIONS.get((Object)((Prehistoric)this.entity).m_20148_()).instructions.add(instruction);
        });
        if (this.entity instanceof PrehistoricFlying) {
            this.addWidget(Button.m_253074_((Component)Component.m_237113_((String)"Fly Builder"), button -> {
                positionMode = Instruction.Type.FLY_TO;
                this.debugScreen.m_7379_();
            }).m_252987_(220, 55, 100, 20).m_253136_());
            this.addWidget(Button.m_253074_((Component)Component.m_237113_((String)"Land Builder"), button -> {
                positionMode = Instruction.Type.FLY_LAND;
                this.debugScreen.m_7379_();
            }).m_252987_(220, 80, 100, 20).m_253136_());
        }
        if (this.entity instanceof PrehistoricLeaping) {
            this.addWidget(Button.m_253074_((Component)Component.m_237113_((String)"Leap Builder"), button -> {
                positionMode = Instruction.Type.LEAP_LAND;
                this.debugScreen.m_7379_();
            }).m_252987_(220, 55, 100, 20).m_253136_());
            this.addWidget(Button.m_253074_((Component)Component.m_237113_((String)"Open Leap"), button -> {
                this.closeLists();
                this.addWidget(this.leapEntities);
            }).m_252987_(width - 115, 5, 90, 20).m_257505_(Tooltip.m_257550_((Component)Component.m_237113_((String)"Won't save correctly when leaving the world"))).m_253136_());
        }
        this.attackEntities = new EntityList(width - 315, 200, 300, list, this.minecraft, entity1 -> {});
        List<String> controllers = ((Prehistoric)this.entity).getAnimatableInstanceCache().getManagerForId((long)((Prehistoric)this.entity).m_19879_()).getAnimationControllers().keySet().stream().toList();
        this.animations = new AnimationList(width - 315, ((Prehistoric)this.entity).getAllAnimations(), controllers, this.minecraft, animationObject -> {
            Instruction.PlayAnim instruction = new Instruction.PlayAnim(animationObject.name(), animationObject.controller(), animationObject.loop(), animationObject.transitionLength());
            this.instructions.addInstruction(instruction);
            InstructionTab.INSTRUCTIONS.get((Object)((Prehistoric)this.entity).m_20148_()).instructions.add(instruction);
        });
        this.addWidget(Button.m_253074_((Component)Component.m_237113_((String)"Open Animations"), button -> {
            this.closeLists();
            this.addWidget(this.animations);
        }).m_252987_(width - 215, 5, 90, 20).m_257505_(Tooltip.m_257550_((Component)Component.m_237113_((String)"Stops and plays animation x times or for x seconds"))).m_253136_());
        EditBox zPosInput = this.addWidget(new EditBox(this.minecraft.f_91062_, 325, 30, 30, 20, (Component)Component.m_237113_((String)"")));
        zPosInput.m_94144_(new DecimalFormat("##", DecimalFormatSymbols.getInstance(Locale.US)).format(5L));
        this.addWidget(Button.m_253074_((Component)Component.m_237113_((String)"Add Idle"), button -> {
            Instruction.Idle instruction = new Instruction.Idle(Integer.parseInt(zPosInput.m_94155_()) * 20);
            this.instructions.addInstruction(instruction);
            InstructionTab.INSTRUCTIONS.get((Object)((Prehistoric)this.entity).m_20148_()).instructions.add(instruction);
        }).m_252987_(325, 5, 70, 20).m_253136_());
        this.addWidget(Button.m_253074_((Component)Component.m_237113_((String)"Add Sleep"), button -> {
            Instruction.Sleep instruction = new Instruction.Sleep(Integer.parseInt(zPosInput.m_94155_()) * 20);
            this.instructions.addInstruction(instruction);
            InstructionTab.INSTRUCTIONS.get((Object)((Prehistoric)this.entity).m_20148_()).instructions.add(instruction);
        }).m_252987_(400, 5, 70, 20).m_253136_());
    }

    private void closeLists() {
        this.listeners.remove((Object)this.leapEntities);
        this.renderables.remove((Object)this.leapEntities);
        this.listeners.remove((Object)this.animations);
        this.renderables.remove((Object)this.animations);
    }

    @Override
    protected void onOpen() {
        activeEntity = (Prehistoric)this.entity;
    }

    @Override
    protected void onClose() {
        activeEntity = null;
    }

    public static void addPosition(BlockHitResult hitResult) {
        if (activeEntity == null) {
            return;
        }
        BlockPos target = hitResult.m_82425_().m_121945_(hitResult.m_82434_());
        if (positionMode == Instruction.Type.MOVE_TO) {
            InstructionTab.INSTRUCTIONS.get((Object)InstructionTab.activeEntity.m_20148_()).instructions.add(new Instruction.MoveTo(target));
        } else if (positionMode == Instruction.Type.FLY_LAND) {
            InstructionTab.INSTRUCTIONS.get((Object)InstructionTab.activeEntity.m_20148_()).instructions.add(new Instruction.FlyLand(target));
        } else if (positionMode == Instruction.Type.TELEPORT_TO) {
            InstructionTab.INSTRUCTIONS.get((Object)InstructionTab.activeEntity.m_20148_()).instructions.add(new Instruction.TeleportTo(target, -teleportRotation + 180));
        } else if (positionMode == Instruction.Type.ATTACH_TO) {
            target = hitResult.m_82425_();
            InstructionTab.INSTRUCTIONS.get((Object)InstructionTab.activeEntity.m_20148_()).instructions.add(new Instruction.AttachTo(target, hitResult.m_82434_(), hitResult.m_82450_()));
        } else if (positionMode == Instruction.Type.LEAP_LAND) {
            InstructionTab.INSTRUCTIONS.get((Object)InstructionTab.activeEntity.m_20148_()).instructions.add(new Instruction.LeapLand(hitResult.m_82450_(), hitResult.m_82450_().m_82520_(0.0, 2.0, 0.0)));
        }
    }

    public static void addFlyPosition(BlockPos target) {
        if (positionMode == Instruction.Type.FLY_TO) {
            InstructionTab.INSTRUCTIONS.get((Object)InstructionTab.activeEntity.m_20148_()).instructions.add(new Instruction.FlyTo(target));
        }
    }

    public static boolean positionActive() {
        return positionMode != Instruction.Type.IDLE;
    }

    static {
        positionMode = Instruction.Type.IDLE;
    }

    public record Pair(int id, List<Instruction> instructions) {
    }

    private static class AnimationList
    extends AbstractAnimationList {
        public AnimationList(int x0, Map<String, ? extends AnimationInfo> animations, List<String> controllers, Minecraft minecraft, Consumer<AbstractAnimationList.AnimationObject> function) {
            super(x0, 300, 25, 60, animations, minecraft, function);
            int buttonX = x0 + this.rowWidth + 15;
            if (!controllers.isEmpty()) {
                this.currentControllerName = controllers.get(0);
                this.addWidget(CycleButton.m_168894_(Component::m_237113_).m_232502_(controllers).m_168948_((Object)this.currentControllerName).m_168936_(buttonX, this.f_93390_, 100, 20, (Component)Component.m_237113_((String)""), (cycleButton, controller) -> {
                    this.currentControllerName = controller;
                }));
            }
            this.addWidget(new DebugSlider(buttonX, this.f_93390_ + 25, 100, 20, (Component)Component.m_237113_((String)"Count: "), (Component)Component.m_237113_((String)""), 0.0, 20.0, this.transitionLength, 1.0, 3, true){

                @Override
                protected void m_5697_() {
                    transitionLength = (int)(this.stepSize * (double)Math.round(Mth.m_14139_((double)this.f_93577_, (double)this.minValue, (double)this.maxValue) / this.stepSize));
                }
            });
            this.addWidget(CycleButton.m_168916_((boolean)this.loop).m_168936_(buttonX, this.f_93390_ + 50, 100, 20, (Component)Component.m_237113_((String)"Time based"), (button, loop) -> {
                this.loop = loop;
            }));
        }
    }
}

