/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.capabilities.forge;

import com.github.teamfossilsarcheology.fossil.block.entity.CommonEnergyStorage;
import com.github.teamfossilsarcheology.fossil.config.FossilConfig;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.EntityInfo;
import com.github.teamfossilsarcheology.fossil.forge.capabilities.mammal.IMammalCap;
import com.github.teamfossilsarcheology.fossil.forge.capabilities.mammal.MammalCapProvider;
import com.github.teamfossilsarcheology.fossil.forge.capabilities.player.FirstHatchCapProvider;
import com.github.teamfossilsarcheology.fossil.forge.capabilities.player.IFirstHatchCap;
import com.github.teamfossilsarcheology.fossil.forge.energy.FAEnergyStorage;
import com.github.teamfossilsarcheology.fossil.network.MessageHandler;
import com.github.teamfossilsarcheology.fossil.network.S2CMammalCapMessage;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.Nullable;

public class ModCapabilitiesImpl {
    private static final ConcurrentMap<Animal, LazyOptional<IMammalCap>> cachedMammals = new ConcurrentHashMap<Animal, LazyOptional<IMammalCap>>();
    private static final ConcurrentMap<Player, LazyOptional<IFirstHatchCap>> cachedPlayers = new ConcurrentHashMap<Player, LazyOptional<IFirstHatchCap>>();

    public static Optional<IMammalCap> getMammalCap(Animal animal) {
        LazyOptional cap = (LazyOptional)cachedMammals.get(animal);
        if (cap == null) {
            cap = animal.getCapability(MammalCapProvider.MAMMAL_CAPABILITY);
            cachedMammals.put(animal, (LazyOptional<IMammalCap>)cap);
            cap.addListener(optional -> cachedMammals.remove(animal));
        }
        return cap.resolve();
    }

    public static Optional<IFirstHatchCap> getFirstHatchCap(Player player) {
        LazyOptional cap = (LazyOptional)cachedPlayers.get(player);
        if (cap == null) {
            cap = player.getCapability(FirstHatchCapProvider.FIRST_HATCH_CAPABILITY);
            cachedPlayers.put(player, (LazyOptional<IFirstHatchCap>)cap);
            cap.addListener(optional -> cachedPlayers.remove(player));
        }
        return cap.resolve();
    }

    public static boolean hasEmbryo(Animal animal) {
        return ModCapabilitiesImpl.getMammalCap(animal).map(iMammalCap -> iMammalCap.getEmbryo() != null).orElse(false);
    }

    public static int getEmbryoProgress(Animal animal) {
        return ModCapabilitiesImpl.getMammalCap(animal).map(IMammalCap::getEmbryoProgress).orElse(0);
    }

    public static EntityInfo getEmbryo(Animal animal) {
        return ModCapabilitiesImpl.getMammalCap(animal).map(IMammalCap::getEmbryo).orElse(null);
    }

    public static void setEmbryoProgress(Animal animal, int embryoProgress) {
        ModCapabilitiesImpl.getMammalCap(animal).ifPresent(iMammalCap -> iMammalCap.setEmbryoProgress(embryoProgress));
    }

    public static void setEmbryo(Animal animal, @Nullable EntityInfo embryo) {
        ModCapabilitiesImpl.getMammalCap(animal).ifPresent(iMammalCap -> iMammalCap.setEmbryo(embryo));
    }

    public static void syncMammalWithClient(Animal animal, int embryoProgress, EntityInfo embryo) {
        MessageHandler.CAP_CHANNEL.sendToPlayers((Iterable)((ServerLevel)animal.m_9236_()).m_8795_(serverPlayer -> true), (Object)new S2CMammalCapMessage(animal, embryoProgress, embryo));
    }

    public static boolean hasHatchedDinosaur(Player player) {
        return ModCapabilitiesImpl.getFirstHatchCap(player).map(IFirstHatchCap::hasHatchedDinosaur).orElse(false);
    }

    public static void setHatchedDinosaur(Player player, boolean hatched) {
        ModCapabilitiesImpl.getFirstHatchCap(player).ifPresent(iFirstHatchCap -> iFirstHatchCap.setHatchedDinosaur(hatched));
    }

    public static CommonEnergyStorage createEnergyStorage(final Runnable setChanged) {
        return new FAEnergyStorage(FossilConfig.getInt("machineMaxEnergy"), FossilConfig.getInt("machineTransferRate"), FossilConfig.getInt("machineEnergyUsage"), 0){

            @Override
            protected void onChange() {
                setChanged.run();
            }
        };
    }
}

