/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.patterns.sound;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mojang.serialization.codecs.UnboundedMapCodec;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import whocraft.tardis_refined.patterns.PatternResourceConstants;
import whocraft.tardis_refined.patterns.sound.ConfiguredSound;

public class ShellSoundProfile {
    private static final UnboundedMapCodec<ResourceLocation, ConfiguredSound> UNBOUNDED_MAP_CODEC = Codec.unboundedMap((Codec)ResourceLocation.f_135803_, ConfiguredSound.CODEC);
    public static final Codec<ShellSoundProfile> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)UNBOUNDED_MAP_CODEC.fieldOf("sounds").forGetter(ShellSoundProfile::getSoundEntries)).apply((Applicative)instance, ShellSoundProfile::new));
    protected Map<ResourceLocation, ConfiguredSound> shellSoundEntries = new HashMap<ResourceLocation, ConfiguredSound>();

    public ShellSoundProfile(Map<ResourceLocation, ConfiguredSound> shellSoundEntries) {
        this.shellSoundEntries = shellSoundEntries;
    }

    public ShellSoundProfile() {
        this(new HashMap<ResourceLocation, ConfiguredSound>());
    }

    public Map<ResourceLocation, ConfiguredSound> getSoundEntries() {
        return this.shellSoundEntries;
    }

    public ConfiguredSound getDoorOpen() {
        return this.shellSoundEntries.get(PatternResourceConstants.DOOR_OPEN_KEY);
    }

    public ShellSoundProfile setDoorOpen(ConfiguredSound doorOpen) {
        this.shellSoundEntries.put(PatternResourceConstants.DOOR_OPEN_KEY, doorOpen);
        return this;
    }

    public ConfiguredSound getDoorClose() {
        return this.shellSoundEntries.get(PatternResourceConstants.DOOR_CLOSE_KEY);
    }

    public ShellSoundProfile setDoorClose(ConfiguredSound doorClose) {
        this.shellSoundEntries.put(PatternResourceConstants.DOOR_CLOSE_KEY, doorClose);
        return this;
    }

    public ConfiguredSound getDoorLocked() {
        return this.shellSoundEntries.get(PatternResourceConstants.DOOR_LOCK_KEY);
    }

    public ShellSoundProfile setDoorLocked(ConfiguredSound doorLocked) {
        this.shellSoundEntries.put(PatternResourceConstants.DOOR_LOCK_KEY, doorLocked);
        return this;
    }

    public ConfiguredSound getDoorUnlocked() {
        return this.shellSoundEntries.get(PatternResourceConstants.DOOR_UNLOCK_KEY);
    }

    public ShellSoundProfile setDoorUnlocked(ConfiguredSound doorUnlocked) {
        this.shellSoundEntries.put(PatternResourceConstants.DOOR_UNLOCK_KEY, doorUnlocked);
        return this;
    }
}

