/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.forge;

import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDestroyBlockEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import whocraft.tardis_refined.command.TardisRefinedCommand;
import whocraft.tardis_refined.common.capability.player.TardisPlayerInfo;
import whocraft.tardis_refined.common.dimension.DimensionHandler;
import whocraft.tardis_refined.common.dimension.TardisTeleportData;
import whocraft.tardis_refined.common.soundscape.hum.TardisHums;
import whocraft.tardis_refined.common.tardis.TardisDesktops;
import whocraft.tardis_refined.common.util.MiscHelper;
import whocraft.tardis_refined.common.util.TardisHelper;
import whocraft.tardis_refined.compat.ModCompatChecker;
import whocraft.tardis_refined.compat.create.CreateIntergrationsForge;
import whocraft.tardis_refined.patterns.ConsolePatterns;
import whocraft.tardis_refined.patterns.ShellPatterns;

@Mod.EventBusSubscriber(modid="tardis_refined", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class CommonBus {
    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            TardisTeleportData.tick();
        }
    }

    @SubscribeEvent
    public static void onServerStart(ServerStartedEvent event) {
        ServerLevel world = event.getServer().m_129880_(Level.f_46428_);
        DimensionHandler.loadLevels(world);
        if (ModCompatChecker.create()) {
            CreateIntergrationsForge.initAssignments();
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent playerLoggedOutEvent) {
        Player player = playerLoggedOutEvent.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            TardisPlayerInfo.get((LivingEntity)player).ifPresent(tardisPlayerInfo -> tardisPlayerInfo.endShellView(serverPlayer));
        }
    }

    @SubscribeEvent
    public static void onDatapack(AddReloadListenerEvent addReloadListenerEvent) {
        addReloadListenerEvent.addListener(ConsolePatterns.getReloadListener());
        addReloadListenerEvent.addListener(TardisDesktops.getReloadListener());
        addReloadListenerEvent.addListener(ShellPatterns.getReloadListener());
        addReloadListenerEvent.addListener(TardisHums.getReloadListener());
    }

    @SubscribeEvent
    public static void onCommandRegister(RegisterCommandsEvent event) {
        TardisRefinedCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    public static void onBlockPlace(BlockEvent.EntityPlaceEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (MiscHelper.shouldStopItem(event.getEntity().m_9236_(), player, event.getPos(), player.m_21205_())) {
                event.getLevel().m_46961_(event.getPos(), true);
            }
        }
    }

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        event.setCanceled(MiscHelper.shouldCancelBreaking(event.getPlayer().m_9236_(), (Entity)event.getPlayer(), event.getPos(), event.getState()));
    }

    @SubscribeEvent
    public static void onEntityBlockBreak(LivingDestroyBlockEvent event) {
        event.setCanceled(MiscHelper.shouldCancelBreaking(event.getEntity().m_9236_(), (Entity)event.getEntity(), event.getPos(), event.getState()));
    }

    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        ServerPlayer serverPlayer;
        Player player = event.getEntity();
        if (player instanceof ServerPlayer && (serverPlayer = (ServerPlayer)player) != null) {
            TardisHelper.handlePlayerJoinWorldEvents(serverPlayer);
        }
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        ServerPlayer serverPlayer;
        Player player = event.getEntity();
        if (player instanceof ServerPlayer && (serverPlayer = (ServerPlayer)player) != null) {
            TardisHelper.handlePlayerJoinWorldEvents(serverPlayer);
        }
    }

    @SubscribeEvent
    public static void onPlayerChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        ServerPlayer serverPlayer;
        Player player = event.getEntity();
        if (player instanceof ServerPlayer && (serverPlayer = (ServerPlayer)player) != null) {
            TardisHelper.handlePlayerJoinWorldEvents(serverPlayer);
        }
    }
}

