/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.compat.create;

import com.simibubi.create.api.behaviour.display.DisplaySource;
import com.simibubi.create.content.redstone.displayLink.DisplayLinkContext;
import com.simibubi.create.content.redstone.displayLink.target.DisplayTargetStats;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import whocraft.tardis_refined.common.capability.tardis.TardisLevelOperator;
import whocraft.tardis_refined.common.tardis.TardisNavLocation;
import whocraft.tardis_refined.common.util.MiscHelper;
import whocraft.tardis_refined.constants.ModMessages;

public class TardisNavLocationDisplaySource
extends DisplaySource {
    private final TardisNavInfo tardisNavInfo;

    public TardisNavLocationDisplaySource(TardisNavInfo tardisNavInfo) {
        this.tardisNavInfo = tardisNavInfo;
    }

    public List<MutableComponent> provideText(DisplayLinkContext context, DisplayTargetStats stats) {
        ServerLevel serverLevel;
        boolean isPresent;
        Level level = context.level();
        if (level instanceof ServerLevel && (isPresent = TardisLevelOperator.get(serverLevel = (ServerLevel)level).isPresent())) {
            TardisNavLocation tardisNavLocation = this.tardisNavInfo.provideInfo(TardisLevelOperator.get(serverLevel).get());
            ArrayList<MutableComponent> components = new ArrayList<MutableComponent>();
            components.add(Component.m_237110_((String)ModMessages.POSITION, (Object[])new Object[]{tardisNavLocation.getPosition().m_123344_()}));
            components.add(Component.m_237110_((String)ModMessages.DIRECTION, (Object[])new Object[]{tardisNavLocation.getDirection().m_122433_()}));
            components.add(Component.m_237110_((String)ModMessages.DIMENSION, (Object[])new Object[]{MiscHelper.getCleanDimensionName(tardisNavLocation.getDimensionKey())}));
            return components;
        }
        return List.of(Component.m_237115_((String)ModMessages.HARDWARE_OFFLINE));
    }

    public int getPassiveRefreshTicks() {
        return 10;
    }

    public static interface TardisNavInfo {
        public TardisNavLocation provideInfo(TardisLevelOperator var1);

        public ResourceLocation getId();
    }
}

