/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.common.util;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import whocraft.tardis_refined.TardisRefined;
import whocraft.tardis_refined.common.network.MessageS2C;
import whocraft.tardis_refined.common.network.NetworkManager;
import whocraft.tardis_refined.common.util.forge.MergeableCodecJsonReloadListenerImpl;

public class MergeableCodecJsonReloadListener<RAW, PROCESSED>
extends SimplePreparableReloadListener<Map<ResourceLocation, PROCESSED>> {
    protected final Codec<RAW> codec;
    protected final String folderName;
    protected final String EXTENSION_NAME = ".json";
    protected final int EXTENSION_LENGTH = ".json".length();
    public static Logger LOGGER = LogManager.getLogger((String)"TardisRefined/MergeableCodecJsonReloadListener");
    protected final Function<List<RAW>, PROCESSED> merger;
    protected Map<ResourceLocation, PROCESSED> data = new HashMap<ResourceLocation, PROCESSED>();

    protected MergeableCodecJsonReloadListener(String folderName, Codec<RAW> codec, Function<List<RAW>, PROCESSED> merger) {
        this(folderName, codec, TardisRefined.GSON, merger);
    }

    protected MergeableCodecJsonReloadListener(String folderName, Codec<RAW> codec, Gson gson, Function<List<RAW>, PROCESSED> merger) {
        this.folderName = folderName;
        this.codec = codec;
        this.merger = merger;
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <RAW, PROCESSED> MergeableCodecJsonReloadListener<RAW, PROCESSED> create(String folderName, Codec<PROCESSED> codec) {
        void var1_1;
        return MergeableCodecJsonReloadListenerImpl.create((String)folderName, (Codec)var1_1);
    }

    protected Map<ResourceLocation, PROCESSED> prepare(ResourceManager resourceManager, ProfilerFiller profilerFiller) {
        LOGGER.info("Beginning loading of data for data loader: {}", (Object)this.folderName);
        Map<Object, Object> map = new HashMap();
        Map resourceStacks = resourceManager.m_214160_(this.folderName, id -> id.m_135815_().endsWith(".json"));
        map = this.mapValues(resourceStacks);
        LOGGER.info("Data loader for {} loaded {} jsons", (Object)this.folderName, (Object)this.data.size());
        return Map.copyOf(map);
    }

    protected void apply(Map<ResourceLocation, PROCESSED> processedData, ResourceManager resourceManager, ProfilerFiller profiler) {
        this.data = processedData;
    }

    protected Map<ResourceLocation, PROCESSED> mapValues(Map<ResourceLocation, List<Resource>> inputs) {
        HashMap<ResourceLocation, PROCESSED> entries = new HashMap<ResourceLocation, PROCESSED>();
        for (Map.Entry<ResourceLocation, List<Resource>> entry : inputs.entrySet()) {
            ArrayList raws = new ArrayList();
            ResourceLocation fullId = entry.getKey();
            String fullPath = fullId.m_135815_();
            ResourceLocation key = new ResourceLocation(fullId.m_135827_(), fullPath.substring(this.folderName.length() + 1, fullPath.length() - this.EXTENSION_LENGTH));
            for (Resource resource : entry.getValue()) {
                try {
                    BufferedReader reader = resource.m_215508_();
                    try {
                        JsonElement element = JsonParser.parseReader((Reader)reader);
                        this.codec.decode((DynamicOps)JsonOps.INSTANCE, (Object)element).get().ifLeft(result -> {
                            raws.add(result.getFirst());
                            LOGGER.info("Adding entry for {}", (Object)key);
                        }).ifRight(partial -> LOGGER.error("Error deserializing json {} in folder {} from pack {}: {}", (Object)key, (Object)this.folderName, (Object)resource.m_215506_(), (Object)partial.message()));
                    }
                    finally {
                        if (reader == null) continue;
                        ((Reader)reader).close();
                    }
                }
                catch (Exception e) {
                    LOGGER.error(String.format(Locale.ENGLISH, "Error reading resource %s in folder %s from pack %s: ", key, this.folderName, resource.m_215506_()), (Throwable)e);
                }
            }
            entries.put(key, this.merger.apply(raws));
        }
        return entries;
    }

    public Map<ResourceLocation, PROCESSED> getData() {
        return this.data;
    }

    public void setData(Map<ResourceLocation, PROCESSED> data) {
        this.data = data;
    }

    public String getFolderName() {
        return this.folderName;
    }

    public MergeableCodecJsonReloadListener<RAW, PROCESSED> setSyncPacket(NetworkManager networkManager, Function<Map<ResourceLocation, PROCESSED>, MessageS2C> packetFactory) {
        return this;
    }

    protected void handleSyncPacket(ServerPlayer player, NetworkManager networkManager, Function<Map<ResourceLocation, PROCESSED>, MessageS2C> packetFactory) {
        MessageS2C packet = packetFactory.apply(this.data);
        if (player == null) {
            networkManager.sendToAllPlayers(packet);
        } else {
            networkManager.sendToPlayer(player, packet);
        }
    }
}

