/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.common.util;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import whocraft.tardis_refined.TRConfig;
import whocraft.tardis_refined.TardisRefined;
import whocraft.tardis_refined.common.util.Platform;
import whocraft.tardis_refined.registry.TRDimensionTypes;

public class DimensionUtil {
    public static boolean isAllowedDimension(ResourceKey<Level> level) {
        String namespace = level.m_135782_().m_135827_();
        String location = level.m_135782_().toString();
        List bannedDimensions = (List)TRConfig.SERVER.BANNED_DIMENSIONS.get();
        return !namespace.contains("immersive_portals") && !namespace.contains("tardis_refined") && !bannedDimensions.contains(location);
    }

    public static Set<ResourceKey<Level>> getTardisLevels(MinecraftServer server) {
        HashSet set = Sets.newHashSet();
        for (ServerLevel level : server.m_129785_()) {
            if (level.m_220362_() != TRDimensionTypes.TARDIS) continue;
            set.add(level.m_46472_());
        }
        return set;
    }

    public static Set<ResourceKey<Level>> getAllowedDimensions(MinecraftServer server) {
        HashSet set = Sets.newHashSet();
        for (ServerLevel level : server.m_129785_()) {
            if (!DimensionUtil.isAllowedDimension((ResourceKey<Level>)level.m_46472_())) continue;
            set.add(level.m_46472_());
        }
        return set;
    }

    public static ServerLevel getLevel(ResourceKey<Level> levelResourceKey) {
        if (Platform.getServer() == null) {
            TardisRefined.LOGGER.error("Null Server when looking for {} - Can be ignored if logging out", levelResourceKey);
            return null;
        }
        return Platform.getServer().m_129880_(levelResourceKey);
    }
}

