/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.common.util;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import whocraft.tardis_refined.TardisRefined;
import whocraft.tardis_refined.common.network.MessageS2C;
import whocraft.tardis_refined.common.network.NetworkManager;
import whocraft.tardis_refined.common.util.forge.CodecJsonReloadListenerImpl;

public class CodecJsonReloadListener<T>
extends SimpleJsonResourceReloadListener {
    public static Logger LOGGER = LogManager.getLogger((String)"TardisRefined/CodecJsonReloadListener");
    protected final Codec<T> codec;
    protected final String folderName;
    protected Map<ResourceLocation, T> data = new HashMap<ResourceLocation, T>();

    protected CodecJsonReloadListener(String folderName, Codec<T> codec) {
        this(folderName, codec, TardisRefined.GSON);
    }

    protected CodecJsonReloadListener(String folderName, Codec<T> codec, Gson gson) {
        super(gson, folderName);
        this.folderName = folderName;
        this.codec = codec;
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <T> CodecJsonReloadListener<T> create(String folderName, Codec<T> codec) {
        void var1_1;
        return CodecJsonReloadListenerImpl.create(folderName, var1_1);
    }

    protected void apply(Map<ResourceLocation, JsonElement> jsons, ResourceManager resourceManager, ProfilerFiller profilerFiller) {
        LOGGER.info("Beginning loading of data for data loader: {}", (Object)this.folderName);
        this.data = this.mapValues(jsons);
        LOGGER.info("Data loader for {} loaded {} entries", (Object)this.folderName, (Object)this.data.size());
    }

    protected Map<ResourceLocation, T> mapValues(Map<ResourceLocation, JsonElement> inputs) {
        HashMap entries = new HashMap();
        for (Map.Entry<ResourceLocation, JsonElement> entry : inputs.entrySet()) {
            ResourceLocation key = entry.getKey();
            JsonElement element = entry.getValue();
            this.codec.decode((DynamicOps)JsonOps.INSTANCE, (Object)element).get().ifLeft(result -> {
                entries.put(key, result.getFirst());
                LOGGER.info("Adding entry {}", (Object)key);
            }).ifRight(partial -> LOGGER.error("Failed to parse data json for {} due to: {}", (Object)key, (Object)partial.message()));
        }
        return entries;
    }

    public Map<ResourceLocation, T> getData() {
        return this.data;
    }

    public String getFolderName() {
        return this.folderName;
    }

    public CodecJsonReloadListener<T> setSyncPacket(NetworkManager networkManager, Function<Map<ResourceLocation, T>, MessageS2C> packetFactory) {
        return this;
    }

    protected void handleSyncPacket(ServerPlayer player, NetworkManager networkManager, Function<Map<ResourceLocation, T>, MessageS2C> packetFactory) {
        MessageS2C packet = packetFactory.apply(this.data);
        if (player == null) {
            networkManager.sendToAllPlayers(packet);
        } else {
            networkManager.sendToPlayer(player, packet);
        }
    }
}

