/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.common.tardis.themes;

import net.minecraft.Util;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import whocraft.tardis_refined.common.tardis.themes.Theme;
import whocraft.tardis_refined.registry.DeferredRegistry;
import whocraft.tardis_refined.registry.RegistrySupplier;

public class ShellTheme
implements Theme {
    public static final ResourceKey<Registry<ShellTheme>> SHELL_THEME_REGISTRY_KEY = ResourceKey.m_135788_((ResourceLocation)new ResourceLocation("tardis_refined", "shell_theme"));
    public static final DeferredRegistry<ShellTheme> SHELL_THEME_DEFERRED_REGISTRY = DeferredRegistry.createCustom("tardis_refined", SHELL_THEME_REGISTRY_KEY, true);
    public static final RegistrySupplier<ShellTheme> HALF_BAKED = ShellTheme.registerShellTheme("half_baked");
    public static final RegistrySupplier<ShellTheme> FACTORY = ShellTheme.registerShellTheme("factory");
    public static final RegistrySupplier<ShellTheme> POLICE_BOX = ShellTheme.registerShellTheme("police_box", true);
    public static final RegistrySupplier<ShellTheme> PHONE_BOOTH = ShellTheme.registerShellTheme("phone_booth", true);
    public static final RegistrySupplier<ShellTheme> MYSTIC = ShellTheme.registerShellTheme("mystic", true);
    public static final RegistrySupplier<ShellTheme> PRESENT = ShellTheme.registerShellTheme("present");
    public static final RegistrySupplier<ShellTheme> DRIFTER = ShellTheme.registerShellTheme("drifter");
    public static final RegistrySupplier<ShellTheme> VENDING = ShellTheme.registerShellTheme("vending", true);
    public static final RegistrySupplier<ShellTheme> BRIEFCASE = ShellTheme.registerShellTheme("briefcase");
    public static final RegistrySupplier<ShellTheme> GROENING = ShellTheme.registerShellTheme("groening", true);
    public static final RegistrySupplier<ShellTheme> BIG_BEN = ShellTheme.registerShellTheme("big_ben", true);
    public static final RegistrySupplier<ShellTheme> NUKA = ShellTheme.registerShellTheme("nuka", true);
    public static final RegistrySupplier<ShellTheme> GROWTH = ShellTheme.registerShellTheme("growth");
    public static final RegistrySupplier<ShellTheme> PORTALOO = ShellTheme.registerShellTheme("portaloo");
    public static final RegistrySupplier<ShellTheme> PAGODA = ShellTheme.registerShellTheme("pagoda");
    public static final RegistrySupplier<ShellTheme> LIFT = ShellTheme.registerShellTheme("lift", true);
    public static final RegistrySupplier<ShellTheme> HIEROGLYPH = ShellTheme.registerShellTheme("hieroglyph");
    public static final RegistrySupplier<ShellTheme> CASTLE = ShellTheme.registerShellTheme("castle");
    public static final RegistrySupplier<ShellTheme> PATHFINDER = ShellTheme.registerShellTheme("pathfinder");
    public static final RegistrySupplier<ShellTheme> SHULKER = ShellTheme.registerShellTheme("shulker");
    private ResourceLocation translationKey;
    private boolean producesLight;

    public static ShellTheme getShellTheme(ResourceLocation resourceLocation) {
        ShellTheme potentialTheme = SHELL_THEME_DEFERRED_REGISTRY.get(resourceLocation);
        if (potentialTheme != null) {
            return potentialTheme;
        }
        return HALF_BAKED.get();
    }

    public static ResourceLocation getKey(ShellTheme shellTheme) {
        return SHELL_THEME_DEFERRED_REGISTRY.getKey(shellTheme);
    }

    public ShellTheme(ResourceLocation translationKey, boolean producesLight) {
        this.translationKey = translationKey;
        this.producesLight = producesLight;
    }

    public ShellTheme(ResourceLocation translationKey) {
        this(translationKey, false);
    }

    private static RegistrySupplier<ShellTheme> registerShellTheme(String id) {
        return SHELL_THEME_DEFERRED_REGISTRY.register(id, () -> new ShellTheme(new ResourceLocation("tardis_refined", id)));
    }

    private static RegistrySupplier<ShellTheme> registerShellTheme(String id, boolean producesLight) {
        return SHELL_THEME_DEFERRED_REGISTRY.register(id, () -> new ShellTheme(new ResourceLocation("tardis_refined", id), producesLight));
    }

    @Override
    public String getTranslationKey() {
        return Util.m_137492_((String)"shell", (ResourceLocation)this.translationKey);
    }

    @Override
    public Component getDisplayName() {
        return Component.m_237115_((String)this.getTranslationKey());
    }

    public boolean producesLight() {
        return this.producesLight;
    }
}

