/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.common.tardis.manager;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import whocraft.tardis_refined.api.event.TardisCommonEvents;
import whocraft.tardis_refined.common.block.console.GlobalConsoleBlock;
import whocraft.tardis_refined.common.blockentity.console.GlobalConsoleBlockEntity;
import whocraft.tardis_refined.common.blockentity.shell.ShellBaseBlockEntity;
import whocraft.tardis_refined.common.capability.tardis.TardisLevelOperator;
import whocraft.tardis_refined.common.capability.tardis.upgrades.IncrementUpgrade;
import whocraft.tardis_refined.common.capability.tardis.upgrades.SpeedUpgrade;
import whocraft.tardis_refined.common.capability.tardis.upgrades.Upgrade;
import whocraft.tardis_refined.common.capability.tardis.upgrades.UpgradeHandler;
import whocraft.tardis_refined.common.tardis.TardisArchitectureHandler;
import whocraft.tardis_refined.common.tardis.TardisNavLocation;
import whocraft.tardis_refined.common.tardis.manager.TardisExteriorManager;
import whocraft.tardis_refined.common.tardis.manager.TickableHandler;
import whocraft.tardis_refined.common.util.LevelHelper;
import whocraft.tardis_refined.common.util.PlayerUtil;
import whocraft.tardis_refined.common.util.TardisHelper;
import whocraft.tardis_refined.constants.ModMessages;
import whocraft.tardis_refined.constants.NbtConstants;
import whocraft.tardis_refined.patterns.ConsolePattern;
import whocraft.tardis_refined.registry.TRSoundRegistry;
import whocraft.tardis_refined.registry.TRUpgrades;

public class TardisPilotingManager
extends TickableHandler {
    public static final int MAX_THROTTLE_STAGE = 5;
    private static final int TICKS_LANDING_MAX = 180;
    public static final int TICKS_COOLDOWN_MAX = 12000;
    private static final double DEFAULT_MAXIMUM_FUEL = 1000.0;
    private static final double FLIGHT_COST = 0.5;
    private final TardisLevelOperator operator;
    private TardisNavLocation targetLocation = TardisNavLocation.ORIGIN;
    private TardisNavLocation currentLocation = TardisNavLocation.ORIGIN;
    private TardisNavLocation fastReturnLocation = TardisNavLocation.ORIGIN;
    private boolean isInFlight = false;
    private int ticksInFlight = 0;
    private int flightDistance = 100;
    private int distanceCovered = 0;
    private int ticksLanding = 0;
    private int ticksTakingOff = 0;
    private int ticksCrashing = 0;
    private int ticksinCrashRecovery = 0;
    private boolean isInCrashRecovery = false;
    private boolean isCrashing = false;
    private int speedModifier = 1;
    private boolean canUseControls = true;
    private int cordIncrementIndex = 0;
    private boolean autoLand = false;
    private double fuel = 0.0;
    private double maximumFuel = 1000.0;
    private boolean isHandbrakeOn = false;
    private int throttleStage = 0;
    private GlobalConsoleBlockEntity currentConsole;
    private BlockPos currentConsoleBlockPos = BlockPos.f_121853_;
    private boolean isPassivelyRefuelling = false;
    private ShellBaseBlockEntity newCurrentBlockEntity;

    public TardisPilotingManager(TardisLevelOperator operator) {
        this.operator = operator;
    }

    public void endRecovery() {
        this.isInCrashRecovery = false;
        this.canUseControls = true;
        this.ticksinCrashRecovery = 0;
        this.operator.getLevel().m_5594_(null, TardisArchitectureHandler.DESKTOP_CENTER_POS, TRSoundRegistry.TARDIS_SINGLE_FLY.get(), SoundSource.AMBIENT, 100.0f, 0.25f);
    }

    @Override
    public void loadData(CompoundTag tag) {
        this.autoLand = tag.m_128471_("ctrl_autoland");
        this.isInFlight = tag.m_128471_("ctrl_is_in_flight");
        this.isHandbrakeOn = tag.m_128471_("is_handbrake_on");
        this.throttleStage = tag.m_128451_("throttle_stage");
        this.isPassivelyRefuelling = tag.m_128471_("is_passively_refueling");
        this.setCurrentLocation(NbtConstants.getTardisNavLocation(tag, "current_location"));
        this.setTargetLocation(NbtConstants.getTardisNavLocation(tag, "target_location"));
        this.fastReturnLocation = NbtConstants.getTardisNavLocation(tag, "return_location");
        this.currentConsoleBlockPos = NbtUtils.m_129239_((CompoundTag)tag.m_128469_("currentConsoleBlockPos"));
        this.ticksCrashing = tag.m_128451_("ticksCrashing");
        this.ticksinCrashRecovery = tag.m_128451_("ticksInCrashRecovery");
        this.isInCrashRecovery = tag.m_128471_("isInCrashRecovery");
        this.flightDistance = tag.m_128451_("flight_distance");
        this.distanceCovered = tag.m_128451_("distance_covered");
        this.canUseControls = tag.m_128471_("canUseControls");
        this.cordIncrementIndex = tag.m_128451_("ctrl_increment_index");
        this.speedModifier = tag.m_128451_("speed_modifier");
        this.fuel = tag.m_128459_("fuel");
        this.maximumFuel = tag.m_128459_("MaximumFuel");
        if (!tag.m_128441_("MaximumFuel")) {
            this.maximumFuel = 1000.0;
        }
    }

    @Override
    public CompoundTag saveData(CompoundTag tag) {
        tag.m_128379_("ctrl_is_in_flight", this.isInFlight);
        tag.m_128379_("ctrl_autoland", this.autoLand);
        tag.m_128379_("is_handbrake_on", this.isHandbrakeOn);
        tag.m_128405_("throttle_stage", this.throttleStage);
        tag.m_128405_("speed_modifier", this.speedModifier);
        tag.m_128405_("ticksCrashing", this.ticksCrashing);
        tag.m_128405_("ticksInCrashRecovery", this.ticksinCrashRecovery);
        tag.m_128379_("isInCrashRecovery", this.isInCrashRecovery);
        tag.m_128405_("flight_distance", this.flightDistance);
        tag.m_128405_("distance_covered", this.distanceCovered);
        tag.m_128379_("canUseControls", this.canUseControls);
        tag.m_128379_("is_passively_refueling", this.isPassivelyRefuelling);
        if (this.currentConsoleBlockPos != null) {
            tag.m_128365_("currentConsoleBlockPos", (Tag)NbtUtils.m_129224_((BlockPos)this.currentConsoleBlockPos));
        }
        NbtConstants.writeTardisNavLocation(tag, "target_location", this.getTargetLocation());
        NbtConstants.writeTardisNavLocation(tag, "current_location", this.getCurrentLocation());
        NbtConstants.writeTardisNavLocation(tag, "return_location", this.getFastReturnLocation());
        tag.m_128405_("ctrl_increment_index", this.cordIncrementIndex);
        tag.m_128347_("fuel", this.fuel);
        tag.m_128347_("MaximumFuel", this.maximumFuel);
        return tag;
    }

    public void setCurrentLocationOnNextTick(ShellBaseBlockEntity blockEntity) {
        this.newCurrentBlockEntity = blockEntity;
    }

    @Override
    public void tick(ServerLevel level) {
        if (this.getTargetLocation() == null) {
            this.setTargetLocation(this.getCurrentLocation() != null ? this.getCurrentLocation().copy() : TardisNavLocation.ORIGIN);
        }
        if (this.isInFlight) {
            this.onFlightTick(level);
        }
        this.checkThrottleStatesForFlight();
        if (this.getFlightPercentageCovered() == 1.0f && this.operator.getFlightDanceManager().isDancing()) {
            this.operator.getFlightDanceManager().stopDancing();
        }
        if (this.ticksinCrashRecovery > 0) {
            this.tickCrashRecovery();
        }
        if (this.isPassivelyRefuelling && level.m_46467_() % 60L == 0L) {
            this.addFuel(10.0);
            if (this.getFuel() >= this.getMaximumFuel()) {
                this.setFuel(this.getMaximumFuel());
                this.isPassivelyRefuelling = false;
            }
        } else if (!this.operator.getInteriorManager().isCave() && level.m_46467_() % 20L == 0L && !this.isPassivelyRefuelling && this.getFuel() < this.getMaximumFuel() * 0.05 && this.currentConsole != null) {
            level.m_5594_(null, this.currentConsole.m_58899_(), TRSoundRegistry.ALARM.get(), SoundSource.AMBIENT, 10.0f, 1.0f);
        }
    }

    private void onFlightTick(ServerLevel level) {
        if (this.throttleStage != 0 || this.autoLand) {
            ++this.ticksInFlight;
            if (this.ticksInFlight % 45 == 0) {
                this.removeFuel(this.getFlightFuelCost() * (double)this.throttleStage);
            }
            if (this.operator.getLevel().m_46467_() % 20L == 0L && this.distanceCovered <= this.flightDistance) {
                this.distanceCovered += (int)((double)this.throttleStage + 0.5 * (double)this.throttleStage * (double)this.speedModifier);
                if (this.distanceCovered >= this.flightDistance && this.currentConsole != null) {
                    level.m_5594_(null, this.currentConsole.m_58899_(), TRSoundRegistry.DESTINATION_DING.get(), SoundSource.AMBIENT, 10.0f, 1.0f);
                    this.operator.getFlightDanceManager().stopDancing();
                }
            }
            if (this.isOutOfFuel() && !this.isLanding() && this.ticksCrashing == 0) {
                this.endFlightEarly(true);
            }
            if (this.isHandbrakeOn && !this.isLanding() && !this.isTakingOff() && this.ticksCrashing == 0) {
                this.endFlightEarly(true);
            }
            if (this.distanceCovered >= this.flightDistance && this.autoLand && !this.isLanding()) {
                this.endFlight(false, false);
            }
        }
        if (this.ticksTakingOff > 0) {
            ++this.ticksTakingOff;
        }
        if (this.ticksTakingOff == 220) {
            this.enterTimeVortex();
        }
        if (this.ticksLanding > 0) {
            --this.ticksLanding;
        }
        if (this.ticksLanding == 1) {
            this.onFlightEnd();
        }
        if (this.ticksCrashing > 1) {
            --this.ticksCrashing;
        }
        if (this.ticksCrashing == 1) {
            this.onCrashEnd();
        }
    }

    private void checkThrottleStatesForFlight() {
        if (!this.isInFlight && !this.isHandbrakeOn && this.throttleStage != 0 && this.canBeginFlight()) {
            this.beginFlight(false);
        }
        if (this.isInFlight && !this.canEndFlight() && this.isHandbrakeOn && this.throttleStage == 0 && !this.isLanding() && !this.isTakingOff()) {
            this.endFlightEarly(false);
        }
        if (this.isInFlight && this.canEndFlight() && !this.isLanding() && !this.isTakingOff() && (this.isHandbrakeOn || this.throttleStage == 0)) {
            this.endFlight(false, false);
        }
    }

    private void tickCrashRecovery() {
        ++this.ticksinCrashRecovery;
        if (this.ticksinCrashRecovery % 120 == 0) {
            TardisHelper.playCloisterBell(this.operator);
        }
        if (this.ticksinCrashRecovery >= 12000) {
            this.endRecovery();
        } else {
            this.isInCrashRecovery = true;
        }
    }

    public boolean preloadFastReturn() {
        if (this.fastReturnLocation == null) {
            return false;
        }
        this.setTargetLocation(this.fastReturnLocation.copy());
        return true;
    }

    public TardisNavLocation findClosestValidPosition(TardisNavLocation location) {
        ServerLevel level = location.getLevel();
        BlockPos position = location.getPosition();
        Direction direction = location.getDirection();
        ChunkPos chunkPos = level.m_46865_(position).m_7697_();
        int maxBuildHeight = level.m_151558_();
        int minHeight = level.m_141937_();
        ArrayList<TardisNavLocation> solutionsInRow = new ArrayList<TardisNavLocation>();
        level.m_8602_(chunkPos.f_45578_, chunkPos.f_45579_, true);
        TardisNavLocation closest = new TardisNavLocation(BlockPos.f_121853_, Direction.NORTH, level);
        if (this.canPlaceTardis(location) && this.isExitPositionSafe(location)) {
            solutionsInRow.add(location);
        }
        if (!solutionsInRow.isEmpty()) {
            closest = location;
        } else {
            List<TardisNavLocation> nextValidLocations = this.findValidLocationInColumn(level, position, direction, minHeight, maxBuildHeight);
            if (!nextValidLocations.isEmpty()) {
                solutionsInRow.addAll(nextValidLocations);
            } else {
                List<BlockPos> surroundingPositionsSameYLevel = LevelHelper.getBlockPosInRadius(position, 1, true, false);
                for (BlockPos directionOffset : surroundingPositionsSameYLevel) {
                    TardisNavLocation nextLocation = new TardisNavLocation(directionOffset, location.getDirection(), location.getLevel());
                    if (!this.canPlaceTardis(nextLocation) || !this.isExitPositionSafe(nextLocation)) continue;
                    solutionsInRow.add(nextLocation);
                }
                if (solutionsInRow.isEmpty()) {
                    List<BlockPos> surroundingPositionsForColumn = LevelHelper.getBlockPosInRadius(position, 1, true, true);
                    for (BlockPos pos : surroundingPositionsForColumn) {
                        List<TardisNavLocation> surroundingColumn = this.findValidLocationInColumn(level, pos, direction, minHeight, maxBuildHeight);
                        if (surroundingColumn.isEmpty()) continue;
                        solutionsInRow.addAll(surroundingColumn);
                    }
                }
            }
            closest = this.findClosestValidPositionFromTarget(solutionsInRow, location);
        }
        level.m_8602_(chunkPos.f_45578_, chunkPos.f_45579_, false);
        return closest;
    }

    private List<TardisNavLocation> findValidLocationInColumn(TardisNavLocation location, int minHeight, int maxBuildHeight) {
        return this.findValidLocationInColumn(location.getLevel(), location.getPosition(), location.getDirection(), minHeight, maxBuildHeight);
    }

    private List<TardisNavLocation> findValidLocationInColumn(ServerLevel level, BlockPos position, Direction direction, int minHeight, int maxBuildHeight) {
        ArrayList<TardisNavLocation> solutionsInRow = new ArrayList<TardisNavLocation>();
        List<BlockPos> blockColumn = this.getBlockPosColumn(position, minHeight, maxBuildHeight);
        List<BlockPos> filteredForAir = blockColumn.stream().filter(x -> this.isLegalLandingBlock(level, (BlockPos)x)).toList();
        List<BlockPos> filteredForNonAir = blockColumn.stream().filter(x -> !this.isLegalLandingBlock(level, (BlockPos)x)).toList();
        for (BlockPos airPos : filteredForAir) {
            if (level.m_46472_() == Level.f_46429_ && airPos.m_123342_() > 125) continue;
            BlockPos below = airPos.m_7495_();
            BlockPos above = airPos.m_7494_();
            if (!filteredForNonAir.contains(below) || !filteredForAir.contains(above) || !this.canPlaceTardis(level, airPos) || !this.isExitPositionSafe(level, airPos, direction)) continue;
            solutionsInRow.add(new TardisNavLocation(airPos, direction, level));
        }
        return solutionsInRow;
    }

    private TardisNavLocation findClosestValidPositionFromTarget(List<TardisNavLocation> validPositions, TardisNavLocation targetLocation) {
        int distance = Integer.MAX_VALUE;
        TardisNavLocation intendedLocation = targetLocation;
        TardisNavLocation closestSolution = new TardisNavLocation(BlockPos.f_121853_, Direction.NORTH, intendedLocation.getLevel());
        for (TardisNavLocation potentialLocation : validPositions) {
            int distanceBetween = Math.abs(potentialLocation.getPosition().m_123333_((Vec3i)intendedLocation.getPosition()));
            if (distanceBetween >= distance) continue;
            distance = distanceBetween;
            closestSolution = potentialLocation;
        }
        return closestSolution;
    }

    private List<BlockPos> getBlockPosColumn(BlockPos referencePoint, int min, int max) {
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        for (int i = min; i <= max; ++i) {
            positions.add(new BlockPos(referencePoint.m_123341_(), i, referencePoint.m_123343_()));
        }
        return positions;
    }

    private boolean isLegalLandingBlock(ServerLevel level, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        return state.m_60795_() || state.m_247087_() && state.m_60819_().m_76178_() && !state.m_60838_((BlockGetter)level, pos);
    }

    private boolean isExitPositionSafe(TardisNavLocation location) {
        return this.isExitPositionSafe(location.getLevel(), location.getPosition(), location.getDirection());
    }

    private boolean isExitPositionSafe(ServerLevel level, BlockPos pos, Direction offsetDirection) {
        BlockPos exitPosition = pos.m_121955_(offsetDirection.m_122436_());
        return this.isLegalLandingBlock(level, exitPosition.m_7494_()) && this.isLegalLandingBlock(level, exitPosition) && !this.isLegalLandingBlock(level, exitPosition.m_7495_());
    }

    private boolean canPlaceTardis(TardisNavLocation location) {
        ServerLevel targetLevel = location.getLevel();
        BlockPos pos = location.getPosition();
        boolean isBelowNetherRoof = targetLevel.m_46472_() == Level.f_46429_ && pos.m_123342_() <= 125;
        return isBelowNetherRoof && this.isLegalLandingBlock(targetLevel, pos) && this.isLegalLandingBlock(targetLevel, pos.m_7494_()) && !this.isLegalLandingBlock(targetLevel, pos.m_7495_());
    }

    private boolean canPlaceTardis(ServerLevel level, BlockPos pos) {
        return this.isLegalLandingBlock(level, pos) && this.isLegalLandingBlock(level, pos.m_7494_()) && !this.isLegalLandingBlock(level, pos.m_7495_());
    }

    public boolean canBeginFlight() {
        return !this.operator.getInteriorManager().isGeneratingDesktop() && !this.operator.getInteriorManager().isWaitingToGenerate() && !this.isInFlight && this.ticksTakingOff <= 0 && !this.isHandbrakeOn && !this.isCrashing && (!this.isOutOfFuel() || this.fuel > 5.0);
    }

    public boolean beginFlight(boolean autoLand) {
        if (this.getFuel() < 50.0) {
            this.operator.getLevel().m_6907_().forEach(x -> PlayerUtil.sendMessage((LivingEntity)x, (Component)Component.m_237115_((String)ModMessages.CANNOT_START_NO_FUEL), true));
            this.failTakeoff();
            return false;
        }
        if (this.getTargetLocation().getLevel().m_46472_() == Level.f_46430_ && !TardisHelper.hasTheEndBeenCompleted(this.getTargetLocation().getLevel())) {
            this.failTakeoff();
            for (Player player : this.operator.getLevel().m_6907_()) {
                PlayerUtil.sendMessage((LivingEntity)player, (Component)Component.m_237115_((String)ModMessages.NO_END_DRAGON_PREVENTS), true);
            }
            return false;
        }
        if (this.canBeginFlight()) {
            this.autoLand = autoLand;
            this.isPassivelyRefuelling = false;
            this.flightDistance = 0;
            this.distanceCovered = 0;
            this.speedModifier = this.getLatestSpeedModifier();
            TardisNavLocation currentLocationPreTakeoff = this.getCurrentLocation();
            this.fastReturnLocation = currentLocationPreTakeoff.copy();
            TardisNavLocation targetPosition = this.getTargetLocation();
            this.flightDistance = this.calculateFlightDistance(currentLocationPreTakeoff, targetPosition);
            if (!autoLand) {
                this.operator.getFlightDanceManager().startFlightDance(this.currentConsole);
            }
            this.operator.setDoorClosed(true);
            if (this.operator.getInternalDoor() != null) {
                this.operator.getLevel().m_5594_(null, this.operator.getInternalDoor().getDoorPosition(), TRSoundRegistry.TARDIS_TAKEOFF.get(), SoundSource.AMBIENT, 10.0f, 1.0f);
            }
            this.operator.getExteriorManager().playSoundAtShell(TRSoundRegistry.TARDIS_TAKEOFF.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            this.isInFlight = true;
            this.ticksInFlight = 0;
            this.ticksTakingOff = 1;
            this.operator.getExteriorManager().setIsTakingOff(this.isTakingOff());
            this.operator.tardisClientData().sync();
            return true;
        }
        return false;
    }

    public void failTakeoff() {
        if (this.currentConsole != null) {
            this.operator.getLevel().m_5594_(null, this.currentConsole.m_58899_(), TRSoundRegistry.FLIGHT_FAIL_START.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        this.throttleStage = 0;
    }

    public boolean canEndFlight() {
        return this.isInFlight && this.ticksInFlight >= 100 && this.ticksTakingOff <= 0 && (this.distanceCovered >= this.flightDistance || this.autoLand) && !this.isCrashing;
    }

    public void recalculateFlightDistance() {
        TardisNavLocation targetPosition = this.operator.getPilotingManager().getTargetLocation();
        TardisNavLocation lastKnownLocation = this.getCurrentLocation().copy();
        this.flightDistance = this.calculateFlightDistance(lastKnownLocation, targetPosition);
        this.operator.getFlightDanceManager().startFlightDance(this.currentConsole);
    }

    public int calculateFlightDistance(TardisNavLocation startingPoint, TardisNavLocation endingPoint) {
        BlockPos startingPointPos = startingPoint.getPosition();
        BlockPos endingPointPos = endingPoint.getPosition();
        int distance = 1000;
        if (startingPointPos != null && endingPointPos != null && startingPointPos != BlockPos.f_121853_ && endingPointPos != BlockPos.f_121853_) {
            distance = startingPointPos.m_123333_((Vec3i)endingPointPos);
        }
        if (startingPoint.getLevel() != endingPoint.getLevel()) {
            distance += 500 + this.operator.getLevel().f_46441_.m_188503_(250);
        }
        return distance;
    }

    public boolean endFlight(boolean forceFlightEnd, boolean isCrashing) {
        if (forceFlightEnd || this.canEndFlight()) {
            this.ticksInFlight = 0;
            this.ticksLanding = 180;
            TardisExteriorManager exteriorManager = this.operator.getExteriorManager();
            Level level = this.operator.getLevel();
            TardisNavLocation landingLocation = this.getTargetLocation();
            TardisNavLocation location = this.findClosestValidPosition(landingLocation);
            this.setTargetLocation(location);
            this.setCurrentLocation(location);
            exteriorManager.startLanding(this.operator, location);
            exteriorManager.playSoundAtShell(isCrashing ? TRSoundRegistry.TARDIS_CRASH_LAND.get() : TRSoundRegistry.TARDIS_LAND.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            if (this.currentConsole != null) {
                level.m_5594_(null, this.currentConsole.m_58899_(), isCrashing ? TRSoundRegistry.TARDIS_CRASH_LAND.get() : TRSoundRegistry.TARDIS_LAND.get(), SoundSource.AMBIENT, 10.0f, 1.0f);
            } else {
                level.m_5594_(null, TardisArchitectureHandler.DESKTOP_CENTER_POS, isCrashing ? TRSoundRegistry.TARDIS_CRASH_LAND.get() : TRSoundRegistry.TARDIS_LAND.get(), SoundSource.AMBIENT, 10.0f, 1.0f);
            }
            int totalPoints = (int)((float)this.distanceCovered * 0.05f);
            this.operator.getUpgradeHandler().addUpgradeXP(totalPoints);
            List players = level.m_6907_();
            for (Player player : players) {
                PlayerUtil.sendMessage((LivingEntity)player, (Component)Component.m_237115_((String)("+" + totalPoints + " XP")), true);
            }
            this.distanceCovered = 0;
            this.operator.tardisClientData().sync();
            return true;
        }
        return false;
    }

    private void endFlightEarly(boolean dramatic) {
        BlockPos targetPosition = this.getTargetLocation().getPosition();
        BlockPos startingPosition = this.getCurrentLocation().getPosition();
        float percentage = this.getFlightPercentageCovered();
        float percentageX = (float)startingPosition.m_123341_() + (float)(targetPosition.m_123341_() - startingPosition.m_123341_()) * percentage;
        float percentageY = (float)startingPosition.m_123342_() + (float)(targetPosition.m_123342_() - startingPosition.m_123342_()) * percentage;
        float percentageZ = (float)startingPosition.m_123343_() + (float)(targetPosition.m_123343_() - startingPosition.m_123343_()) * percentage;
        TardisNavLocation newLocation = new TardisNavLocation(new BlockPos((int)percentageX, (int)percentageY, (int)percentageZ), this.getTargetLocation().getDirection(), percentage > 0.49f ? this.getTargetLocation().getLevel() : this.getCurrentLocation().getLevel());
        this.setTargetLocation(newLocation);
        if (dramatic) {
            for (Player player : this.operator.getLevel().m_6907_()) {
                MobEffectInstance mobEffectInstance = new MobEffectInstance(MobEffects.f_216964_, 180, 180, false, false);
                player.m_7292_(mobEffectInstance);
            }
            if (this.currentConsole != null) {
                this.operator.getLevel().m_254849_(null, (double)this.currentConsole.m_58899_().m_123341_(), (double)this.currentConsole.m_58899_().m_123342_(), (double)this.currentConsole.m_58899_().m_123343_(), 2.0f, Level.ExplosionInteraction.NONE);
            }
        }
        this.endFlight(true, false);
    }

    public void enterTimeVortex() {
        TardisNavLocation lastKnown = this.getCurrentLocation();
        this.operator.getExteriorManager().removeExteriorBlock();
        this.ticksTakingOff = 0;
        this.operator.getExteriorManager().setIsTakingOff(false);
        TardisCommonEvents.TAKE_OFF.invoker().onTakeOff(this.operator, (LevelAccessor)lastKnown.getLevel(), lastKnown.getPosition());
        if (this.currentConsole != null) {
            this.operator.getFlightDanceManager().startFlightDance(this.currentConsole);
        }
        this.operator.tardisClientData().sync();
    }

    public void onFlightEnd() {
        this.operator.getFlightDanceManager().stopDancing();
        this.isInFlight = false;
        this.ticksTakingOff = 0;
        this.autoLand = false;
        if (this.getFuel() < this.getMaximumFuel() * 0.1) {
            this.operator.getLevel().m_5594_(null, this.currentConsoleBlockPos, TRSoundRegistry.LOW_FUEL.get(), SoundSource.AMBIENT, 1000.0f, 1.0f);
        }
        TardisCommonEvents.LAND.invoker().onLand(this.operator, (LevelAccessor)this.getTargetLocation().getLevel(), this.getTargetLocation().getPosition());
        this.operator.tardisClientData().sync();
    }

    public void crash() {
        this.canUseControls = false;
        this.isCrashing = true;
        this.ticksCrashing = 160;
        this.throttleStage = 0;
        this.setHandbrakeOn(true);
        TardisExteriorManager tardisExteriorManager = this.operator.getExteriorManager();
        Level tarisLevel = this.operator.getLevel();
        for (Player player : this.operator.getLevel().m_6907_()) {
            MobEffectInstance mobEffectInstance = new MobEffectInstance(MobEffects.f_216964_, 60, 60, false, false);
            player.m_7292_(mobEffectInstance);
        }
        if (this.getTargetLocation().getLevel().m_46472_() == Level.f_46430_) {
            this.getTargetLocation().setLevel(this.operator.getLevel().m_7654_().m_129783_());
        }
        float progress = this.getFlightPercentageCovered();
        Vec3 targetPos = this.getTargetLocation().getPosition().m_252807_();
        BlockPos currentLoc = this.getCurrentLocation().getPosition();
        Vec3 currentPos = new Vec3((double)currentLoc.m_123341_(), (double)currentLoc.m_123342_(), (double)currentLoc.m_123343_());
        int x = (int)(currentPos.f_82479_ + (targetPos.f_82479_ - currentPos.f_82479_) * (double)progress);
        int y = (int)(currentPos.f_82480_ + (targetPos.f_82480_ - currentPos.f_82480_) * (double)progress);
        int z = (int)(currentPos.f_82481_ + (targetPos.f_82481_ - currentPos.f_82481_) * (double)progress);
        BlockPos landingLocation = new BlockPos(x, y, z);
        this.setTargetPosition(landingLocation);
        TardisNavLocation weWantToGoHere = this.getTargetLocation().copy();
        TardisNavLocation safeLocation = this.findClosestValidPosition(weWantToGoHere);
        this.setTargetLocation(safeLocation);
        this.setCurrentLocation(safeLocation);
        this.endFlight(true, true);
        tardisExteriorManager.playSoundAtShell(TRSoundRegistry.TARDIS_CRASH_LAND.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        tarisLevel.m_5594_(null, TardisArchitectureHandler.DESKTOP_CENTER_POS, TRSoundRegistry.TARDIS_CRASH_LAND.get(), SoundSource.BLOCKS, 10.0f, 1.0f);
        this.operator.tardisClientData().sync();
    }

    public void onCrashEnd() {
        this.isCrashing = false;
        this.ticksCrashing = 0;
        this.ticksinCrashRecovery = 1;
        this.onFlightEnd();
        TardisCommonEvents.TARDIS_CRASH_EVENT.invoker().onTardisCrash(this.operator, this.getTargetLocation());
    }

    public float getFlightPercentageCovered() {
        if (this.flightDistance == 0) {
            return 0.0f;
        }
        return (float)this.distanceCovered / (float)this.flightDistance;
    }

    public void offsetTargetPositionX(int x) {
        this.getTargetLocation().setPosition(this.getTargetLocation().getPosition().m_7918_(x, 0, 0));
    }

    public void offsetTargetPositionY(int y) {
        this.getTargetLocation().setPosition(this.getTargetLocation().getPosition().m_7918_(0, y, 0));
    }

    public void offsetTargetPositionZ(int z) {
        this.getTargetLocation().setPosition(this.getTargetLocation().getPosition().m_7918_(0, 0, z));
    }

    public TardisNavLocation getTargetLocation() {
        return this.targetLocation;
    }

    public void setTargetLocation(TardisNavLocation targetLocation) {
        this.targetLocation = targetLocation.copy();
    }

    public TardisNavLocation getFastReturnLocation() {
        return this.fastReturnLocation;
    }

    public TardisNavLocation getCurrentLocation() {
        return Objects.requireNonNullElse(this.currentLocation, TardisNavLocation.ORIGIN);
    }

    public void setCurrentLocation(TardisNavLocation currentLocation) {
        this.currentLocation = currentLocation.copy();
    }

    public void setTargetPosition(BlockPos pos) {
        this.targetLocation.setPosition(pos);
    }

    public void setTargetDimension(ServerLevel serverLevel) {
        this.targetLocation.setLevel(serverLevel);
    }

    public int getCordIncrement() {
        return this.getCoordinateIncrements(this.operator.getUpgradeHandler())[this.cordIncrementIndex];
    }

    public void cycleCordIncrement(int direction) {
        int nextIndex = this.cordIncrementIndex + direction;
        int[] coordinateIncrements = this.getCoordinateIncrements(this.operator.getUpgradeHandler());
        if (nextIndex < 0) {
            nextIndex = coordinateIncrements.length - 1;
        }
        if (nextIndex >= coordinateIncrements.length) {
            nextIndex = 0;
        }
        this.cordIncrementIndex = nextIndex;
    }

    public int[] getCoordinateIncrements(UpgradeHandler upgradeHandler) {
        ArrayList<Integer> increments = new ArrayList<Integer>(List.of(Integer.valueOf(1), Integer.valueOf(10), Integer.valueOf(100)));
        for (Map.Entry<ResourceKey<Upgrade>, Upgrade> entry : TRUpgrades.UPGRADE_DEFERRED_REGISTRY.entrySet()) {
            Upgrade upgrade = entry.getValue();
            if (!(upgrade instanceof IncrementUpgrade)) continue;
            IncrementUpgrade incrementUpgrade = (IncrementUpgrade)upgrade;
            if (!upgrade.isUnlocked(upgradeHandler)) continue;
            increments.add(incrementUpgrade.getIncrementAmount());
        }
        Collections.sort(increments);
        return increments.stream().mapToInt(Integer::intValue).toArray();
    }

    public int getThrottleStage() {
        return this.throttleStage;
    }

    public void setThrottleStage(int stage) {
        this.throttleStage = stage;
    }

    public boolean isInFlight() {
        return this.isInFlight;
    }

    public boolean isLanding() {
        return this.ticksLanding > 0;
    }

    public boolean isTakingOff() {
        return this.ticksTakingOff > 0;
    }

    public boolean canUseControls() {
        return this.canUseControls;
    }

    public boolean isHandbrakeOn() {
        return this.isHandbrakeOn;
    }

    public void setHandbrakeOn(boolean handbrakeOn) {
        this.isHandbrakeOn = handbrakeOn;
    }

    public void setAutoLand(boolean autoLand) {
        this.autoLand = autoLand;
    }

    public boolean isAutoLandSet() {
        return this.autoLand;
    }

    public boolean isInRecovery() {
        return this.ticksinCrashRecovery > 0;
    }

    public GlobalConsoleBlockEntity getCurrentConsole() {
        BlockEntity blockEntity;
        if (this.currentConsole == null && this.currentConsoleBlockPos != null && (blockEntity = this.operator.getLevel().m_7702_(this.currentConsoleBlockPos)) instanceof GlobalConsoleBlockEntity) {
            GlobalConsoleBlockEntity globalConsoleBlockEntity;
            this.currentConsole = globalConsoleBlockEntity = (GlobalConsoleBlockEntity)blockEntity;
        }
        return this.currentConsole;
    }

    public void setCurrentConsole(GlobalConsoleBlockEntity newConsole) {
        GlobalConsoleBlockEntity updated;
        ConsolePattern oldPattern;
        BlockEntity oldTheme;
        GlobalConsoleBlockEntity consoleBlockEntity;
        BlockEntity blockEntity;
        Level level;
        if (this.currentConsole != null && (level = this.currentConsole.m_58904_()).m_8055_(this.currentConsole.m_58899_()).m_60734_() instanceof GlobalConsoleBlock && (blockEntity = level.m_7702_(this.currentConsole.m_58899_())) instanceof GlobalConsoleBlockEntity) {
            consoleBlockEntity = (GlobalConsoleBlockEntity)blockEntity;
            oldTheme = consoleBlockEntity.theme();
            oldPattern = consoleBlockEntity.pattern();
            level.m_7731_(this.currentConsole.m_58899_(), (BlockState)this.currentConsole.m_58900_().m_61124_((Property)GlobalConsoleBlock.POWERED, (Comparable)Boolean.valueOf(false)), 3);
            updated = (GlobalConsoleBlockEntity)level.m_7702_(this.currentConsole.m_58899_());
            updated.setConsoleTheme((ResourceLocation)oldTheme);
            updated.setPattern(oldPattern);
            updated.sendUpdates();
        }
        this.currentConsole = newConsole;
        this.currentConsoleBlockPos = newConsole.m_58899_();
        level = this.currentConsole.m_58904_();
        if (level.m_8055_(this.currentConsole.m_58899_()).m_60734_() instanceof GlobalConsoleBlock && (oldTheme = level.m_7702_(this.currentConsole.m_58899_())) instanceof GlobalConsoleBlockEntity) {
            consoleBlockEntity = (GlobalConsoleBlockEntity)oldTheme;
            oldTheme = consoleBlockEntity.theme();
            oldPattern = consoleBlockEntity.pattern();
            level.m_7731_(this.currentConsoleBlockPos, (BlockState)this.currentConsole.m_58900_().m_61124_((Property)GlobalConsoleBlock.POWERED, (Comparable)Boolean.valueOf(true)), 3);
            updated = (GlobalConsoleBlockEntity)level.m_7702_(this.currentConsoleBlockPos);
            updated.setConsoleTheme((ResourceLocation)oldTheme);
            updated.setPattern(oldPattern);
            updated.sendUpdates();
            level.m_5594_(null, this.currentConsoleBlockPos, TRSoundRegistry.CONSOLE_POWER_ON.get(), SoundSource.BLOCKS, 2.0f, 1.0f);
        }
    }

    public int getCrashRecoveryTicks() {
        return this.ticksinCrashRecovery;
    }

    public float getCooldownDuration() {
        return (float)this.ticksinCrashRecovery / 12000.0f;
    }

    public boolean isCrashing() {
        return this.isCrashing;
    }

    public double getFuel() {
        return this.fuel;
    }

    public void setFuel(double fuel) {
        double previous = this.fuel;
        this.fuel = Mth.m_14008_((double)fuel, (double)0.0, (double)this.getMaximumFuel());
        if (this.isOutOfFuel() && previous > 0.0) {
            this.onRunOutOfFuel();
            return;
        }
        if (!this.isOutOfFuel() && previous == 0.0) {
            this.onRestoreFuel();
            return;
        }
    }

    public double getMaximumFuel() {
        return this.maximumFuel;
    }

    private double getFlightFuelCost() {
        return 0.5;
    }

    public float getFuelPercentage() {
        return (float)this.fuel / (float)this.getMaximumFuel();
    }

    public boolean isOutOfFuel() {
        return this.fuel == 0.0;
    }

    public void removeFuel(double amount) {
        this.setFuel(Math.max(0.0, this.fuel - amount));
    }

    public boolean isPassivelyRefuelling() {
        return this.isPassivelyRefuelling;
    }

    public boolean setPassivelyRefuelling(boolean refuel) {
        if (this.isInFlight() || !this.canUseControls()) {
            return false;
        }
        this.isPassivelyRefuelling = refuel;
        return true;
    }

    public double addFuel(double amount) {
        this.setFuel(Math.min(this.getMaximumFuel(), this.fuel + amount));
        double remainder = this.fuel - this.getMaximumFuel();
        return Math.max(0.0, remainder);
    }

    private void onRunOutOfFuel() {
        this.operator.tardisClientData().sync();
        this.operator.getLevel().m_5594_(null, TardisArchitectureHandler.DESKTOP_CENTER_POS, SoundEvents.f_11738_, SoundSource.BLOCKS, 1000.0f, 0.6f);
    }

    private void onRestoreFuel() {
        this.operator.tardisClientData().sync();
        this.operator.getLevel().m_5594_(null, TardisArchitectureHandler.DESKTOP_CENTER_POS, SoundEvents.f_11736_, SoundSource.BLOCKS, 1000.0f, 0.6f);
    }

    private int getLatestSpeedModifier() {
        UpgradeHandler upgradeHandler = this.operator.getUpgradeHandler();
        this.speedModifier = TRUpgrades.UPGRADE_DEFERRED_REGISTRY.entrySet().stream().map(Map.Entry::getValue).filter(upgrade -> upgrade instanceof SpeedUpgrade).map(upgrade -> (SpeedUpgrade)upgrade).filter(upgradeHandler::isUpgradeUnlocked).mapToInt(SpeedUpgrade::getSpeedModifier).max().orElse(1);
        return this.speedModifier;
    }
}

