/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.common.tardis.manager;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.entity.BlockEntity;
import whocraft.tardis_refined.common.blockentity.shell.ExteriorShell;
import whocraft.tardis_refined.common.blockentity.shell.GlobalShellBlockEntity;
import whocraft.tardis_refined.common.capability.tardis.TardisLevelOperator;
import whocraft.tardis_refined.common.tardis.TardisNavLocation;
import whocraft.tardis_refined.common.tardis.manager.BaseHandler;
import whocraft.tardis_refined.common.tardis.manager.TardisPilotingManager;

public class TardisExteriorManager
extends BaseHandler {
    private final TardisLevelOperator operator;
    private double fuelForShellChange = 15.0;
    private boolean locked;
    private boolean isLanding;
    private boolean isTakingOff;

    public TardisExteriorManager(TardisLevelOperator operator) {
        this.operator = operator;
    }

    public boolean locked() {
        return this.locked;
    }

    public void setLocked(boolean locked) {
        TardisPilotingManager pilotingManager = this.operator.getPilotingManager();
        this.locked = locked;
        if (pilotingManager != null) {
            BlockEntity extShellBlockEntity;
            BlockPos extPos;
            if (pilotingManager.isInFlight()) {
                return;
            }
            TardisNavLocation currentLocation = pilotingManager.getCurrentLocation();
            ServerLevel level = currentLocation.getLevel();
            if (level.m_7702_(extPos = currentLocation.getPosition()) != null && (extShellBlockEntity = level.m_7702_(extPos)) instanceof ExteriorShell) {
                ExteriorShell exteriorShell = (ExteriorShell)extShellBlockEntity;
                exteriorShell.setLocked(locked);
            }
        }
    }

    public boolean isLanding() {
        return this.isLanding;
    }

    public boolean isTakingOff() {
        return this.isTakingOff;
    }

    public void setIsTakingOff(boolean isTakingOff) {
        this.isTakingOff = isTakingOff;
        this.operator.tardisClientData().setIsTakingOff(true);
        this.operator.tardisClientData().sync();
    }

    @Override
    public CompoundTag saveData(CompoundTag tag) {
        tag.m_128379_("terd_locked", this.locked);
        return tag;
    }

    @Override
    public void loadData(CompoundTag tag) {
        this.locked = tag.m_128471_("terd_locked");
    }

    public void playSoundAtShell(SoundEvent event, SoundSource source, float volume, float pitch) {
        TardisPilotingManager pilotingManager = this.operator.getPilotingManager();
        if (pilotingManager != null && pilotingManager.getCurrentLocation() != null) {
            TardisNavLocation currentLocation = pilotingManager.getCurrentLocation();
            ServerLevel lastKnownLocationLevel = currentLocation.getLevel();
            lastKnownLocationLevel.m_5594_(null, currentLocation.getPosition(), event, source, volume, pitch);
        }
    }

    public void setDoorClosed(boolean closeDoor) {
        TardisNavLocation currentPosition = this.operator.getPilotingManager().getCurrentLocation();
        if (currentPosition == null) {
            return;
        }
        ServerLevel lastKnownLocationLevel = currentPosition.getLevel();
        BlockEntity blockEntity = lastKnownLocationLevel.m_7702_(currentPosition.getPosition());
        if (blockEntity instanceof ExteriorShell) {
            ExteriorShell exteriorShell = (ExteriorShell)blockEntity;
            exteriorShell.setClosed(closeDoor);
        }
    }

    public void removeExteriorBlock() {
        this.isLanding = false;
        TardisPilotingManager pilotingManager = this.operator.getPilotingManager();
        if (pilotingManager == null) {
            return;
        }
        TardisNavLocation currentPosition = this.operator.getPilotingManager().getCurrentLocation();
        if (currentPosition != null) {
            BlockPos lastKnownLocationPosition = currentPosition.getPosition();
            ServerLevel lastKnownLocationLevel = currentPosition.getLevel();
            ChunkPos chunkPos = lastKnownLocationLevel.m_46865_(lastKnownLocationPosition).m_7697_();
            lastKnownLocationLevel.m_8602_(chunkPos.f_45578_, chunkPos.f_45579_, true);
            BlockEntity blockEntity = lastKnownLocationLevel.m_7702_(lastKnownLocationPosition);
            if (blockEntity instanceof GlobalShellBlockEntity) {
                GlobalShellBlockEntity globalShellBlockEntity = (GlobalShellBlockEntity)blockEntity;
                lastKnownLocationLevel.m_7471_(lastKnownLocationPosition, false);
            }
            lastKnownLocationLevel.m_8602_(chunkPos.f_45578_, chunkPos.f_45579_, false);
        }
    }

    public void startLanding(TardisLevelOperator operator, TardisNavLocation location) {
        ServerLevel targetLevel = location.getLevel();
        BlockPos lastKnownLocationPosition = location.getPosition();
        ChunkPos chunkPos = location.getLevel().m_46865_(lastKnownLocationPosition).m_7697_();
        this.isLanding = true;
        targetLevel.m_8602_(chunkPos.f_45578_, chunkPos.f_45579_, true);
        this.isLanding = true;
        operator.tardisClientData().setIsLanding(true);
        operator.tardisClientData().sync();
        this.placeExteriorBlockForLanding(location);
        targetLevel.m_8602_(chunkPos.f_45578_, chunkPos.f_45579_, false);
    }

    public void placeExteriorBlockForLanding(TardisNavLocation location) {
        this.operator.setOrUpdateExteriorBlock(location, Optional.empty());
    }

    public boolean hasEnoughFuelForShellChange() {
        return this.operator.getPilotingManager().getFuel() >= this.getFuelForShellChange();
    }

    public double getFuelForShellChange() {
        return this.fuelForShellChange;
    }

    private void setFuelForShellChange(double fuel) {
        this.fuelForShellChange = fuel;
    }
}

