/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.common.tardis.manager;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import whocraft.tardis_refined.TardisRefined;
import whocraft.tardis_refined.client.TardisClientData;
import whocraft.tardis_refined.common.VortexRegistry;
import whocraft.tardis_refined.common.blockentity.door.GlobalDoorBlockEntity;
import whocraft.tardis_refined.common.blockentity.shell.GlobalShellBlockEntity;
import whocraft.tardis_refined.common.capability.tardis.TardisLevelOperator;
import whocraft.tardis_refined.common.tardis.TardisNavLocation;
import whocraft.tardis_refined.common.tardis.manager.BaseHandler;
import whocraft.tardis_refined.common.tardis.themes.ShellTheme;
import whocraft.tardis_refined.patterns.ShellPattern;
import whocraft.tardis_refined.patterns.ShellPatterns;

public class AestheticHandler
extends BaseHandler {
    private final TardisLevelOperator tardisOperator;
    private ResourceLocation shellTheme = ShellTheme.HALF_BAKED.getId();
    private ResourceLocation vortex = VortexRegistry.FLOW.getId();
    private ShellPattern shellPattern = ShellPatterns.DEFAULT;

    public AestheticHandler(TardisLevelOperator tardisLevelOperator) {
        this.tardisOperator = tardisLevelOperator;
    }

    public ShellPattern shellPattern() {
        return this.shellPattern;
    }

    public void setShellPattern(ShellPattern shellPattern) {
        this.shellPattern = shellPattern;
    }

    public ResourceLocation getShellTheme() {
        if (this.shellTheme.m_135827_().contains("minecraft")) {
            return ShellTheme.HALF_BAKED.getId();
        }
        return this.shellTheme;
    }

    public ResourceLocation getVortex() {
        return this.vortex;
    }

    public void setVortex(ResourceLocation vortex) {
        this.vortex = vortex;
    }

    public boolean setShellTheme(ResourceLocation theme, ResourceLocation shellPattern, TardisNavLocation tardisNavLocation) {
        this.setShellPattern(ShellPatterns.getPatternOrDefault(theme, shellPattern));
        this.shellTheme = theme;
        if (tardisNavLocation == null) {
            return false;
        }
        BlockPos lastKnownLocationPosition = tardisNavLocation.getPosition();
        ServerLevel lastKnownLocationLevel = tardisNavLocation.getLevel();
        this.updateShellBlock(theme, shellPattern, lastKnownLocationLevel, lastKnownLocationPosition);
        this.updateInteriorDoors(theme, shellPattern);
        return true;
    }

    private void updateInteriorDoors(ResourceLocation theme, ResourceLocation shellPattern) {
        if (this.tardisOperator.getInternalDoor() != null) {
            BlockPos internalDoorPos = this.tardisOperator.getInternalDoor().getDoorPosition();
            BlockEntity blockEntity = this.tardisOperator.getLevel().m_7702_(internalDoorPos);
            if (blockEntity instanceof GlobalDoorBlockEntity) {
                GlobalDoorBlockEntity doorBlockEntity = (GlobalDoorBlockEntity)blockEntity;
                doorBlockEntity.setShellTheme(theme);
                doorBlockEntity.setPattern(ShellPatterns.getPatternOrDefault(this.shellTheme, shellPattern));
                this.tardisOperator.setInternalDoor(doorBlockEntity);
                doorBlockEntity.sendUpdates();
            }
        }
    }

    private void updateShellBlock(ResourceLocation theme, ResourceLocation shellPattern, ServerLevel lastKnownLocationLevel, BlockPos lastKnownLocationPosition) {
        BlockEntity shellBlockEntity = lastKnownLocationLevel.m_7702_(lastKnownLocationPosition);
        if (shellBlockEntity instanceof GlobalShellBlockEntity) {
            GlobalShellBlockEntity entity = (GlobalShellBlockEntity)shellBlockEntity;
            entity.setTardisId((ResourceKey<Level>)this.tardisOperator.getLevel().m_46472_());
            entity.setShellTheme(theme);
            entity.setPattern(ShellPatterns.getPatternOrDefault(theme, shellPattern));
            entity.sendUpdates();
            entity.m_6596_();
        }
    }

    @Override
    public CompoundTag saveData(CompoundTag baseTag) {
        CompoundTag aestheticTag = new CompoundTag();
        CompoundTag shellInfo = new CompoundTag();
        if (this.shellTheme != null) {
            shellInfo.m_128359_("terd_current_theme", this.shellTheme.toString());
        }
        if (this.shellPattern != null) {
            shellInfo.m_128359_("terd_current_pattern", this.shellPattern.id().toString());
        }
        aestheticTag.m_128365_("shell", (Tag)shellInfo);
        shellInfo.m_128359_("vortex", this.vortex.toString());
        baseTag.m_128365_("aesthetic", (Tag)aestheticTag);
        return baseTag;
    }

    @Override
    public void loadData(CompoundTag tag) {
        boolean needsDataFixed = false;
        if (tag.m_128441_("aesthetic")) {
            CompoundTag aestheticTag = tag.m_128469_("aesthetic");
            if (aestheticTag.m_128441_("vortex")) {
                this.vortex = new ResourceLocation(aestheticTag.m_128461_("vortex"));
            }
            if (aestheticTag.m_128441_("shell")) {
                ResourceLocation currentPattern;
                CompoundTag shellInfo = aestheticTag.m_128469_("shell");
                if (shellInfo.m_128441_("terd_current_theme")) {
                    ResourceLocation themeId = new ResourceLocation(shellInfo.m_128461_("terd_current_theme"));
                    ShellTheme theme = ShellTheme.SHELL_THEME_DEFERRED_REGISTRY.get(themeId);
                    if (theme == null) {
                        TardisRefined.LOGGER.info("The shell theme: {} does not exist! Resetting Shell Theme & Pattern for {}", (Object)themeId, (Object)this.tardisOperator.getLevel().m_46472_());
                        needsDataFixed = true;
                        this.shellTheme = ShellTheme.FACTORY.getId();
                        TardisClientData clientData = this.tardisOperator.tardisClientData();
                        clientData.setShellTheme(this.shellTheme);
                        clientData.sync();
                    } else {
                        this.shellTheme = themeId;
                    }
                }
                if (shellInfo.m_128441_("terd_current_pattern") && !needsDataFixed && ShellPatterns.doesPatternExist(this.shellTheme, currentPattern = new ResourceLocation(shellInfo.m_128461_("terd_current_pattern")))) {
                    this.shellPattern = ShellPatterns.getPatternOrDefault(this.shellTheme, currentPattern);
                    TardisClientData clientData = this.tardisOperator.tardisClientData();
                    clientData.setShellPattern(this.shellPattern.id());
                    clientData.sync();
                }
            }
        }
        if (this.shellTheme == null) {
            this.shellTheme = ShellTheme.FACTORY.getId();
        }
        if (this.shellPattern == null || needsDataFixed) {
            this.shellPattern = ShellPatterns.DEFAULT;
        }
    }
}

