/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.common.tardis.control;

import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import whocraft.tardis_refined.api.event.EventResult;
import whocraft.tardis_refined.api.event.TardisCommonEvents;
import whocraft.tardis_refined.common.blockentity.console.GlobalConsoleBlockEntity;
import whocraft.tardis_refined.common.capability.tardis.TardisLevelOperator;
import whocraft.tardis_refined.common.entity.ControlEntity;
import whocraft.tardis_refined.common.tardis.control.ControlSpecification;
import whocraft.tardis_refined.common.tardis.themes.ConsoleTheme;
import whocraft.tardis_refined.patterns.ConsolePattern;
import whocraft.tardis_refined.patterns.ConsolePatterns;
import whocraft.tardis_refined.patterns.sound.ConfiguredSound;

public abstract class Control {
    protected final ResourceLocation id;
    protected final String langId;
    private boolean isCriticalForTardisOperation = false;
    private boolean canBeUsedPostCrash = false;
    private ConfiguredSound successSound = new ConfiguredSound(SoundEvents.f_11686_);
    private ConfiguredSound failSound = new ConfiguredSound(SoundEvents.f_12018_);

    protected Control(ResourceLocation id, String langId, boolean isCriticalForTardisOperation) {
        this.id = id;
        this.langId = langId;
        this.isCriticalForTardisOperation = isCriticalForTardisOperation;
    }

    protected Control(ResourceLocation id, String langId) {
        this(id, langId, false);
    }

    protected Control(ResourceLocation id, boolean isCriticalForTardisOperation) {
        this(id, Util.m_137492_((String)"control", (ResourceLocation)id), isCriticalForTardisOperation);
    }

    protected Control(ResourceLocation id) {
        this(id, false);
    }

    public abstract boolean onLeftClick(TardisLevelOperator var1, ConsoleTheme var2, ControlEntity var3, Player var4);

    public abstract boolean onRightClick(TardisLevelOperator var1, ConsoleTheme var2, ControlEntity var3, Player var4);

    public ConfiguredSound getFailSound(TardisLevelOperator operator, ConsoleTheme theme, boolean leftClick) {
        return this.failSound;
    }

    public void setFailSound(ConfiguredSound failSound) {
        this.failSound = failSound;
    }

    public ConfiguredSound getSuccessSound(TardisLevelOperator operator, ConsoleTheme theme, boolean leftClick) {
        ConfiguredSound pitchedSound;
        ConsolePattern pattern = ConsolePatterns.DEFAULT;
        GlobalConsoleBlockEntity consoleBlockEntity = operator.getPilotingManager().getCurrentConsole();
        if (consoleBlockEntity != null) {
            pattern = consoleBlockEntity.pattern();
        }
        ConfiguredSound configuredSound = pitchedSound = leftClick ? pattern.soundProfile().get().getGeneric().leftClick() : pattern.soundProfile().get().getGeneric().rightClick();
        if (pitchedSound != null) {
            this.successSound = pitchedSound;
        }
        return this.successSound;
    }

    public void setSuccessSound(ConfiguredSound successSound) {
        this.successSound = successSound;
    }

    public void playControlConfiguredSound(TardisLevelOperator operator, ControlEntity controlEntity, ConfiguredSound pitchedSound, SoundSource source, float volume, float pitch, boolean ignorePitch) {
        controlEntity.m_9236_().m_5594_(null, controlEntity.m_20183_(), pitchedSound.getSoundEvent(), source, volume, ignorePitch ? pitch : pitchedSound.getPitch());
    }

    public void playControlConfiguredSound(TardisLevelOperator operator, ControlEntity controlEntity, ConfiguredSound pitchedSound, float pitch) {
        this.playControlConfiguredSound(operator, controlEntity, pitchedSound, SoundSource.BLOCKS, pitchedSound.getVolume(), pitch, true);
    }

    public void playControlConfiguredSound(TardisLevelOperator operator, ControlEntity controlEntity, ConfiguredSound pitchedSound) {
        this.playControlConfiguredSound(operator, controlEntity, pitchedSound, SoundSource.BLOCKS, 1.0f, 1.0f, false);
    }

    public boolean canUseControl(TardisLevelOperator tardisLevelOperator, Control control, ControlEntity controlEntity) {
        boolean isDeskopWaiting = controlEntity.isDesktopWaitingToGenerate(tardisLevelOperator);
        return !isDeskopWaiting && TardisCommonEvents.PLAYER_CONTROL_INTERACT.invoker().canControlBeUsed(tardisLevelOperator, control, controlEntity) == EventResult.pass();
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public String getTranslationKey() {
        return this.langId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Control control = (Control)o;
        return this.getId().equals((Object)control.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public boolean hasCustomName() {
        return false;
    }

    public Component getCustomControlName(TardisLevelOperator operator, ControlEntity entity, ControlSpecification controlSpecification) {
        return Component.m_237115_((String)controlSpecification.control().getTranslationKey());
    }

    public Control setCanBeUsedPostCrash(boolean canBeUsedPostCrash) {
        this.canBeUsedPostCrash = canBeUsedPostCrash;
        return this;
    }

    public boolean canBeUsedPostCrash() {
        return this.canBeUsedPostCrash;
    }

    public boolean isCriticalForTardisOperation() {
        return this.isCriticalForTardisOperation;
    }

    public Control setCriticalForTardisOperation(boolean criticalForTardisOperation) {
        this.isCriticalForTardisOperation = criticalForTardisOperation;
        return this;
    }
}

