/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.common.tardis;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.AABB;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import whocraft.tardis_refined.common.block.door.BulkHeadDoorBlock;
import whocraft.tardis_refined.common.blockentity.door.TardisInternalDoor;
import whocraft.tardis_refined.common.capability.tardis.TardisLevelOperator;
import whocraft.tardis_refined.common.entity.ControlEntity;
import whocraft.tardis_refined.common.tardis.TardisDesktops;
import whocraft.tardis_refined.common.tardis.themes.DesktopTheme;
import whocraft.tardis_refined.constants.TardisDimensionConstants;
import whocraft.tardis_refined.registry.TRBlockRegistry;

public class TardisArchitectureHandler {
    public static Logger LOGGER = LogManager.getLogger((String)"TardisRefined/TardisArchitectureHandler");
    public static final BlockPos DESKTOP_CENTER_POS = new BlockPos(0, 100, 0);
    public static final BlockPos EYE_OF_HARMONY_PLACEMENT = new BlockPos(991, 41, 31);
    public static String currentArsStage = "one";

    public static void generateDesktop(ServerLevel operator, DesktopTheme theme) {
        LOGGER.debug("Attempting to generate desktop theme: {} for TARDIS.", (Object)theme.getIdentifier());
        BlockPos corner = new BlockPos(TardisDimensionConstants.TARDIS_CENTER_POS.m_123341_() - TardisDimensionConstants.DESKTOP_RADIUS, TardisDimensionConstants.TARDIS_ROOT_GENERATION_MIN_HEIGHT.intValue(), TardisDimensionConstants.TARDIS_CENTER_POS.m_123343_() - TardisDimensionConstants.DESKTOP_RADIUS);
        BlockPos farCorner = new BlockPos(TardisDimensionConstants.TARDIS_CENTER_POS.m_123341_() + TardisDimensionConstants.DESKTOP_RADIUS, TardisDimensionConstants.TARDIS_ROOT_GENERATION_MAX_HEIGHT.intValue(), TardisDimensionConstants.TARDIS_CENTER_POS.m_123343_() + TardisDimensionConstants.DESKTOP_RADIUS);
        if (theme != TardisDesktops.DEFAULT_OVERGROWN_THEME) {
            for (BlockPos pos : BlockPos.m_121940_((BlockPos)corner, (BlockPos)farCorner)) {
                if (operator.m_8055_(pos) == TRBlockRegistry.FOOLS_STONE.get().m_49966_()) continue;
                operator.m_7731_(pos, TRBlockRegistry.FOOLS_STONE.get().m_49966_(), 3);
            }
        }
        List itemEntities = operator.m_6018_().m_45976_(ItemEntity.class, new AABB(corner, farCorner));
        List controlEntities = operator.m_6018_().m_45976_(ControlEntity.class, new AABB(corner, farCorner));
        ArrayList entitiesForDeath = new ArrayList(itemEntities);
        entitiesForDeath.addAll(controlEntities);
        entitiesForDeath.forEach(Entity::m_146870_);
        Optional structureNBT = operator.m_6018_().m_215082_().m_230407_(theme.getStructureLocation());
        structureNBT.ifPresent(structure -> {
            BlockPos offsetPosition = TardisArchitectureHandler.calculateArcOffset(structure, DESKTOP_CENTER_POS);
            structure.m_230328_((ServerLevelAccessor)operator.m_6018_(), offsetPosition, offsetPosition, new StructurePlaceSettings(), operator.m_6018_().f_46441_, 8);
            TardisArchitectureHandler.setInteriorDoorFromStructure(structure, operator);
            TardisArchitectureHandler.buildAirlockEntranceFromStructure(structure, operator);
        });
    }

    public static void buildAirlockEntranceFromStructure(StructureTemplate template, ServerLevel level) {
        BlockPos minPos = TardisArchitectureHandler.calculateArcOffset(template, DESKTOP_CENTER_POS);
        BlockPos maxPos = new BlockPos(minPos.m_123341_() + template.m_163801_().m_123341_(), minPos.m_123342_() + template.m_163801_().m_123342_(), minPos.m_123343_() + template.m_163801_().m_123343_());
        for (BlockPos pos : BlockPos.m_121940_((BlockPos)minPos, (BlockPos)maxPos)) {
            if (level.m_8055_(pos).m_60734_() != TRBlockRegistry.AIR_LOCK_GENERATION_BLOCK.get()) continue;
            TardisLevelOperator.get(level).ifPresent(cap -> {
                Optional structureNBT = level.m_6018_().m_215082_().m_230407_(new ResourceLocation("tardis_refined", "corridors/airlock_entrance"));
                structureNBT.ifPresent(structure -> {
                    BlockPos offsetPosition = new BlockPos(3, 2, 0);
                    structure.m_230328_((ServerLevelAccessor)level.m_6018_(), pos.m_121996_((Vec3i)offsetPosition), pos.m_121996_((Vec3i)offsetPosition), new StructurePlaceSettings(), level.m_6018_().f_46441_, 2);
                    cap.getInteriorManager().setCorridorAirlockCenter(pos.m_122020_(2));
                    level.m_7731_(pos, (BlockState)level.m_8055_(pos).m_61124_((Property)BulkHeadDoorBlock.LOCKED, (Comparable)Boolean.valueOf(false)), 2);
                });
            });
            return;
        }
    }

    public static void generateArsTree(TardisLevelOperator tardisLevelOperator, ServerLevel level) {
        if (!currentArsStage.equals("one") && Objects.equals(tardisLevelOperator.getUpgradeHandler().getProgressLevel(), currentArsStage)) {
            return;
        }
        currentArsStage = tardisLevelOperator.getUpgradeHandler().getProgressLevel();
        Optional structureNBT = level.m_6018_().m_215082_().m_230407_(new ResourceLocation("tardis_refined", "rooms/ars/room_ars_stage_" + currentArsStage));
        structureNBT.ifPresent(structure -> structure.m_230328_((ServerLevelAccessor)level.m_6018_(), TardisDimensionConstants.ARS_TREE_PLACEMENT_POS, TardisDimensionConstants.ARS_TREE_PLACEMENT_POS, new StructurePlaceSettings(), level.m_6018_().f_46441_, 3));
    }

    public static boolean setInteriorDoorFromStructure(StructureTemplate template, ServerLevel level) {
        BlockPos minPos = TardisArchitectureHandler.calculateArcOffset(template, DESKTOP_CENTER_POS);
        BlockPos maxPos = new BlockPos(minPos.m_123341_() + template.m_163801_().m_123341_(), minPos.m_123342_() + template.m_163801_().m_123342_(), minPos.m_123343_() + template.m_163801_().m_123343_());
        TardisLevelOperator.get(level).ifPresent(cap -> cap.setInternalDoor(null));
        for (BlockPos pos : BlockPos.m_121940_((BlockPos)minPos, (BlockPos)maxPos)) {
            BlockEntity blockEntity = level.m_7702_(pos);
            if (!(blockEntity instanceof TardisInternalDoor)) continue;
            TardisInternalDoor internalDoor = (TardisInternalDoor)blockEntity;
            TardisLevelOperator.get(level).ifPresent(cap -> cap.setInternalDoor(internalDoor));
            return true;
        }
        return false;
    }

    public static BlockPos calculateArcOffset(StructureTemplate structureTemplate, BlockPos centerPos) {
        return new BlockPos(centerPos.m_123341_() - structureTemplate.m_163801_().m_123341_() / 2, centerPos.m_123342_() - structureTemplate.m_163801_().m_123342_() / 2, centerPos.m_123343_() - structureTemplate.m_163801_().m_123343_() / 2);
    }
}

