/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.common.network.messages.waypoints;

import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import whocraft.tardis_refined.common.capability.tardis.TardisLevelOperator;
import whocraft.tardis_refined.common.network.MessageC2S;
import whocraft.tardis_refined.common.network.MessageContext;
import whocraft.tardis_refined.common.network.MessageType;
import whocraft.tardis_refined.common.network.TardisNetwork;
import whocraft.tardis_refined.common.tardis.TardisNavLocation;
import whocraft.tardis_refined.common.tardis.TardisWaypoint;
import whocraft.tardis_refined.common.tardis.manager.TardisPilotingManager;
import whocraft.tardis_refined.common.tardis.manager.TardisWaypointManager;
import whocraft.tardis_refined.common.util.PlayerUtil;
import whocraft.tardis_refined.constants.ModMessages;

public class C2STravelToWaypoint
extends MessageC2S {
    UUID waypointId;

    public C2STravelToWaypoint(UUID waypointId) {
        this.waypointId = waypointId;
    }

    public C2STravelToWaypoint(FriendlyByteBuf buf) {
        this.waypointId = buf.m_130259_();
    }

    @Override
    @NotNull
    public MessageType getType() {
        return TardisNetwork.SET_WAYPOINT;
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130077_(this.waypointId);
    }

    @Override
    public void handle(MessageContext context) {
        ServerPlayer player = context.getPlayer();
        ServerLevel serverLevel = player.m_284548_();
        TardisLevelOperator.get(serverLevel).ifPresent(tardisLevelOperator -> {
            TardisWaypointManager tardisWaypointManager = tardisLevelOperator.getTardisWaypointManager();
            TardisWaypoint waypoint = tardisWaypointManager.getWaypointById(this.waypointId);
            TardisNavLocation waypointLoc = waypoint.getLocation().copy();
            TardisPilotingManager pilotManager = tardisLevelOperator.getPilotingManager();
            pilotManager.setTargetLocation(waypointLoc);
            serverLevel.m_5594_((Player)player, BlockPos.m_274446_((Position)player.m_20182_()), SoundEvents.f_12444_, SoundSource.BLOCKS, 1.0f, 1.0f);
            PlayerUtil.sendMessage((LivingEntity)player, (Component)Component.m_237110_((String)ModMessages.WAYPOINT_LOADED, (Object[])new Object[]{waypointLoc.getName()}), true);
        });
    }
}

