/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.common.dimension;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import whocraft.tardis_refined.common.util.Platform;
import whocraft.tardis_refined.common.util.TRTeleporter;

public class TardisTeleportData {
    private static List<TeleportEntry> queuedTeleports = new ArrayList<TeleportEntry>();
    private static TardisTeleportData INSTANCE = new TardisTeleportData();

    public static void tick() {
        TardisTeleportData eventData = INSTANCE;
        MinecraftServer server = Platform.getServer();
        List<TeleportEntry> teleports = eventData.getQueuedTeleports();
        HashSet<Entity> teleportedEntities = new HashSet<Entity>();
        if (!teleports.isEmpty()) {
            for (TeleportEntry entry : teleports) {
                if (entry.getIsCurrentTeleporting() || entry.getSuccessfulTeleport()) continue;
                entry.setIsCurrentTeleporting(true);
                Entity entity = entry.getEntity();
                if (teleportedEntities.contains(entity)) continue;
                ServerLevel targetWorld = server.m_129880_(entry.getDestination());
                if (entity == null || targetWorld == null) continue;
                if (TRTeleporter.fullTeleport(entity, targetWorld, entry.getX(), entry.getY(), entry.getZ(), entry.getyRot(), entry.getxRot(), teleportedEntities)) {
                    teleportedEntities.add(entity);
                    entry.setSuccessfulTeleport(true);
                    continue;
                }
                entry.setSuccessfulTeleport(false);
            }
            teleports.removeIf(teleportEntry -> teleportedEntities.contains(teleportEntry.getEntity()) || !teleportEntry.getSuccessfulTeleport());
            queuedTeleports = teleports;
        }
    }

    public static void scheduleEntityTeleport(Entity entity, ResourceKey<Level> destination, double x, double y, double z, float yRot, float xRot) {
        if (entity != null && !entity.m_9236_().m_5776_() && !TardisTeleportData.isEntityQueuedToTeleportAlready(entity)) {
            queuedTeleports.add(new TeleportEntry(entity, destination, x, y, z, yRot, xRot));
        }
    }

    public static boolean isEntityQueuedToTeleportAlready(Entity entity) {
        return queuedTeleports.stream().anyMatch(entry -> entry.getEntity().equals((Object)entity));
    }

    public List<TeleportEntry> getQueuedTeleports() {
        return queuedTeleports;
    }

    private static final class TeleportEntry {
        private final Entity entity;
        private final ResourceKey<Level> destination;
        private final double x;
        private final double y;
        private final double z;
        private final float yRot;
        private final float xRot;
        private boolean isCurrentTeleporting = false;
        private boolean successfulTeleport = false;

        public TeleportEntry(Entity entity, ResourceKey<Level> destination, double x, double y, double z, float yRot, float xRot) {
            this.entity = entity;
            this.destination = destination;
            this.x = x;
            this.y = y;
            this.z = z;
            this.yRot = yRot;
            this.xRot = xRot;
        }

        public Entity getEntity() {
            return this.entity;
        }

        public ResourceKey<Level> getDestination() {
            return this.destination;
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        public double getZ() {
            return this.z;
        }

        public float getxRot() {
            return this.xRot;
        }

        public float getyRot() {
            return this.yRot;
        }

        public boolean getIsCurrentTeleporting() {
            return this.isCurrentTeleporting;
        }

        public void setIsCurrentTeleporting(boolean isCurrentTeleporting) {
            this.isCurrentTeleporting = isCurrentTeleporting;
        }

        public boolean getSuccessfulTeleport() {
            return this.successfulTeleport;
        }

        public void setSuccessfulTeleport(boolean successfulTeleport) {
            this.isCurrentTeleporting = successfulTeleport;
        }
    }
}

