/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.common.data;

import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.SoundDefinition;
import net.minecraftforge.common.data.SoundDefinitionsProvider;
import whocraft.tardis_refined.registry.TRSoundRegistry;

public class SoundProvider
extends SoundDefinitionsProvider {
    public SoundProvider(DataGenerator generator, ExistingFileHelper helper) {
        super(generator.getPackOutput(), "tardis_refined", helper);
    }

    public static String createSubtitle(String langKey) {
        return "sound." + langKey + ".subtitle";
    }

    public void registerSounds() {
        this.add(TRSoundRegistry.TARDIS_LAND.get(), this.basicSound("tardis_land", new ResourceLocation("tardis_refined", "tardis/tardis_land")));
        this.add(TRSoundRegistry.TARDIS_SINGLE_FLY.get(), this.basicSound("tardis_single_fly", new ResourceLocation("tardis_refined", "tardis/tardis_single_fly")));
        this.add(TRSoundRegistry.TARDIS_TAKEOFF.get(), this.basicSound("tardis_takeoff", new ResourceLocation("tardis_refined", "tardis/tardis_takeoff")));
        this.add(TRSoundRegistry.PATTERN_MANIPULATOR.get(), this.basicSound("pattern_manipulator", new ResourceLocation("tardis_refined", "gadgets/pattern_manipulator")));
        this.add(TRSoundRegistry.TIME_BLAST.get(), this.basicSound("time_blast", new ResourceLocation("tardis_refined", "tardis/time_blast")));
        this.add(TRSoundRegistry.TARDIS_CRASH_LAND.get(), this.basicSound("tardis_crash_land", new ResourceLocation("tardis_refined", "tardis/tardis_crash_land")));
        this.add(TRSoundRegistry.TARDIS_MISC_SPARKLE.get(), this.basicSound("tardis_misc_sparkle", new ResourceLocation("tardis_refined", "tardis/tardis_misc_sparkle")));
        this.add(TRSoundRegistry.STATIC.get(), this.basicSound("static", new ResourceLocation("tardis_refined", "ui/static")));
        this.add(TRSoundRegistry.DESTINATION_DING.get(), this.basicSound("destination_ding", new ResourceLocation("tardis_refined", "tardis/destination_ding")));
        this.add(TRSoundRegistry.ARS_HUM.get(), this.basicSound("ars_hum", new ResourceLocation("tardis_refined", "tardis/ars/ars_hum")));
        this.add(TRSoundRegistry.BULKHEAD_LOCKED.get(), this.basicSound("bulkhead_locked", new ResourceLocation("tardis_refined", "blocks/bulkhead_locked")));
        this.add(TRSoundRegistry.HUM_CORAL.get(), this.basicSound("hum_coral", new ResourceLocation("tardis_refined", "tardis/interior_hums/hum_coral")));
        this.add(TRSoundRegistry.HUM_CAVE.get(), this.basicSound("hum_cave", new ResourceLocation("tardis_refined", "tardis/interior_hums/hum_cave")));
        this.add(TRSoundRegistry.HUM_VICTORIAN.get(), this.basicSound("hum_victorian", new ResourceLocation("tardis_refined", "tardis/interior_hums/hum_victorian")));
        this.add(TRSoundRegistry.HUM_CLASSIC.get(), this.basicSound("hum_classic", new ResourceLocation("tardis_refined", "tardis/interior_hums/hum_classic")));
        this.add(TRSoundRegistry.HUM_TOYOTA.get(), this.basicSound("hum_toyota", new ResourceLocation("tardis_refined", "tardis/interior_hums/hum_toyota")));
        this.add(TRSoundRegistry.HUM_AVIATRAX.get(), this.basicSound("hum_aviatrax", new ResourceLocation("tardis_refined", "tardis/interior_hums/hum_aviatrax")));
        this.add(TRSoundRegistry.HUM_COPPER.get(), this.basicSound("hum_copper", new ResourceLocation("tardis_refined", "tardis/interior_hums/hum_copper")));
        this.add(TRSoundRegistry.INTERIOR_CREAKS.get(), this.basicSound("interior_creaks", new ResourceLocation("tardis_refined", "tardis/ambience/interior_creaks_1"), new ResourceLocation("tardis_refined", "tardis/ambience/interior_creaks_2"), new ResourceLocation("tardis_refined", "tardis/ambience/interior_creaks_3")));
        this.add(TRSoundRegistry.FLIGHT_FAIL_START.get(), this.basicSound("flight_fail_start", new ResourceLocation("tardis_refined", "tardis/flight_fail_start")));
        this.add(TRSoundRegistry.CONSOLE_POWER_ON.get(), this.basicSound("console_power_on", new ResourceLocation("tardis_refined", "tardis/console_power_on")));
        this.add(TRSoundRegistry.ALARM.get(), this.basicSound("alarm", new ResourceLocation("tardis_refined", "tardis/alarm")));
        this.add(TRSoundRegistry.SCREWDRIVER_SHORT.get(), this.basicSound("screwdriver_short", new ResourceLocation("tardis_refined", "tools/screwdriver/screwdriver_short")));
        this.add(TRSoundRegistry.SCREWDRIVER_CONNECT.get(), this.basicSound("screwdriver_connect", new ResourceLocation("tardis_refined", "tools/screwdriver/screwdriver_connect")));
        this.add(TRSoundRegistry.SCREWDRIVER_DISCARD.get(), this.basicSound("screwdriver_discard", new ResourceLocation("tardis_refined", "tools/screwdriver/screwdriver_discard")));
        this.add(TRSoundRegistry.GRAVITY_TUNNEL.get(), this.basicSound("gravity_tunnel", new ResourceLocation("tardis_refined", "gravity_tunnel")));
        this.add(TRSoundRegistry.INTERIOR_VOICE.get(), this.basicSound("interior_voice", new ResourceLocation("tardis_refined", "tardis/ambience/w1"), new ResourceLocation("tardis_refined", "tardis/ambience/w2"), new ResourceLocation("tardis_refined", "tardis/ambience/w3"), new ResourceLocation("tardis_refined", "tardis/ambience/w4")));
        this.add(TRSoundRegistry.LOW_FUEL.get(), this.basicSound("low_fuel", new ResourceLocation("tardis_refined", "tardis/low_fuel")));
        this.add(TRSoundRegistry.ARTRON_PILLAR_ACTIVE.get(), this.basicSound("artron_pillar", new ResourceLocation("tardis_refined", "blocks/artron_pillar_active")));
        this.add(TRSoundRegistry.CORRIDOR_TELEPORTER.get(), this.basicSound("corridor_teleporter", new ResourceLocation("tardis_refined", "blocks/corridor_teleporter")));
        this.add(TRSoundRegistry.CORRIDOR_TELEPORTER_SUCCESS.get(), this.basicSound("corridor_teleporter_success", new ResourceLocation("tardis_refined", "blocks/corridor_teleporter_success")));
        this.add(TRSoundRegistry.VORTEX.get(), this.basicSound("vortex", new ResourceLocation("tardis_refined", "tardis/vortex")));
        this.add(TRSoundRegistry.MALLET.get(), this.basicSound("mallet", new ResourceLocation("tardis_refined", "tools/mallet")));
        this.add(TRSoundRegistry.CLOISTER_BELL.get(), this.basicSound("cloister_bell", SoundDefinition.Sound.sound((ResourceLocation)new ResourceLocation("block/bell/resonate"), (SoundDefinition.SoundType)SoundDefinition.SoundType.SOUND).pitch(0.85), SoundDefinition.Sound.sound((ResourceLocation)new ResourceLocation("block/bell/resonate"), (SoundDefinition.SoundType)SoundDefinition.SoundType.SOUND).pitch(0.9)));
    }

    public SoundDefinition basicSound(String langKey, ResourceLocation resourceLocation) {
        return SoundDefinition.definition().with(SoundDefinition.Sound.sound((ResourceLocation)resourceLocation, (SoundDefinition.SoundType)SoundDefinition.SoundType.SOUND)).subtitle(SoundProvider.createSubtitle(langKey));
    }

    public SoundDefinition basicSound(String langKey, ResourceLocation ... resourceLocation) {
        SoundDefinition soundDefinition = SoundDefinition.definition();
        for (ResourceLocation location : resourceLocation) {
            soundDefinition.with(SoundDefinition.Sound.sound((ResourceLocation)location, (SoundDefinition.SoundType)SoundDefinition.SoundType.SOUND));
        }
        return soundDefinition.subtitle(SoundProvider.createSubtitle(langKey));
    }

    public SoundDefinition basicSound(String langKey, SoundDefinition.Sound ... resourceLocation) {
        SoundDefinition soundDefinition = SoundDefinition.definition();
        for (SoundDefinition.Sound sound : resourceLocation) {
            soundDefinition.with(sound);
        }
        return soundDefinition.subtitle(SoundProvider.createSubtitle(langKey));
    }
}

