/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.common.capability.tardis.forge;

import java.util.Optional;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import whocraft.tardis_refined.common.capability.tardis.TardisLevelOperator;
import whocraft.tardis_refined.registry.TRDimensionTypes;

@Mod.EventBusSubscriber(modid="tardis_refined")
public class TardisLevelOperatorImpl
implements ICapabilitySerializable<CompoundTag> {
    public static Capability<TardisLevelOperator> TARDIS_DATA = CapabilityManager.get((CapabilityToken)new CapabilityToken<TardisLevelOperator>(){});
    public final TardisLevelOperator operator;
    public final LazyOptional<TardisLevelOperator> lazyOptional;

    public TardisLevelOperatorImpl(ServerLevel level) {
        this.operator = new TardisLevelOperator((Level)level);
        this.lazyOptional = LazyOptional.of(() -> this.operator);
    }

    @SubscribeEvent
    public static void init(RegisterCapabilitiesEvent event) {
        event.register(TardisLevelOperator.class);
    }

    @SubscribeEvent
    public static void onLevelCapabilities(AttachCapabilitiesEvent<Level> event) {
        ServerLevel level;
        Object object = event.getObject();
        if (object instanceof ServerLevel && (level = (ServerLevel)object).m_220362_().m_135782_() == TRDimensionTypes.TARDIS.m_135782_()) {
            event.addCapability(new ResourceLocation("tardis_refined", "tardis_data"), (ICapabilityProvider)new TardisLevelOperatorImpl((ServerLevel)event.getObject()));
        }
    }

    @SubscribeEvent
    public static void onLevelTick(TickEvent.LevelTickEvent event) {
        Level level = event.level;
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            if (event.phase == TickEvent.Phase.START && event.level.m_220362_().m_135782_() == TRDimensionTypes.TARDIS.m_135782_()) {
                event.level.getCapability(TARDIS_DATA).ifPresent(x -> x.tick(level2));
            }
        }
    }

    public static Optional<TardisLevelOperator> get(ServerLevel level) {
        if (level == null) {
            return Optional.empty();
        }
        return level.getCapability(TARDIS_DATA).resolve();
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction arg) {
        return capability == TARDIS_DATA ? this.lazyOptional.cast() : LazyOptional.empty();
    }

    public CompoundTag serializeNBT() {
        return this.operator.serializeNBT();
    }

    public void deserializeNBT(CompoundTag arg) {
        this.operator.deserializeNBT(arg);
    }
}

