/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.common.capability.player.forge;

import java.util.Optional;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import whocraft.tardis_refined.common.capability.player.TardisPlayerInfo;

@Mod.EventBusSubscriber(modid="tardis_refined")
public class TardisPlayerInfoImpl {
    public static Capability<TardisPlayerInfo> TARDIS_PLAYER_INFO = CapabilityManager.get((CapabilityToken)new CapabilityToken<TardisPlayerInfo>(){});

    @SubscribeEvent
    public static void init(RegisterCapabilitiesEvent e) {
        e.register(TardisPlayerInfo.class);
    }

    @SubscribeEvent
    public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> e) {
        Object object = e.getObject();
        if (object instanceof Player) {
            Player player = (Player)object;
            e.addCapability(new ResourceLocation("tardis_refined", "tardis_player_info"), (ICapabilityProvider)new TardisPlayerInfoProvider(new TardisPlayerInfo(player)));
        }
    }

    public static Optional<TardisPlayerInfo> get(LivingEntity player) {
        return player.getCapability(TARDIS_PLAYER_INFO).resolve();
    }

    public static class TardisPlayerInfoProvider
    implements ICapabilitySerializable<CompoundTag> {
        public final TardisPlayerInfo capability;
        public final LazyOptional<TardisPlayerInfo> lazyOptional;

        public TardisPlayerInfoProvider(TardisPlayerInfo capability) {
            this.capability = capability;
            this.lazyOptional = LazyOptional.of(() -> capability);
        }

        @NotNull
        public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction arg) {
            return capability == TARDIS_PLAYER_INFO ? this.lazyOptional.cast() : LazyOptional.empty();
        }

        public CompoundTag serializeNBT() {
            return this.capability.saveData();
        }

        public void deserializeNBT(CompoundTag arg) {
            this.capability.loadData(arg);
        }
    }
}

