/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.common.blockentity.shell;

import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.Property;
import whocraft.tardis_refined.TardisRefined;
import whocraft.tardis_refined.common.block.shell.ShellBaseBlock;
import whocraft.tardis_refined.common.blockentity.shell.ExteriorShell;
import whocraft.tardis_refined.common.capability.tardis.TardisLevelOperator;
import whocraft.tardis_refined.common.capability.tardis.upgrades.UpgradeHandler;
import whocraft.tardis_refined.common.dimension.DimensionHandler;
import whocraft.tardis_refined.common.tardis.manager.AestheticHandler;
import whocraft.tardis_refined.common.tardis.manager.TardisPilotingManager;
import whocraft.tardis_refined.common.util.DimensionUtil;
import whocraft.tardis_refined.common.util.PlayerUtil;
import whocraft.tardis_refined.compat.ModCompatChecker;
import whocraft.tardis_refined.compat.portals.ImmersivePortals;
import whocraft.tardis_refined.constants.ModMessages;
import whocraft.tardis_refined.registry.TRUpgrades;

public abstract class ShellBaseBlockEntity
extends BlockEntity
implements ExteriorShell,
BlockEntityTicker<ShellBaseBlockEntity> {
    public AnimationState liveliness = new AnimationState();
    protected ResourceKey<Level> TARDIS_ID;
    private boolean hasPotentialToBeRemoved = false;

    public ShellBaseBlockEntity(BlockEntityType<?> blockEntityType, BlockPos blockPos, BlockState blockState) {
        super(blockEntityType, blockPos, blockState);
    }

    @Override
    public ResourceKey<Level> getTardisId() {
        return this.TARDIS_ID;
    }

    @Override
    public void setTardisId(ResourceKey<Level> levelKey) {
        this.TARDIS_ID = levelKey;
        this.m_6596_();
        this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        if (pTag.m_128441_("tardis_id")) {
            this.TARDIS_ID = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(pTag.m_128461_("tardis_id")));
        }
        this.updateCurrentLocation();
    }

    public void m_142339_(Level level) {
        super.m_142339_(level);
        this.updateCurrentLocation();
    }

    private void updateCurrentLocation() {
        Level level = this.m_58904_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ServerLevel interior = serverLevel.m_7654_().m_129880_(this.TARDIS_ID);
            TardisLevelOperator.get(interior).ifPresent(cap -> {
                cap.getPilotingManager().setCurrentLocationOnNextTick(this);
                this.hasPotentialToBeRemoved = true;
            });
        }
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = this.m_187480_();
        this.m_183515_(tag);
        return tag;
    }

    protected void m_183515_(CompoundTag pTag) {
        if (this.TARDIS_ID == null) {
            TardisRefined.LOGGER.error("Error in saveAdditional: null Tardis ID (Invalid block or not terraformed yet?) [" + this.m_58899_().m_123344_() + "]");
            return;
        }
        super.m_183515_(pTag);
        if (this.TARDIS_ID != null) {
            pTag.m_128359_("tardis_id", this.TARDIS_ID.m_135782_().toString());
        }
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public boolean shouldSetup() {
        if (!this.f_58857_.m_5776_()) {
            return this.TARDIS_ID == null;
        }
        return false;
    }

    @Override
    public void onAttemptEnter(BlockState blockState, Level level, BlockPos externalShellPos, Entity entity) {
        if (!entity.m_9236_().m_5776_() && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.TARDIS_ID == null) {
                TardisRefined.LOGGER.error("Error in onAttemptEnter: null Tardis ID (Invalid block or not terraformed yet?) [" + externalShellPos.m_123344_() + "]");
                return;
            }
            ServerLevel interior = DimensionHandler.getOrCreateInterior((Level)serverLevel, this.TARDIS_ID.m_135782_());
            TardisLevelOperator.get(interior).ifPresent(cap -> {
                UpgradeHandler upgradeHandler = cap.getUpgradeHandler();
                AestheticHandler aesthetics = cap.getAestheticHandler();
                if (cap.isTardisReady() && (((Boolean)blockState.m_61143_((Property)ShellBaseBlock.OPEN)).booleanValue() || cap.getPilotingManager().isLanding() && TRUpgrades.MATERIALIZE_AROUND.get().isUnlocked(upgradeHandler))) {
                    if (aesthetics.getShellTheme() != null) {
                        ResourceLocation theme = aesthetics.getShellTheme();
                        if (ModCompatChecker.immersivePortals() && ImmersivePortals.isShellThemeSupported(theme) && ImmersivePortals.doPortalsExistForTardis(UUID.fromString(this.TARDIS_ID.m_135782_().m_135815_()))) {
                            return;
                        }
                    }
                    cap.enterTardis(entity, this.m_58899_(), serverLevel, (Direction)blockState.m_61143_((Property)ShellBaseBlock.FACING));
                } else if (!cap.isTardisReady() && entity instanceof Player) {
                    Player player = (Player)entity;
                    PlayerUtil.sendMessage((LivingEntity)player, (Component)Component.m_237110_((String)ModMessages.MSG_EXTERIOR_COOLDOWN, (Object[])new Object[]{cap.getInteriorManager().getInteriorGenerationCooldown()}), true);
                }
            });
        }
    }

    public void tick(Level level, BlockPos blockPos, BlockState blockState, ShellBaseBlockEntity blockEntity) {
        if (!level.f_46443_) {
            ResourceKey<Level> tardisId = this.getTardisId();
            if (tardisId == null) {
                return;
            }
            ServerLevel tardisLevel = DimensionUtil.getLevel(tardisId);
            TardisLevelOperator.get(tardisLevel).ifPresent(tardisLevelOperator -> {
                if (!tardisLevelOperator.getPilotingManager().isInFlight() && this.isInvalidTardis((TardisLevelOperator)tardisLevelOperator)) {
                    BlockPos myCurrentPosition = this.m_58899_();
                    level.m_7471_(myCurrentPosition, false);
                }
            });
        }
    }

    @Override
    public boolean isOpen() {
        return (Boolean)this.m_58900_().m_61143_((Property)ShellBaseBlock.OPEN);
    }

    @Override
    public void setClosed(boolean closeDoor) {
        BlockPos blockPos = this.m_58899_();
        BlockState blockState = this.m_58904_().m_8055_(blockPos);
        Block block = blockState.m_60734_();
        if (block instanceof ShellBaseBlock) {
            ShellBaseBlock shellBaseBlock = (ShellBaseBlock)block;
            this.m_58904_().m_7731_(blockPos, (BlockState)blockState.m_61124_((Property)ShellBaseBlock.OPEN, (Comparable)Boolean.valueOf(!closeDoor)), 3);
            this.playDoorCloseSound(closeDoor);
            this.m_6596_();
        }
    }

    @Override
    public void onEntityExit(ServerEntity entity) {
    }

    @Override
    public void setLocked(boolean locked) {
        BlockState blockState = this.m_58904_().m_8055_(this.m_58899_());
        Block block = blockState.m_60734_();
        if (block instanceof ShellBaseBlock) {
            ShellBaseBlock shellBaseBlock = (ShellBaseBlock)block;
            this.m_58904_().m_7731_(this.m_58899_(), (BlockState)blockState.m_61124_((Property)ShellBaseBlock.LOCKED, (Comparable)Boolean.valueOf(locked)), 3);
            this.playDoorLockedSound(locked);
            this.m_6596_();
        }
    }

    @Override
    public boolean locked() {
        return (Boolean)this.m_58900_().m_61143_((Property)ShellBaseBlock.LOCKED);
    }

    @Override
    public BlockPos getTeleportPosition() {
        Direction direction = (Direction)this.m_58900_().m_61143_((Property)ShellBaseBlock.FACING);
        return this.m_58899_().m_121955_(direction.m_122424_().m_122436_());
    }

    @Override
    public Direction getRotation() {
        return (Direction)this.m_58900_().m_61143_((Property)ShellBaseBlock.FACING);
    }

    @Override
    public Direction getTeleportRotation() {
        return ((Direction)this.m_58900_().m_61143_((Property)ShellBaseBlock.FACING)).m_122424_();
    }

    @Override
    public BlockPos getDoorPosition() {
        return this.m_58899_();
    }

    public void playDoorCloseSound(boolean closeDoor) {
        Level currentLevel = this.m_58904_();
        currentLevel.m_5594_(null, this.m_58899_(), closeDoor ? SoundEvents.f_12055_ : SoundEvents.f_12056_, SoundSource.BLOCKS, 1.0f, closeDoor ? 1.4f : 1.0f);
        this.m_6596_();
    }

    public void playDoorLockedSound(boolean lockDoor) {
        Level currentLevel = this.m_58904_();
        currentLevel.m_5594_(null, this.m_58899_(), lockDoor ? BlockSetType.f_271132_.f_271502_() : BlockSetType.f_271132_.f_271141_(), SoundSource.BLOCKS, 1.0f, lockDoor ? 1.4f : 1.0f);
    }

    @Override
    public boolean isInvalidTardis(TardisLevelOperator tardisLevelOperator) {
        BlockPos myPosition = this.m_58899_();
        TardisPilotingManager pilotingManager = tardisLevelOperator.getPilotingManager();
        BlockPos currentLocation = pilotingManager.getCurrentLocation().getPosition();
        BlockPos wantedDestination = pilotingManager.getTargetLocation().getPosition();
        return this.hasPotentialToBeRemoved && !myPosition.equals((Object)currentLocation) && !myPosition.equals((Object)wantedDestination);
    }
}

