/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.common.blockentity.door;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import whocraft.tardis_refined.common.blockentity.door.InternalDoorBlockEntity;
import whocraft.tardis_refined.common.blockentity.door.TardisInternalDoor;
import whocraft.tardis_refined.common.capability.tardis.TardisLevelOperator;
import whocraft.tardis_refined.common.tardis.themes.ShellTheme;
import whocraft.tardis_refined.patterns.ShellPattern;
import whocraft.tardis_refined.patterns.ShellPatterns;
import whocraft.tardis_refined.patterns.sound.ConfiguredSound;
import whocraft.tardis_refined.registry.TRBlockEntityRegistry;

public class GlobalDoorBlockEntity
extends InternalDoorBlockEntity
implements BlockEntityTicker<InternalDoorBlockEntity> {
    private ResourceLocation shellTheme = ShellTheme.HALF_BAKED.getId();
    private ShellPattern basePattern;

    public GlobalDoorBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(TRBlockEntityRegistry.GLOBAL_DOOR_BLOCK.get(), blockPos, blockState);
    }

    public ShellPattern pattern() {
        ShellPattern defaultBasePattern = ShellPatterns.DEFAULT;
        return this.basePattern == null ? defaultBasePattern : this.basePattern;
    }

    public GlobalDoorBlockEntity setPattern(ShellPattern basePattern) {
        this.basePattern = basePattern;
        this.sendUpdates();
        return this;
    }

    public void sendUpdates() {
        this.f_58857_.m_46717_(this.f_58858_, this.m_58900_().m_60734_());
        this.f_58857_.m_7260_(this.f_58858_, this.f_58857_.m_8055_(this.f_58858_), this.f_58857_.m_8055_(this.f_58858_), 3);
        this.m_6596_();
    }

    public ResourceLocation theme() {
        if (this.shellTheme == null) {
            this.shellTheme = ShellTheme.HALF_BAKED.getId();
        }
        return this.shellTheme;
    }

    public void setShellTheme(ResourceLocation shellTheme) {
        this.shellTheme = shellTheme;
        this.m_6596_();
    }

    public CompoundTag m_5995_() {
        CompoundTag compoundTag = new CompoundTag();
        this.m_183515_(compoundTag);
        return compoundTag;
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @Override
    public void m_142466_(CompoundTag pTag) {
        ResourceLocation currentPattern;
        super.m_142466_(pTag);
        if (pTag.m_128441_("theme")) {
            ResourceLocation themeId;
            this.shellTheme = themeId = new ResourceLocation(pTag.m_128461_("theme"));
        }
        if (pTag.m_128441_("pattern") && ShellPatterns.doesPatternExist(this.shellTheme, currentPattern = new ResourceLocation(pTag.m_128461_("pattern")))) {
            this.basePattern = ShellPatterns.getPatternOrDefault(this.shellTheme, currentPattern);
        }
        if (this.shellTheme == null) {
            this.shellTheme = this.theme();
        }
        if (this.basePattern == null) {
            this.basePattern = this.pattern();
        }
    }

    @Override
    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        if (this.shellTheme != null) {
            pTag.m_128359_("theme", this.shellTheme.toString());
        }
        if (this.basePattern != null) {
            pTag.m_128359_("pattern", this.basePattern.id().toString());
        }
    }

    public void onRightClick(BlockState blockState, TardisInternalDoor door, Player player) {
        Level level = this.m_58904_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            TardisLevelOperator.get(serverLevel).ifPresent(cap -> {
                if (cap.getInternalDoor() != door) {
                    cap.setInternalDoor(door);
                }
                if (player.m_6144_() && !cap.getPilotingManager().isInFlight()) {
                    cap.setDoorLocked(!door.locked());
                    if (door.locked()) {
                        cap.setDoorClosed(true);
                    }
                    return;
                }
                if (!door.locked()) {
                    cap.setDoorClosed(door.isOpen());
                    if (player instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)player;
                        if (door.isOpen()) {
                            // empty if block
                        }
                    }
                }
            });
        }
    }

    @Override
    public void playDoorCloseSound(boolean closeDoor) {
        ShellPattern pattern = this.pattern();
        if (pattern != null) {
            Level currentLevel = this.m_58904_();
            pattern.soundProfile().ifPresent(shellSoundProfile -> {
                ConfiguredSound configuredSound = shellSoundProfile.getDoorClose();
                if (configuredSound != null) {
                    currentLevel.m_5594_(null, this.m_58899_(), configuredSound.getSoundEvent(), SoundSource.BLOCKS, configuredSound.getPitch(), configuredSound.getVolume());
                }
            });
        }
    }

    @Override
    public void playDoorLockedSound(boolean lockDoor) {
        ShellPattern pattern = this.pattern();
        if (pattern != null) {
            Level currentLevel = this.m_58904_();
            pattern.soundProfile().ifPresent(shellSoundProfile -> {
                ConfiguredSound configuredSound = shellSoundProfile.getDoorClose();
                if (configuredSound != null) {
                    currentLevel.m_5594_(null, this.m_58899_(), configuredSound.getSoundEvent(), SoundSource.BLOCKS, configuredSound.getPitch(), configuredSound.getVolume());
                }
            });
        }
    }

    public void tick(Level level, BlockPos blockPos, BlockState blockState, InternalDoorBlockEntity blockEntity) {
    }
}

