/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.common.blockentity.door;

import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import whocraft.tardis_refined.common.block.door.BulkHeadDoorBlock;
import whocraft.tardis_refined.registry.TRBlockEntityRegistry;

public class BulkHeadDoorBlockEntity
extends BlockEntity
implements BlockEntityTicker<BulkHeadDoorBlockEntity> {
    public BulkHeadDoorBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(TRBlockEntityRegistry.BULK_HEAD_DOOR.get(), blockPos, blockState);
    }

    public void tick(Level level, BlockPos blockPos, BlockState blockState, BulkHeadDoorBlockEntity blockEntity) {
        if (((Boolean)blockState.m_61143_((Property)BulkHeadDoorBlock.LOCKED)).booleanValue()) {
            return;
        }
        double detectionRadius = 1.5;
        double centerX = (double)blockPos.m_123341_() + 0.5;
        double centerY = (double)blockPos.m_123342_() + 0.5;
        double centerZ = (double)blockPos.m_123343_() + 0.5;
        for (Entity entity : level.m_45976_(Entity.class, new AABB(centerX - detectionRadius, centerY - detectionRadius, centerZ - detectionRadius, centerX + detectionRadius, centerY + detectionRadius, centerZ + detectionRadius))) {
            if (!(entity instanceof LivingEntity)) continue;
            this.toggleDoor(level, blockPos, blockState, true);
            return;
        }
        this.toggleDoor(level, blockPos, blockState, false);
    }

    public void toggleDoor(Level level, BlockPos blockPos, BlockState blockState, boolean isOpen) {
        if (level.m_8055_(blockPos).m_61138_((Property)BulkHeadDoorBlock.OPEN) && (Boolean)level.m_8055_(blockPos).m_61143_((Property)BulkHeadDoorBlock.OPEN) != isOpen) {
            level.m_5594_(null, blockPos, !isOpen ? SoundEvents.f_12312_ : SoundEvents.f_12311_, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        level.m_7731_(blockPos, (BlockState)blockState.m_61124_((Property)BulkHeadDoorBlock.OPEN, (Comparable)Boolean.valueOf(isOpen)), 2);
    }
}

